(ns simplelog.core
  (:import 
    [java.util.Date]
    [java.text.DateFormat]))

(defn timestamp []
  (str "[" (.toGMTString (java.util.Date.)) "]"))

(defn thread-id []
  (.getId (Thread/currentThread)))

(defn define-level [level]
  `(defn ~level [& anything#]
     (when (@enabled-levels '~level)
       (apply println (simplelog.core/timestamp)
         (str "[thread=" (simplelog.core/thread-id) "]")
         (.toUpperCase (str "[" '~level "]"))
         anything#))))

(def enabled-levels (atom #{}))

(defmacro log-levels [& levels]
  `(do
     ~@(map simplelog.core/define-level levels)
     (reset! simplelog.core/enabled-levels (into #{} '~levels))))

(defn silence!
  [& levels]
  (doseq [level levels]
    (swap! enabled-levels disj (-> level name symbol))))

(defn enable!
  [& levels]
  (doseq [level levels]
    (swap! enabled-levels conj (-> level name symbol))))
