;; Copyright (c) 2016 wicdmedia Development Team

;; This Source Code Form is subject to the terms of the
;; Mozilla Public License, v. 2.0. If a copy of the MPL
;; was not distributed with this file, You can obtain
;; one at https://mozilla.org/MPL/2.0/.

(ns wicdmedia.halcyon.places
  (#?(:clj  :require
      :cljs :require-macros) [wicdmedia.halcyon.halcyon :refer [deficon]])
  (:refer-clojure :only []))

(deficon ac-unit
  24 [[:path {:d "M22 11h-4.17l3.24-3.24-1.41-1.42L15 11h-2V9l4.66-4.66-1.42-1.41L13 6.17V2h-2v4.17L7.76 2.93 6.34 4.34 11 9v2H9L4.34 6.34 2.93 7.76 6.17 11H2v2h4.17l-3.24 3.24 1.41 1.42L9 13h2v2l-4.66 4.66 1.42 1.41L11 17.83V22h2v-4.17l3.24 3.24 1.42-1.41L13 15v-2h2l4.66 4.66 1.41-1.42L17.83 13H22z"}]]
  48 [[:path {:d "M44 22h-8.34l6.48-6.49-2.83-2.82L30 22h-4v-4l9.31-9.31-2.82-2.83L26 12.34V4h-4v8.34l-6.49-6.48-2.82 2.83L22 18v4h-4l-9.31-9.31-2.83 2.82L12.34 22H4v4h8.34l-6.48 6.49 2.83 2.82L18 26h4v4l-9.31 9.31 2.82 2.83L22 35.66V44h4v-8.34l6.49 6.48 2.82-2.83L26 30v-4h4l9.31 9.31 2.83-2.82L35.66 26H44z"}]])

(deficon airport-shuttle
  24 [[:path {:d "M17 5H3c-1.1 0-2 .89-2 2v9h2c0 1.65 1.34 3 3 3s3-1.35 3-3h5.5c0 1.65 1.34 3 3 3s3-1.35 3-3H23v-5l-6-6zM3 11V7h4v4H3zm3 6.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm7-6.5H9V7h4v4zm4.5 6.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM15 11V7h1l4 4h-5z"}]]
  48 [[:path {:d "M34 10H6c-2.21 0-4 1.79-4 4v18h4c0 3.31 2.69 6 6 6s6-2.69 6-6h11c0 3.31 2.69 6 6 6s6-2.69 6-6h5V22L34 10zM6 22v-8h8v8H6zm6 13c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm14-13h-8v-8h8v8zm9 13c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm-5-13v-8h2l8 8H30z"}]])

(deficon all-inclusive
  24 [[:path {:d "M18.6 6.62c-1.44 0-2.8.56-3.77 1.53L12 10.66 10.48 12h.01L7.8 14.39c-.64.64-1.49.99-2.4.99-1.87 0-3.39-1.51-3.39-3.38S3.53 8.62 5.4 8.62c.91 0 1.76.35 2.44 1.03l1.13 1 1.51-1.34L9.22 8.2C8.2 7.18 6.84 6.62 5.4 6.62 2.42 6.62 0 9.04 0 12s2.42 5.38 5.4 5.38c1.44 0 2.8-.56 3.77-1.53l2.83-2.5.01.01L13.52 12h-.01l2.69-2.39c.64-.64 1.49-.99 2.4-.99 1.87 0 3.39 1.51 3.39 3.38s-1.52 3.38-3.39 3.38c-.9 0-1.76-.35-2.44-1.03l-1.14-1.01-1.51 1.34 1.27 1.12c1.02 1.01 2.37 1.57 3.82 1.57 2.98 0 5.4-2.41 5.4-5.38s-2.42-5.37-5.4-5.37z"}]]
  48 [[:path {:d "M37.2 13.25c-2.88 0-5.6 1.12-7.55 3.07l-5.65 5-.01-.01-3.03 2.67.02.02-5.39 4.78c-1.28 1.27-2.98 1.97-4.79 1.97-3.74 0-6.78-3.03-6.78-6.75s3.04-6.75 6.78-6.75c1.81 0 3.51.7 4.88 2.06l2.27 2.01 3.02-2.67-2.53-2.24c-2.04-2.03-4.75-3.15-7.64-3.15C4.84 13.25 0 18.07 0 24s4.84 10.75 10.8 10.75c2.88 0 5.59-1.12 7.55-3.06L24 26.68l.01.01 3.02-2.68-.01-.01 5.39-4.77c1.28-1.28 2.98-1.98 4.79-1.98 3.74 0 6.78 3.03 6.78 6.75s-3.04 6.75-6.78 6.75c-1.81 0-3.51-.7-4.88-2.05l-2.27-2.01-3.02 2.68 2.53 2.24c2.04 2.03 4.75 3.14 7.63 3.14C43.16 34.75 48 29.93 48 24s-4.84-10.75-10.8-10.75z"}]])

(deficon beach-access
  24 [[:path {:d "M13.127 14.56l1.43-1.43 6.44 6.443L19.57 21zm4.293-5.73l2.86-2.86c-3.95-3.95-10.35-3.96-14.3-.02 3.93-1.3 8.31-.25 11.44 2.88zM5.95 5.98c-3.94 3.95-3.93 10.35.02 14.3l2.86-2.86C5.7 14.29 4.65 9.91 5.95 5.98zm.02-.02l-.01.01c-.38 3.01 1.17 6.88 4.3 10.02l5.73-5.73c-3.13-3.13-7.01-4.68-10.02-4.3z"}]]
  48 [[:path {:d "M26.248 29.11l2.863-2.862 12.9 12.89-2.86 2.864zm8.592-11.45l5.73-5.73c-7.9-7.9-20.7-7.91-28.61-.02 7.87-2.61 16.62-.52 22.88 5.75zm-22.93-5.71c-7.88 7.91-7.88 20.71.02 28.61l5.73-5.73c-6.27-6.25-8.36-15-5.75-22.88zm.04-.03c-.01.01-.01.01-.02.01-.01.01-.01.01-.01.02-.75 6.02 2.34 13.77 8.61 20.03l11.46-11.46c-6.28-6.26-14.02-9.36-20.04-8.6z"}]])

(deficon business-center
  24 [[:path {:d "M10 16v-1H3.01L3 19c0 1.11.89 2 2 2h14c1.11 0 2-.89 2-2v-4h-7v1h-4zm10-9h-4.01V5l-2-2h-4l-2 2v2H4c-1.1 0-2 .9-2 2v3c0 1.11.89 2 2 2h6v-2h4v2h6c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zm-6 0h-4V5h4v2z"}]]
  48 [[:path {:d "M20 32v-2H6.02L6 38c0 2.22 1.78 4 4 4h28c2.22 0 4-1.78 4-4v-8H28v2h-8zm20-18h-8.02v-4l-4-4h-8L16 10v4H8.01c-2.21 0-4 1.79-4 4v6c0 2.21 1.79 4 4 4h12v-4h8v4h12c2.21 0 4-1.79 4-4v-6c-.01-2.21-1.8-4-4.01-4zm-12.01 0h-8v-4h8v4z"}]])

(deficon casino
  24 [[:path {:d "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM7.5 18c-.83 0-1.5-.67-1.5-1.5S6.67 15 7.5 15s1.5.67 1.5 1.5S8.33 18 7.5 18zm0-9C6.67 9 6 8.33 6 7.5S6.67 6 7.5 6 9 6.67 9 7.5 8.33 9 7.5 9zm4.5 4.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5 4.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm0-9c-.83 0-1.5-.67-1.5-1.5S15.67 6 16.5 6s1.5.67 1.5 1.5S17.33 9 16.5 9z"}]]
  48 [[:path {:d "M38 6H10c-2.21 0-4 1.79-4 4v28c0 2.21 1.79 4 4 4h28c2.21 0 4-1.79 4-4V10c0-2.21-1.79-4-4-4zM15 36c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm0-18c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm9 9c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm9 9c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm0-18c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z"}]])

(deficon child-care
  24 [[:circle {:cy "10.5" :cx "14.5" :r "1.25"}]
      [:circle {:cy "10.5" :cx "9.5" :r "1.25"}]
      [:path {:d "M22.94 12.66c.04-.21.06-.43.06-.66s-.02-.45-.06-.66c-.25-1.51-1.36-2.74-2.81-3.17-.53-1.12-1.28-2.1-2.19-2.91C16.36 3.85 14.28 3 12 3s-4.36.85-5.94 2.26c-.92.81-1.67 1.8-2.19 2.91-1.45.43-2.56 1.65-2.81 3.17-.04.21-.06.43-.06.66s.02.45.06.66c.25 1.51 1.36 2.74 2.81 3.17.52 1.11 1.27 2.09 2.17 2.89C7.62 20.14 9.71 21 12 21s4.38-.86 5.97-2.28c.9-.8 1.65-1.79 2.17-2.89 1.44-.43 2.55-1.65 2.8-3.17zM19 14c-.1 0-.19-.02-.29-.03-.2.67-.49 1.29-.86 1.86C16.6 17.74 14.45 19 12 19s-4.6-1.26-5.85-3.17c-.37-.57-.66-1.19-.86-1.86-.1.01-.19.03-.29.03-1.1 0-2-.9-2-2s.9-2 2-2c.1 0 .19.02.29.03.2-.67.49-1.29.86-1.86C7.4 6.26 9.55 5 12 5s4.6 1.26 5.85 3.17c.37.57.66 1.19.86 1.86.1-.01.19-.03.29-.03 1.1 0 2 .9 2 2s-.9 2-2 2zM7.5 14c.76 1.77 2.49 3 4.5 3s3.74-1.23 4.5-3h-9z"}]]
  48 [[:circle {:cy "21" :cx "29" :r "2.5"}]
      [:circle {:cy "21" :cx "19" :r "2.5"}]
      [:path {:d "M45.89 25.33c.07-.43.11-.88.11-1.33s-.04-.9-.11-1.33c-.51-3.02-2.72-5.47-5.61-6.34-1.05-2.23-2.56-4.21-4.39-5.82C32.72 7.71 28.56 6 24 6s-8.72 1.71-11.89 4.51c-1.83 1.62-3.33 3.59-4.39 5.82-2.89.86-5.1 3.31-5.61 6.34-.07.43-.11.88-.11 1.33s.04.9.11 1.33c.51 3.02 2.72 5.47 5.61 6.34 1.04 2.21 2.53 4.17 4.34 5.78C15.24 40.27 19.41 42 24 42s8.76-1.73 11.94-4.55c1.81-1.61 3.3-3.57 4.34-5.78 2.89-.87 5.1-3.32 5.61-6.34zM38 28c-.2 0-.39-.03-.57-.06-.39 1.33-.98 2.58-1.72 3.72C33.2 35.47 28.89 38 24 38s-9.2-2.53-11.7-6.34c-.75-1.14-1.33-2.39-1.72-3.72-.19.03-.38.06-.58.06-2.2 0-4-1.8-4-4s1.8-4 4-4c.2 0 .39.03.57.06.39-1.33.98-2.58 1.72-3.72C14.8 12.53 19.11 10 24 10s9.2 2.53 11.7 6.34c.75 1.14 1.33 2.39 1.72 3.72.19-.03.38-.06.58-.06 2.2 0 4 1.8 4 4s-1.8 4-4 4zm-23 0c1.52 3.53 4.97 6 9 6s7.48-2.47 9-6H15z"}]])

(deficon child-friendly
  24 [[:path {:d "M13 2v8h8c0-4.42-3.58-8-8-8zm6.32 13.89C20.37 14.54 21 12.84 21 11H6.44l-.95-2H2v2h2.22s1.89 4.07 2.12 4.42c-1.1.59-1.84 1.75-1.84 3.08C4.5 20.43 6.07 22 8 22c1.76 0 3.22-1.3 3.46-3h2.08c.24 1.7 1.7 3 3.46 3 1.93 0 3.5-1.57 3.5-3.5 0-1.04-.46-1.97-1.18-2.61zM8 20c-.83 0-1.5-.67-1.5-1.5S7.17 17 8 17s1.5.67 1.5 1.5S8.83 20 8 20zm9 0c-.83 0-1.5-.67-1.5-1.5S16.17 17 17 17s1.5.67 1.5 1.5S17.83 20 17 20z"}]]
  48 [[:path {:d "M26 4v16h16c0-8.84-7.16-16-16-16zm12.65 27.78C40.74 29.07 42 25.69 42 22H12.88l-1.9-4H4v4h4.45s3.78 8.14 4.24 8.83C10.49 32.02 9 34.33 9 37c0 3.87 3.13 7 7 7 3.53 0 6.43-2.61 6.92-6h4.16c.49 3.39 3.39 6 6.92 6 3.87 0 7-3.13 7-7 0-2.08-.91-3.94-2.35-5.22zM16 40c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm18 0c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z"}]])

(deficon fitness-center
  24 [[:path {:d "M20.57 14.86L22 13.43 20.57 12 17 15.57 8.43 7 12 3.43 10.57 2 9.14 3.43 7.71 2 5.57 4.14 4.14 2.71 2.71 4.14l1.43 1.43L2 7.71l1.43 1.43L2 10.57 3.43 12 7 8.43 15.57 17 12 20.57 13.43 22l1.43-1.43L16.29 22l2.14-2.14 1.43 1.43 1.43-1.43-1.43-1.43L22 16.29z"}]]
  48 [[:path {:d "M41.14 29.71L44 26.86 41.14 24 34 31.14 16.86 14 24 6.86 21.14 4l-2.85 2.86L15.43 4l-4.29 4.29-2.85-2.86-2.86 2.86 2.86 2.85L4 15.43l2.86 2.86L4 21.14 6.86 24 14 16.86 31.14 34 24 41.14 26.86 44l2.85-2.86L32.57 44l4.29-4.29 2.85 2.86 2.86-2.86-2.86-2.85L44 32.57z"}]])

(deficon free-breakfast
  24 [[:path {:d "M20 3H4v10c0 2.21 1.79 4 4 4h6c2.21 0 4-1.79 4-4v-3h2c1.11 0 2-.9 2-2V5c0-1.11-.89-2-2-2zm0 5h-2V5h2v3zM4 19h16v2H4z"}]]
  48 [[:path {:d "M40 6H8v20c0 4.42 3.58 8 8 8h12c4.42 0 8-3.58 8-8v-6h4c2.21 0 4-1.79 4-4v-6c0-2.21-1.79-4-4-4zm0 10h-4v-6h4v6zM8 38h32v4H8z"}]])

(deficon golf-course
  24 [[:circle {:cy "19.5" :cx "19.5" :r "1.5"}]
      [:path {:d "M17 5.92L9 2v18H7v-1.73c-1.79.35-3 .99-3 1.73 0 1.1 2.69 2 6 2s6-.9 6-2c0-.99-2.16-1.81-5-1.97V8.98l6-3.06z"}]]
  48 [[:path {:d "M39 36c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm-5-24.15L18 4v36h-4v-3.46c-3.58.69-6 1.98-6 3.46 0 2.21 5.37 4 12 4s12-1.79 12-4c0-1.98-4.33-3.62-10-3.94v-18.1l12-6.11z"}]])

(deficon hot-tub
  24 [[:circle {:cy "6" :cx "7" :r "2"}]
      [:path {:d "M11.15 12c-.31-.22-.59-.46-.82-.72l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C6.01 9 5 10.01 5 11.25V12H2v8c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-8H11.15zM7 20H5v-6h2v6zm4 0H9v-6h2v6zm4 0h-2v-6h2v6zm4 0h-2v-6h2v6zm-.35-14.14l-.07-.07c-.57-.62-.82-1.41-.67-2.2L18 3h-1.89l-.06.43c-.2 1.36.27 2.71 1.3 3.72l.07.06c.57.62.82 1.41.67 2.2l-.11.59h1.91l.06-.43c.21-1.36-.27-2.71-1.3-3.71zm-4 0l-.07-.07c-.57-.62-.82-1.41-.67-2.2L14 3h-1.89l-.06.43c-.2 1.36.27 2.71 1.3 3.72l.07.06c.57.62.82 1.41.67 2.2l-.11.59h1.91l.06-.43c.21-1.36-.27-2.71-1.3-3.71z"}]]
  48 [[:circle {:cy "12" :cx "14" :r "4"}]
      [:path {:d "M22.3 24c-.61-.45-1.17-.93-1.64-1.44l-2.8-3.1c-.38-.42-.86-.76-1.38-1-.58-.28-1.24-.46-1.92-.46h-.06c-2.48 0-4.5 2.02-4.5 4.5V24H4v16c0 2.21 1.79 4 4 4h32c2.21 0 4-1.79 4-4V24H22.3zM14 40h-4V28h4v12zm8 0h-4V28h4v12zm8 0h-4V28h4v12zm8 0h-4V28h4v12zm-.69-28.29l-.14-.13c-1.15-1.23-1.63-2.82-1.34-4.39L36 6h-3.78l-.13.85c-.41 2.72.54 5.43 2.6 7.43l.13.12c1.15 1.23 1.64 2.83 1.35 4.4l-.22 1.2h3.83l.13-.85c.4-2.72-.54-5.43-2.6-7.44zm-8 0l-.14-.13c-1.15-1.23-1.63-2.82-1.34-4.39L28 6h-3.78l-.13.85c-.41 2.72.54 5.43 2.6 7.43l.13.12c1.15 1.23 1.64 2.83 1.35 4.4l-.22 1.2h3.83l.13-.85c.4-2.72-.54-5.43-2.6-7.44z"}]])

(deficon kitchen
  24 [[:path {:d "M18 2.01L6 2c-1.1 0-2 .89-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.11-.9-1.99-2-1.99zM18 20H6v-9.02h12V20zm0-11H6V4h12v5zM8 5h2v3H8zm0 7h2v5H8z"}]]
  48 [[:path {:d "M36 4.02L12 4C9.79 4 8 5.79 8 8v32c0 2.21 1.79 4 4 4h24c2.21 0 4-1.79 4-4V8c0-2.21-1.79-3.98-4-3.98zM36 40H12V21.95h24V40zm0-22H12V8h24v10zm-20-8h4v6h-4zm0 14h4v10h-4z"}]])

(deficon pool
  24 [[:path {:d "M22 21c-1.11 0-1.73-.37-2.18-.64-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.46.27-1.07.64-2.18.64s-1.73-.37-2.18-.64c-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.46.27-1.08.64-2.19.64-1.11 0-1.73-.37-2.18-.64-.37-.23-.6-.36-1.15-.36s-.78.13-1.15.36c-.46.27-1.08.64-2.19.64v-2c.56 0 .78-.13 1.15-.36.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.23.59.36 1.15.36.56 0 .78-.13 1.15-.36.46-.27 1.08-.64 2.19-.64 1.11 0 1.73.37 2.18.64.37.22.6.36 1.15.36s.78-.13 1.15-.36c.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.23.59.36 1.15.36v2zm0-4.5c-1.11 0-1.73-.37-2.18-.64-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.45.27-1.07.64-2.18.64s-1.73-.37-2.18-.64c-.37-.22-.6-.36-1.15-.36-.56 0-.78.13-1.15.36-.45.27-1.07.64-2.18.64s-1.73-.37-2.18-.64c-.37-.22-.6-.36-1.15-.36s-.78.13-1.15.36c-.47.27-1.09.64-2.2.64v-2c.56 0 .78-.13 1.15-.36.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36.56 0 .78-.13 1.15-.36.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36s.78-.13 1.15-.36c.45-.27 1.07-.64 2.18-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36v2zM8.67 12c.56 0 .78-.13 1.15-.36.46-.27 1.08-.64 2.19-.64 1.11 0 1.73.37 2.18.64.37.22.6.36 1.15.36s.78-.13 1.15-.36c.12-.07.26-.15.41-.23L10.48 5C8.93 3.45 7.5 2.99 5 3v2.5c1.82-.01 2.89.39 4 1.5l1 1-3.25 3.25c.31.12.56.27.77.39.37.23.59.36 1.15.36z"}]
      [:circle {:cy "5.5" :cx "16.5" :r "2.5"}]]
  48 [[:path {:d "M44 42c-2.22 0-3.46-.74-4.36-1.29-.74-.44-1.19-.71-2.3-.71-1.11 0-1.56.27-2.3.71-.9.54-2.14 1.29-4.36 1.29s-3.46-.74-4.36-1.29c-.74-.45-1.19-.71-2.3-.71-1.11 0-1.56.27-2.3.71-.92.55-2.16 1.29-4.38 1.29-2.22 0-3.46-.74-4.36-1.28-.74-.45-1.19-.72-2.31-.72s-1.56.27-2.31.72C7.46 41.26 6.22 42 4 42v-4c1.11 0 1.56-.27 2.31-.72.9-.54 2.14-1.28 4.36-1.28s3.46.74 4.36 1.28c.74.45 1.19.72 2.31.72 1.11 0 1.56-.27 2.3-.71.9-.54 2.14-1.29 4.36-1.29s3.46.74 4.36 1.29c.74.45 1.19.71 2.3.71s1.56-.27 2.3-.71c.9-.54 2.14-1.29 4.36-1.29s3.46.74 4.36 1.29c.76.44 1.21.71 2.32.71v4zm0-9c-2.22 0-3.46-.74-4.36-1.29-.74-.44-1.19-.71-2.3-.71-1.11 0-1.56.27-2.3.71-.9.54-2.14 1.29-4.36 1.29s-3.46-.74-4.36-1.29c-.74-.45-1.19-.71-2.3-.71-1.11 0-1.56.27-2.3.71-.92.55-2.16 1.29-4.38 1.29-2.22 0-3.46-.74-4.36-1.28-.74-.45-1.19-.72-2.31-.72s-1.56.27-2.31.72C7.46 32.26 6.22 33 4 33v-4c1.11 0 1.56-.27 2.31-.72.9-.54 2.14-1.28 4.36-1.28s3.46.74 4.36 1.28c.74.45 1.19.72 2.31.72 1.11 0 1.56-.27 2.3-.71.9-.54 2.14-1.29 4.36-1.29s3.46.74 4.36 1.29c.74.45 1.19.71 2.3.71s1.56-.27 2.3-.71c.9-.54 2.14-1.29 4.36-1.29s3.46.74 4.36 1.29c.76.44 1.21.71 2.32.71v4zm-26.66-9c1.11 0 1.56-.27 2.3-.71.9-.54 2.14-1.29 4.36-1.29s3.46.74 4.36 1.29c.74.45 1.19.71 2.3.71s1.56-.27 2.3-.71c.24-.15.51-.3.81-.46L20.96 10C17.85 6.89 15 5.98 10 6v5c3.64-.02 5.77.78 8 3l2 2-6.5 6.5c.62.24 1.12.53 1.54.78.74.45 1.19.72 2.3.72z"}]
      [:circle {:cy "11" :cx "33" :r "5"}]])

(deficon room-service
  24 [[:path {:d "M2 17h20v2H2zm11.84-9.21c.1-.24.16-.51.16-.79 0-1.1-.9-2-2-2s-2 .9-2 2c0 .28.06.55.16.79C6.25 8.6 3.27 11.93 3 16h18c-.27-4.07-3.25-7.4-7.16-8.21z"}]]
  48 [[:path {:d "M4 34h40v4H4zm23.67-18.42c.21-.48.33-1.02.33-1.58 0-2.21-1.79-4-4-4s-4 1.79-4 4c0 .56.12 1.1.33 1.58C12.5 17.2 6.54 23.86 6 32h36c-.54-8.14-6.5-14.8-14.33-16.42z"}]])

(deficon smoke-free
  24 [[:path {:d "M2 6l6.99 7H2v3h9.99l7 7 1.26-1.25-17-17zm18.5 7H22v3h-1.5zM18 13h1.5v3H18zm.85-8.12c.62-.61 1-1.45 1-2.38h-1.5c0 1.02-.83 1.85-1.85 1.85v1.5c2.24 0 4 1.83 4 4.07V12H22V9.92c0-2.23-1.28-4.15-3.15-5.04zM14.5 8.7h1.53c1.05 0 1.97.74 1.97 2.05V12h1.5v-1.59c0-1.8-1.6-3.16-3.47-3.16H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75V2c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35zm2.5 7.23V13h-2.93z"}]]
  48 [[:path {:d "M4 12l13.99 14H4v6h19.99l13.99 14 2.52-2.5-34-34zm37 14h3v6h-3zm-5 0h3v6h-3zm1.7-16.24c1.23-1.21 2-2.9 2-4.76h-3c0 2.04-1.66 3.7-3.7 3.7v3c4.49 0 8 3.65 8 8.14V24h3v-4.17c0-4.45-2.56-8.29-6.3-10.07zM29 17.39h3.06c2.09 0 3.94 1.48 3.94 4.11V24h3v-3.18c0-3.61-3.2-6.32-6.94-6.32H29c-2.04 0-3.7-1.96-3.7-4S26.96 7 29 7V4c-3.69 0-6.7 3-6.7 6.7s3.01 6.69 6.7 6.69zm5 14.46V26h-5.85z"}]])

(deficon smoking-rooms
  24 [[:path {:d "M2 16h15v3H2zm18.5 0H22v3h-1.5zM18 16h1.5v3H18zm.85-8.27c.62-.61 1-1.45 1-2.38C19.85 3.5 18.35 2 16.5 2v1.5c1.02 0 1.85.83 1.85 1.85S17.52 7.2 16.5 7.2v1.5c2.24 0 4 1.83 4 4.07V15H22v-2.24c0-2.22-1.28-4.14-3.15-5.03zm-2.82 2.47H14.5c-1.02 0-1.85-.98-1.85-2s.83-1.75 1.85-1.75v-1.5c-1.85 0-3.35 1.5-3.35 3.35s1.5 3.35 3.35 3.35h1.53c1.05 0 1.97.74 1.97 2.05V15h1.5v-1.64c0-1.81-1.6-3.16-3.47-3.16z"}]]
  48 [[:path {:d "M4 32h30v6H4zm37 0h3v6h-3zm-5 0h3v6h-3zm1.7-16.54c1.23-1.21 2-2.9 2-4.76C39.7 7 36.69 4 33 4v3c2.04 0 3.7 1.66 3.7 3.7s-1.66 3.7-3.7 3.7v3c4.49 0 8 3.65 8 8.14V30h3v-4.47c0-4.45-2.56-8.29-6.3-10.07zm-5.64 4.93H29v.01c-2.04 0-3.7-1.96-3.7-4s1.66-3.5 3.7-3.5v-3c-3.69 0-6.7 3-6.7 6.7s3 6.7 6.7 6.7v-.01h3.06c2.09 0 3.94 1.48 3.94 4.11V30h3v-3.29c0-3.6-3.2-6.32-6.94-6.32z"}]])

(deficon spa
  24 [[:path {:d "M8.55 12c-1.07-.71-2.25-1.27-3.53-1.61 1.28.34 2.46.9 3.53 1.61zm10.43-1.61c-1.29.34-2.49.91-3.57 1.64 1.08-.73 2.28-1.3 3.57-1.64z"}]
      [:path {:d "M15.49 9.63c-.18-2.79-1.31-5.51-3.43-7.63-2.14 2.14-3.32 4.86-3.55 7.63 1.28.68 2.46 1.56 3.49 2.63 1.03-1.06 2.21-1.94 3.49-2.63zm-6.5 2.65c-.14-.1-.3-.19-.45-.29.15.11.31.19.45.29zm6.42-.25c-.13.09-.27.16-.4.26.13-.1.27-.17.4-.26zM12 15.45C9.85 12.17 6.18 10 2 10c0 5.32 3.36 9.82 8.03 11.49.63.23 1.29.4 1.97.51.68-.12 1.33-.29 1.97-.51C18.64 19.82 22 15.32 22 10c-4.18 0-7.85 2.17-10 5.45z"}]]
  48 [[:path {:d "M17.09 24c-2.14-1.43-4.5-2.55-7.05-3.22 2.55.67 4.91 1.79 7.05 3.22zm20.87-3.22c-2.58.68-4.97 1.82-7.14 3.27 2.16-1.45 4.55-2.59 7.14-3.27z"}]
      [:path {:d "M30.99 19.27C30.62 13.69 28.36 8.24 24.12 4c-4.28 4.28-6.64 9.72-7.1 15.27 2.56 1.37 4.93 3.12 6.98 5.25 2.05-2.13 4.42-3.89 6.99-5.25zm-13 5.3c-.28-.21-.6-.38-.89-.57.29.19.6.36.89.57zm12.83-.52c-.26.18-.55.33-.8.51.25-.18.53-.33.8-.51zM24 30.91C19.7 24.34 12.35 20 4 20c0 10.63 6.72 19.65 16.07 22.97 1.27.45 2.58.79 3.93 1.03 1.35-.23 2.66-.57 3.93-1.03C37.28 39.65 44 30.63 44 20c-8.35 0-15.7 4.34-20 10.91z"}]])
