;; Copyright (c) 2016 wicdmedia Development Team

;; This Source Code Form is subject to the terms of the
;; Mozilla Public License, v. 2.0. If a copy of the MPL
;; was not distributed with this file, You can obtain
;; one at https://mozilla.org/MPL/2.0/.

(ns wicdmedia.halcyon.navigation
  (#?(:clj  :require
      :cljs :require-macros) [wicdmedia.halcyon.halcyon :refer [deficon]])
  (:refer-clojure :only []))

(deficon apps
  18 [[:path {:d "M2 10h3V7H2v3zm0-5h3V2H2v3zm0 10h3v-3H2v3zm5 0h3v-3H7v3zm5-5h3V7h-3v3zm-5 0h3V7H7v3zm5 5h3v-3h-3v3zm0-13v3h3V2h-3zM7 5h3V2H7v3z"}]]
  24 [[:path {:d "M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z"}]]
  36 [[:path {:d "M6 12h6V6H6v6zm9 18h6v-6h-6v6zm-9 0h6v-6H6v6zm0-9h6v-6H6v6zm9 0h6v-6h-6v6zm9-15v6h6V6h-6zm-9 6h6V6h-6v6zm9 9h6v-6h-6v6zm0 9h6v-6h-6v6z"}]]
  48 [[:path {:d "M8 16h8V8H8v8zm12 24h8v-8h-8v8zM8 40h8v-8H8v8zm0-12h8v-8H8v8zm12 0h8v-8h-8v8zM32 8v8h8V8h-8zm-12 8h8V8h-8v8zm12 12h8v-8h-8v8zm0 12h8v-8h-8v8z"}]])

(deficon arrow-back
  18 [[:path {:d "M15 8.25H5.87l4.19-4.19L9 3 3 9l6 6 1.06-1.06-4.19-4.19H15v-1.5z"}]]
  24 [[:path {:d "M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"}]]
  36 [[:path {:d "M30 16.5H11.74l8.38-8.38L18 6 6 18l12 12 2.12-2.12-8.38-8.38H30v-3z"}]]
  48 [[:path {:d "M40 22H15.66l11.17-11.17L24 8 8 24l16 16 2.83-2.83L15.66 26H40v-4z"}]])

(deficon arrow-downward
  24 [[:path {:d "M20 12l-1.41-1.41L13 16.17V4h-2v12.17l-5.58-5.59L4 12l8 8 8-8z"}]]
  48 [[:path {:d "M40 24l-2.82-2.82L26 32.34V8h-4v24.34L10.84 21.16 8 24l16 16 16-16z"}]])

(deficon arrow-drop-down
  18 [[:path {:d "M5 8l4 4 4-4z"}]]
  24 [[:path {:d "M7 10l5 5 5-5z"}]]
  36 [[:path {:d "M10.5 15l7.5 7.5 7.5-7.5z"}]]
  48 [[:path {:d "M14 20l10 10 10-10z"}]])

(deficon arrow-drop-down-circle
  24 [[:path {:d "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 12l-4-4h8l-4 4z"}]]
  48 [[:path {:d "M24 4C12.95 4 4 12.95 4 24s8.95 20 20 20 20-8.95 20-20S35.05 4 24 4zm0 24l-8-8h16l-8 8z"}]])

(deficon arrow-drop-up
  18 [[:path {:d "M9 6l-4 4h8z"}]]
  24 [[:path {:d "M7 14l5-5 5 5z"}]]
  36 [[:path {:d "M10.5 21l7.5-7.5 7.5 7.5z"}]]
  48 [[:path {:d "M14 28l10-10 10 10z"}]])

(deficon arrow-forward
  18 [[:path {:d "M9 3L7.94 4.06l4.19 4.19H3v1.5h9.13l-4.19 4.19L9 15l6-6z"}]]
  24 [[:path {:d "M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"}]]
  36 [[:path {:d "M18 6l-2.12 2.12 8.38 8.38H6v3h18.26l-8.38 8.38L18 30l12-12z"}]]
  48 [[:path {:d "M24 8l-2.83 2.83L32.34 22H8v4h24.34L21.17 37.17 24 40l16-16z"}]])

(deficon arrow-upward
  24 [[:path {:d "M4 12l1.41 1.41L11 7.83V20h2V7.83l5.58 5.59L20 12l-8-8-8 8z"}]]
  48 [[:path {:d "M8 24l2.83 2.83L22 15.66V40h4V15.66l11.17 11.17L40 24 24 8 8 24z"}]])

(deficon cancel
  18 [[:path {:d "M9 1C4.58 1 1 4.58 1 9s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm4 10.87L11.87 13 9 10.13 6.13 13 5 11.87 7.87 9 5 6.13 6.13 5 9 7.87 11.87 5 13 6.13 10.13 9 13 11.87z"}]]
  24 [[:path {:d "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z"}]]
  36 [[:path {:d "M18 3C9.71 3 3 9.71 3 18s6.71 15 15 15 15-6.71 15-15S26.29 3 18 3zm7.5 20.38l-2.12 2.12L18 20.12l-5.38 5.38-2.12-2.12L15.88 18l-5.38-5.38 2.12-2.12L18 15.88l5.38-5.38 2.12 2.12L20.12 18l5.38 5.38z"}]]
  48 [[:path {:d "M24 4C12.95 4 4 12.95 4 24s8.95 20 20 20 20-8.95 20-20S35.05 4 24 4zm10 27.17L31.17 34 24 26.83 16.83 34 14 31.17 21.17 24 14 16.83 16.83 14 24 21.17 31.17 14 34 16.83 26.83 24 34 31.17z"}]])

(deficon check
  18 [[:path {:d "M6.61 11.89L3.5 8.78 2.44 9.84 6.61 14l8.95-8.95L14.5 4z"}]]
  24 [[:path {:d "M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"}]]
  36 [[:path {:d "M13.5 24.26L7.24 18l-2.12 2.12 8.38 8.38 18-18-2.12-2.12z"}]]
  48 [[:path {:d "M18 32.34L9.66 24l-2.83 2.83L18 38l24-24-2.83-2.83z"}]])

(deficon chevron-left
  18 [[:path {:d "M11.56 5.56L10.5 4.5 6 9l4.5 4.5 1.06-1.06L8.12 9z"}]]
  24 [[:path {:d "M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"}]]
  36 [[:path {:d "M23.12 11.12L21 9l-9 9 9 9 2.12-2.12L16.24 18z"}]]
  48 [[:path {:d "M30.83 14.83L28 12 16 24l12 12 2.83-2.83L21.66 24z"}]])

(deficon chevron-right
  18 [[:path {:d "M7.5 4.5L6.44 5.56 9.88 9l-3.44 3.44L7.5 13.5 12 9z"}]]
  24 [[:path {:d "M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"}]]
  36 [[:path {:d "M15 9l-2.12 2.12L19.76 18l-6.88 6.88L15 27l9-9z"}]]
  48 [[:path {:d "M20 12l-2.83 2.83L26.34 24l-9.17 9.17L20 36l12-12z"}]])

(deficon close
  18 [[:path {:d "M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z"}]]
  24 [[:path {:d "M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"}]]
  36 [[:path {:d "M28.5 9.62L26.38 7.5 18 15.88 9.62 7.5 7.5 9.62 15.88 18 7.5 26.38l2.12 2.12L18 20.12l8.38 8.38 2.12-2.12L20.12 18z"}]]
  48 [[:path {:d "M38 12.83L35.17 10 24 21.17 12.83 10 10 12.83 21.17 24 10 35.17 12.83 38 24 26.83 35.17 38 38 35.17 26.83 24z"}]])

(deficon expand-less
  18 [[:path {:d "M9 6l-4.5 4.5 1.06 1.06L9 8.12l3.44 3.44 1.06-1.06z"}]]
  24 [[:path {:d "M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"}]]
  36 [[:path {:d "M18 12l-9 9 2.12 2.12L18 16.24l6.88 6.88L27 21z"}]]
  48 [[:path {:d "M24 16L12 28l2.83 2.83L24 21.66l9.17 9.17L36 28z"}]])

(deficon expand-more
  18 [[:path {:d "M12.44 6.44L9 9.88 5.56 6.44 4.5 7.5 9 12l4.5-4.5z"}]]
  24 [[:path {:d "M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"}]]
  36 [[:path {:d "M24.88 12.88L18 19.76l-6.88-6.88L9 15l9 9 9-9z"}]]
  48 [[:path {:d "M33.17 17.17L24 26.34l-9.17-9.17L12 20l12 12 12-12z"}]])

(deficon fullscreen
  18 [[:path {:d "M4.5 11H3v4h4v-1.5H4.5V11zM3 7h1.5V4.5H7V3H3v4zm10.5 6.5H11V15h4v-4h-1.5v2.5zM11 3v1.5h2.5V7H15V3h-4z"}]]
  24 [[:path {:d "M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z"}]]
  36 [[:path {:d "M10 21H7v8h8v-3h-5v-5zm-3-6h3v-5h5V7H7v8zm19 11h-5v3h8v-8h-3v5zM21 7v3h5v5h3V7h-8z"}]]
  48 [[:path {:d "M14 28h-4v10h10v-4h-6v-6zm-4-8h4v-6h6v-4H10v10zm24 14h-6v4h10V28h-4v6zm-6-24v4h6v6h4V10H28z"}]])

(deficon fullscreen-exit
  18 [[:path {:d "M3 12.5h2.5V15H7v-4H3v1.5zm2.5-7H3V7h4V3H5.5v2.5zM11 15h1.5v-2.5H15V11h-4v4zm1.5-9.5V3H11v4h4V5.5h-2.5z"}]]
  24 [[:path {:d "M5 16h3v3h2v-5H5v2zm3-8H5v2h5V5H8v3zm6 11h2v-3h3v-2h-5v5zm2-11V5h-2v5h5V8h-3z"}]]
  36 [[:path {:d "M7 24h5v5h3v-8H7v3zm5-12H7v3h8V7h-3v5zm9 17h3v-5h5v-3h-8v8zm3-17V7h-3v8h8v-3h-5z"}]]
  48 [[:path {:d "M10 32h6v6h4V28H10v4zm6-16h-6v4h10V10h-4v6zm12 22h4v-6h6v-4H28v10zm4-22v-6h-4v10h10v-4h-6z"}]])

(deficon menu
  18 [[:path {:d "M2 13.5h14V12H2v1.5zm0-4h14V8H2v1.5zM2 4v1.5h14V4H2z"}]]
  24 [[:path {:d "M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"}]]
  36 [[:path {:d "M4 27h28v-3H4v3zm0-8h28v-3H4v3zM4 8v3h28V8H4z"}]]
  48 [[:path {:d "M6 36h36v-4H6v4zm0-10h36v-4H6v4zm0-14v4h36v-4H6z"}]])

(deficon more-horiz
  18 [[:path {:d "M4 7.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5S5.5 9.83 5.5 9 4.83 7.5 4 7.5zm10 0c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm-5 0c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5S9.83 7.5 9 7.5z"}]]
  24 [[:path {:d "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"}]]
  36 [[:path {:d "M9 15c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm18 0c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm-9 0c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"}]]
  48 [[:path {:d "M12 20c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm24 0c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm-12 0c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z"}]])

(deficon more-vert
  18 [[:path {:d "M9 5.5c.83 0 1.5-.67 1.5-1.5S9.83 2.5 9 2.5 7.5 3.17 7.5 4 8.17 5.5 9 5.5zm0 2c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5S9.83 7.5 9 7.5zm0 5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z"}]]
  24 [[:path {:d "M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"}]]
  36 [[:path {:d "M18 12c1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3 1.34 3 3 3zm0 3c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm0 9c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"}]]
  48 [[:path {:d "M24 16c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 4c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 12c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z"}]])

(deficon refresh
  18 [[:path {:d "M9 13.5c-2.49 0-4.5-2.01-4.5-4.5S6.51 4.5 9 4.5c1.24 0 2.36.52 3.17 1.33L10 8h5V3l-1.76 1.76C12.15 3.68 10.66 3 9 3 5.69 3 3.01 5.69 3.01 9S5.69 15 9 15c2.97 0 5.43-2.16 5.9-5h-1.52c-.46 2-2.24 3.5-4.38 3.5z"}]]
  24 [[:path {:d "M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"}]]
  36 [[:path {:d "M26.47 9.53C24.3 7.35 21.32 6 18 6 11.37 6 6 11.37 6 18s5.37 12 12 12c5.94 0 10.85-4.33 11.81-10h-3.04c-.91 4.01-4.49 7-8.77 7-4.97 0-9-4.03-9-9s4.03-9 9-9c2.49 0 4.71 1.03 6.34 2.66L20 16h10V6l-3.53 3.53z"}]]
  48 [[:path {:d "M35.3 12.7C32.41 9.8 28.42 8 24 8 15.16 8 8.02 15.16 8.02 24S15.16 40 24 40c7.45 0 13.69-5.1 15.46-12H35.3c-1.65 4.66-6.07 8-11.3 8-6.63 0-12-5.37-12-12s5.37-12 12-12c3.31 0 6.28 1.38 8.45 3.55L26 22h14V8l-4.7 4.7z"}]])

(deficon subdirectory-arrow-left
  24 [[:path {:d "M11 9l1.42 1.42L8.83 14H18V4h2v12H8.83l3.59 3.58L11 21l-6-6 6-6z"}]]
  48 [[:path {:d "M20 18l2.83 2.83L15.66 28H36V6h4v26H15.66l7.17 7.17L20 42 8 30l12-12z"}]])

(deficon subdirectory-arrow-right
  24 [[:path {:d "M19 15l-6 6-1.42-1.42L15.17 16H4V4h2v10h9.17l-3.59-3.58L13 9l6 6z"}]]
  48 [[:path {:d "M-31 29l-12 12-2.83-2.83 7.17-7.17H-61V7h4v20h18.34l-7.17-7.17L-43 17l12 12zm71 1L28 42l-2.83-2.83L32.34 32H8V6h4v22h20.34l-7.17-7.17L28 18l12 12z"}]])

(deficon unfold-less
  18 [[:path {:d "M5.56 14.44l1.06 1.06L9 13.12l2.38 2.38 1.06-1.06L9 11l-3.44 3.44zm6.88-10.88L11.38 2.5 9 4.88 6.62 2.5 5.56 3.56 9 7l3.44-3.44z"}]]
  24 [[:path {:d "M7.41 18.59L8.83 20 12 16.83 15.17 20l1.41-1.41L12 14l-4.59 4.59zm9.18-13.18L15.17 4 12 7.17 8.83 4 7.41 5.41 12 10l4.59-4.59z"}]]
  36 [[:path {:d "M11.12 27.88L13.24 30 18 25.24 22.76 30l2.12-2.12L18 21l-6.88 6.88zM24.88 8.12L22.76 6 18 10.76 13.24 6l-2.12 2.12L18 15l6.88-6.88z"}]]
  48 [[:path {:d "M14.83 37.17L17.66 40 24 33.66 30.34 40l2.83-2.83L24 28l-9.17 9.17zm18.34-26.34L30.34 8 24 14.34 17.66 8l-2.83 2.83L24 20l9.17-9.17z"}]])

(deficon unfold-more
  18 [[:path {:d "M9 4.12l2.38 2.38 1.06-1.06L9 2 5.56 5.44 6.62 6.5 9 4.12zm0 9.76L6.62 11.5l-1.06 1.06L9 16l3.44-3.44-1.06-1.06L9 13.88z"}]]
  24 [[:path {:d "M12 5.83L15.17 9l1.41-1.41L12 3 7.41 7.59 8.83 9 12 5.83zm0 12.34L8.83 15l-1.41 1.41L12 21l4.59-4.59L15.17 15 12 18.17z"}]]
  36 [[:path {:d "M18 9.24L22.76 14l2.12-2.12L18 5l-6.88 6.88L13.24 14 18 9.24zm0 17.52L13.24 22l-2.12 2.12L18 31l6.88-6.88L22.76 22 18 26.76z"}]]
  48 [[:path {:d "M24 11.66L30.34 18l2.83-2.83L24 6l-9.17 9.17L17.66 18 24 11.66zm0 24.68L17.66 30l-2.83 2.83L24 42l9.17-9.17L30.34 30 24 36.34z"}]])
