;; Copyright (c) 2016 wicdmedia Development Team

;; This Source Code Form is subject to the terms of the
;; Mozilla Public License, v. 2.0. If a copy of the MPL
;; was not distributed with this file, You can obtain
;; one at https://mozilla.org/MPL/2.0/.

(ns wicdmedia.halcyon.halcyon)

(defmacro deficon [name & {:as size-map}]
  (let [sorted-keys (sort > (keys size-map))
        conds (apply concat (for [k sorted-keys] [k (size-map k)]))]
    `(defn ~name [~'size & {:keys [~'color ~'ns? ~'version?]}]
       (let [root-attr# {:width (str ~'size)
                         :height (str ~'size)
                         :viewBox (str "0 0 " ~'size " " ~'size)}
             root-attr1# (if ~'color
                           (assoc root-attr# :fill (str ~'color))
                           root-attr#)
             root-attr2# (if ~'ns?
                           (assoc root-attr1# :xmlns "http://www.w3.org/2000/svg")
                           root-attr1#)
             root-attr3# (if ~'version?
                           (assoc root-attr2# :version "1.1")
                           root-attr2#)
             chosen# (condp <= ~'size
                       ~@conds
                       ~(last conds))]
         (into [:svg root-attr3#] chosen#)))))
