(ns om-justified.core
  (:require [om.core :as om :include-macros true]
            [om.dom :as dom :include-macros true]
            [goog.events :as events]
            [goog.events.EventType]))

(defn justify-sizes [sizes cont-width max-height spacing]
  ((fn step [value row row-width sizes]
     (if (seq sizes)
       (let [size-current    (first sizes)
             sizes-rest      (rest sizes)
             row-width'      (+ row-width (first size-current) spacing)
             row'            (conj row size-current)
             row-imgs-width' (apply + (map first row'))]
         (if (>= row-width' cont-width)
           (let [row-factor (/ row-imgs-width' (- cont-width (* (count row') spacing)))
                 row-height (/ max-height row-factor)
                 row-sizes  (map #(-> (assoc % 0 (-> (get % 0) (/ row-factor)))
                                      (assoc   1 (-> row-height)))
                                  row')
                 img-widths (map first row-sizes)
                 difference (-> (- (apply + img-widths) (->> (map js/Math.floor img-widths) (apply +))) js/Math.floor)
                 row-sizes' (map (fn [[w h] p]
                                   [(-> w js/Math.floor (+ p)) (js/Math.floor h)])
                                 row-sizes
                                 (concat (repeat difference 1) (repeat 0)))]
             (step (concat value row-sizes') []  0 sizes-rest))
           (if (not-empty sizes-rest)
             (step value row' row-width' (rest sizes))
             (concat value row'))))
       value))
   [] [] 0 sizes))

(defn update-sizes
  [images cont-width spacing]
  (when cont-width
    (om/transact! images (fn [images]
                           (let [sizes      (map #(vector (:width %) (:height %)) images)
                                 just-sizes (justify-sizes sizes (- cont-width 1) (-> sizes first second) spacing)]
                             (mapv #(-> (assoc %1 :just-width  (first %2))
                                        (assoc    :just-height (second %2))) images just-sizes))))))

(defn justified
  [images owner {:keys [compo spacing]}]
  (reify
    om/IDidMount
    (did-mount [_]
      (let [node (om/get-node owner "container")]
        (om/set-state! owner :cont-width (.-clientWidth node))
        (update-sizes images (.-clientWidth node) spacing)
        (events/listen js/window goog.events.EventType.RESIZE
          (fn [event]
            (let [new-width (.-clientWidth node)]
              (when (not= (om/get-state owner :cont-width) new-width)
                (update-sizes images new-width spacing)
                (om/set-state! owner :cont-width new-width)))))))
    om/IRender
    (render [_]
      (apply dom/div #js {:ref "container"}
        (om/build-all compo images)))))
