## Om-justified

Justified image grids for [Om](https://github.com/swannodette/om). Calculation from pixels. Initial algorithm from Mr. [amalloy](https://www.refheap.com/ced27e80b9d970edd08eb7cde) of #clojure.

#### Running the example from https://whodidthis.github.com/om-justified

Clone repository, run `lein cljsbuild auto hello` and open examples/hello/index.html in the browser.

### Usage
```clojure
[whodidthis/om-justified "0.2.0"]
```
Om-justified expects images delivered as 
```clojure
[{:src "a.jpg" :width 100 :height 150}
 {:src "b.jpg" :width 125 :height 150} ...]
```
where size of the images is already calculated to whatever max-height of the images you plan on using. 

```clojure
;; require
(:require [om-justified.core :refer [justified])
;; an image component to use
(defn image-component [{:keys [src width height just-width just-height]} owner]
  (om/component
    (dom/img #js {:src src 
                  ;; Om-justified delivers new size image size in just-width and just-height. 
                  ;; Use them only when available.
                  :width (or just-width width) :height (or just-height height) 
                  :style #js {:margin 2}})))
                  
;; use in some component
(fn [{:keys [images]} owner]
  (reify
    om/IRender
    (render [_]
      (dom/div nil
        ;; justified needs - images in a vector cursor
        ;;                 - an image-component to render for each image
        ;;                 - additional total spacing each image requires horizontally from paddings, margins and stuff
        (om/build justified images {:opts {:compo image-component
                                           :spacing 4}} ; image components styling requires 4px of spacing)))))
  
```
