# Om-justified

Justified image grids for [Om](https://github.com/swannodette/om). Calculation from pixels. Initial algorithm from Mr. [amalloy](https://github.com/amalloy) of #clojure.

### Running the example

Clone repository, run `lein cljsbuild auto hello` and open examples/hello/index.html in the browser.

### Usage

Om-justified expects images delivered as 
```clojure
{:images [{:src "a.jpg" :width 100 :height 150}
          {:src "b.jpg" :width 125 :height 150} ...]}
```
where size of the images is already calculated to whatever height of the images you plan on using. User delivered `image-component` will receive images where new keys `:just-width` and `:just-height` hold the new size.

Two functions, 
* `om-justified/justified` for images rendered as inline-blocks
* `om-justified/justified-rows` for additional styles or flexbox usage etc.

```clojure
;; require
(:require [om-justified.core :refer [justified justified-row])
;; an image component to use
(defn image-component [{:keys [src just-width just-height]} owner]
  (om/component
    (dom/img #js {:src src 
                  ;; Om-justified assocs new size to just-width and just-height
                  :width just-width :height just-height 
                  :style #js {:margin 2}})))
;; use in some component
(fn [app owner]
  (reify
    om/IRender
    (render [_]
      (dom/span nil
        ;; justified needs - a cursor containing images under :images key
        ;;                 - an image-component to render for each image
        ;;                 - additional spacing each image requires from paddings, margins and stuff
        (om/build justified app {:opts image-component
                                 :spacing 4} ; image components styling requires 4px of spacing)
        ;; justified-rows returns images in rows wrapped in divs. 
        (om/build justified-rows app {:opts image-component
                                      :spacing 4})))))
  
```
