// Compiled by ClojureScript 0.0-2227
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('clojure.string');
goog.require('sablono.util');
goog.require('goog.dom');
goog.require('goog.dom');
goog.require('sablono.interpreter');
goog.require('sablono.interpreter');
goog.require('sablono.util');
goog.require('clojure.walk');
goog.require('clojure.string');
/**
* Add an optional attribute argument to a function that returns a element vector.
*/
sablono.core.wrap_attrs = (function wrap_attrs(func){return (function() { 
var G__16405__delegate = function (args){if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args)))
{var vec__16404 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));var tag = cljs.core.nth.call(null,vec__16404,0,null);var body = cljs.core.nthnext.call(null,vec__16404,1);if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body)))
{return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else
{return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else
{return cljs.core.apply.call(null,func,args);
}
};
var G__16405 = function (var_args){
var args = null;if (arguments.length > 0) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return G__16405__delegate.call(this,args);};
G__16405.cljs$lang$maxFixedArity = 0;
G__16405.cljs$lang$applyTo = (function (arglist__16406){
var args = cljs.core.seq(arglist__16406);
return G__16405__delegate(args);
});
G__16405.cljs$core$IFn$_invoke$arity$variadic = G__16405__delegate;
return G__16405;
})()
;
});
sablono.core.update_arglists = (function update_arglists(arglists){var iter__8654__auto__ = (function iter__16411(s__16412){return (new cljs.core.LazySeq(null,(function (){var s__16412__$1 = s__16412;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__16412__$1);if(temp__4126__auto__)
{var s__16412__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__16412__$2))
{var c__8652__auto__ = cljs.core.chunk_first.call(null,s__16412__$2);var size__8653__auto__ = cljs.core.count.call(null,c__8652__auto__);var b__16414 = cljs.core.chunk_buffer.call(null,size__8653__auto__);if((function (){var i__16413 = 0;while(true){
if((i__16413 < size__8653__auto__))
{var args = cljs.core._nth.call(null,c__8652__auto__,i__16413);cljs.core.chunk_append.call(null,b__16414,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",-1682549128,null),args)));
{
var G__16415 = (i__16413 + 1);
i__16413 = G__16415;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16414),iter__16411.call(null,cljs.core.chunk_rest.call(null,s__16412__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16414),null);
}
} else
{var args = cljs.core.first.call(null,s__16412__$2);return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",-1682549128,null),args)),iter__16411.call(null,cljs.core.rest.call(null,s__16412__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8654__auto__.call(null,arglists);
});
/**
* Render the React `component` as an HTML string.
*/
sablono.core.render = (function render(component){return React.renderComponentToString(component);
});
/**
* Include a list of external stylesheet files.
* @param {...*} var_args
*/
sablono.core.include_css = (function() { 
var include_css__delegate = function (styles){var iter__8654__auto__ = (function iter__16420(s__16421){return (new cljs.core.LazySeq(null,(function (){var s__16421__$1 = s__16421;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__16421__$1);if(temp__4126__auto__)
{var s__16421__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__16421__$2))
{var c__8652__auto__ = cljs.core.chunk_first.call(null,s__16421__$2);var size__8653__auto__ = cljs.core.count.call(null,c__8652__auto__);var b__16423 = cljs.core.chunk_buffer.call(null,size__8653__auto__);if((function (){var i__16422 = 0;while(true){
if((i__16422 < size__8653__auto__))
{var style = cljs.core._nth.call(null,c__8652__auto__,i__16422);cljs.core.chunk_append.call(null,b__16423,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",1017226092),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1017479852),"text/css",new cljs.core.Keyword(null,"href","href",1017115293),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1014017035),"stylesheet"], null)], null));
{
var G__16424 = (i__16422 + 1);
i__16422 = G__16424;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16423),iter__16420.call(null,cljs.core.chunk_rest.call(null,s__16421__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16423),null);
}
} else
{var style = cljs.core.first.call(null,s__16421__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",1017226092),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1017479852),"text/css",new cljs.core.Keyword(null,"href","href",1017115293),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1014017035),"stylesheet"], null)], null),iter__16420.call(null,cljs.core.rest.call(null,s__16421__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8654__auto__.call(null,styles);
};
var include_css = function (var_args){
var styles = null;if (arguments.length > 0) {
  styles = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return include_css__delegate.call(this,styles);};
include_css.cljs$lang$maxFixedArity = 0;
include_css.cljs$lang$applyTo = (function (arglist__16425){
var styles = cljs.core.seq(arglist__16425);
return include_css__delegate(styles);
});
include_css.cljs$core$IFn$_invoke$arity$variadic = include_css__delegate;
return include_css;
})()
;
/**
* Include the JavaScript library at `src`.
*/
sablono.core.include_js = (function include_js(src){return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",{"src": src}));
});
/**
* Include Facebook's React JavaScript library.
*/
sablono.core.include_react = (function include_react(){return sablono.core.include_js.call(null,"http://fb.me/react-0.9.0.js");
});
/**
* Wraps some content in a HTML hyperlink with the supplied URL.
* @param {...*} var_args
*/
sablono.core.link_to16426 = (function() { 
var link_to16426__delegate = function (url,content){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",1013904339),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",1017115293),sablono.util.as_str.call(null,url)], null),content], null);
};
var link_to16426 = function (url,var_args){
var content = null;if (arguments.length > 1) {
  content = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return link_to16426__delegate.call(this,url,content);};
link_to16426.cljs$lang$maxFixedArity = 1;
link_to16426.cljs$lang$applyTo = (function (arglist__16427){
var url = cljs.core.first(arglist__16427);
var content = cljs.core.rest(arglist__16427);
return link_to16426__delegate(url,content);
});
link_to16426.cljs$core$IFn$_invoke$arity$variadic = link_to16426__delegate;
return link_to16426;
})()
;
sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to16426);
/**
* Wraps some content in a HTML hyperlink with the supplied e-mail
* address. If no content provided use the e-mail address as content.
* @param {...*} var_args
*/
sablono.core.mail_to16428 = (function() { 
var mail_to16428__delegate = function (e_mail,p__16429){var vec__16431 = p__16429;var content = cljs.core.nth.call(null,vec__16431,0,null);return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",1013904339),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",1017115293),("mailto:"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail))], null),(function (){var or__7929__auto__ = content;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return e_mail;
}
})()], null);
};
var mail_to16428 = function (e_mail,var_args){
var p__16429 = null;if (arguments.length > 1) {
  p__16429 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return mail_to16428__delegate.call(this,e_mail,p__16429);};
mail_to16428.cljs$lang$maxFixedArity = 1;
mail_to16428.cljs$lang$applyTo = (function (arglist__16432){
var e_mail = cljs.core.first(arglist__16432);
var p__16429 = cljs.core.rest(arglist__16432);
return mail_to16428__delegate(e_mail,p__16429);
});
mail_to16428.cljs$core$IFn$_invoke$arity$variadic = mail_to16428__delegate;
return mail_to16428;
})()
;
sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to16428);
/**
* Wrap a collection in an unordered list.
*/
sablono.core.unordered_list16433 = (function unordered_list16433(coll){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",1013907977),(function (){var iter__8654__auto__ = (function iter__16438(s__16439){return (new cljs.core.LazySeq(null,(function (){var s__16439__$1 = s__16439;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__16439__$1);if(temp__4126__auto__)
{var s__16439__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__16439__$2))
{var c__8652__auto__ = cljs.core.chunk_first.call(null,s__16439__$2);var size__8653__auto__ = cljs.core.count.call(null,c__8652__auto__);var b__16441 = cljs.core.chunk_buffer.call(null,size__8653__auto__);if((function (){var i__16440 = 0;while(true){
if((i__16440 < size__8653__auto__))
{var x = cljs.core._nth.call(null,c__8652__auto__,i__16440);cljs.core.chunk_append.call(null,b__16441,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null));
{
var G__16442 = (i__16440 + 1);
i__16440 = G__16442;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16441),iter__16438.call(null,cljs.core.chunk_rest.call(null,s__16439__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16441),null);
}
} else
{var x = cljs.core.first.call(null,s__16439__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null),iter__16438.call(null,cljs.core.rest.call(null,s__16439__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8654__auto__.call(null,coll);
})()], null);
});
sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list16433);
/**
* Wrap a collection in an ordered list.
*/
sablono.core.ordered_list16443 = (function ordered_list16443(coll){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",1013907791),(function (){var iter__8654__auto__ = (function iter__16448(s__16449){return (new cljs.core.LazySeq(null,(function (){var s__16449__$1 = s__16449;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__16449__$1);if(temp__4126__auto__)
{var s__16449__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__16449__$2))
{var c__8652__auto__ = cljs.core.chunk_first.call(null,s__16449__$2);var size__8653__auto__ = cljs.core.count.call(null,c__8652__auto__);var b__16451 = cljs.core.chunk_buffer.call(null,size__8653__auto__);if((function (){var i__16450 = 0;while(true){
if((i__16450 < size__8653__auto__))
{var x = cljs.core._nth.call(null,c__8652__auto__,i__16450);cljs.core.chunk_append.call(null,b__16451,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null));
{
var G__16452 = (i__16450 + 1);
i__16450 = G__16452;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16451),iter__16448.call(null,cljs.core.chunk_rest.call(null,s__16449__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16451),null);
}
} else
{var x = cljs.core.first.call(null,s__16449__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",1013907695),x], null),iter__16448.call(null,cljs.core.rest.call(null,s__16449__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8654__auto__.call(null,coll);
})()], null);
});
sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list16443);
/**
* Create an image element.
*/
sablono.core.image16453 = (function() {
var image16453 = null;
var image16453__1 = (function (src){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1014008629),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",1014018390),sablono.util.as_str.call(null,src)], null)], null);
});
var image16453__2 = (function (src,alt){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1014008629),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",1014018390),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",1014000923),alt], null)], null);
});
image16453 = function(src,alt){
switch(arguments.length){
case 1:
return image16453__1.call(this,src);
case 2:
return image16453__2.call(this,src,alt);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
image16453.cljs$core$IFn$_invoke$arity$1 = image16453__1;
image16453.cljs$core$IFn$_invoke$arity$2 = image16453__2;
return image16453;
})()
;
sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image16453);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
* Create a field name from the supplied argument the current field group.
*/
sablono.core.make_name = (function make_name(name){return cljs.core.reduce.call(null,(function (p1__16454_SHARP_,p2__16455_SHARP_){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16454_SHARP_)+"["+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__16455_SHARP_)+"]");
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Create a field id from the supplied argument and current field group.
*/
sablono.core.make_id = (function make_id(name){return cljs.core.reduce.call(null,(function (p1__16456_SHARP_,p2__16457_SHARP_){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16456_SHARP_)+"-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__16457_SHARP_));
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
* Creates a new <input> element.
*/
sablono.core.input_field_STAR_ = (function input_field_STAR_(type,name,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1017479852),type,new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",1125876963),value], null)], null);
});
/**
* Creates a color input field.
*/
sablono.core.color_field16458 = (function() {
var color_field16458 = null;
var color_field16458__1 = (function (name__14406__auto__){return color_field16458.call(null,name__14406__auto__,null);
});
var color_field16458__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1545688804,null))),name__14406__auto__,value__14407__auto__);
});
color_field16458 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return color_field16458__1.call(this,name__14406__auto__);
case 2:
return color_field16458__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
color_field16458.cljs$core$IFn$_invoke$arity$1 = color_field16458__1;
color_field16458.cljs$core$IFn$_invoke$arity$2 = color_field16458__2;
return color_field16458;
})()
;
sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field16458);
/**
* Creates a date input field.
*/
sablono.core.date_field16459 = (function() {
var date_field16459 = null;
var date_field16459__1 = (function (name__14406__auto__){return date_field16459.call(null,name__14406__auto__,null);
});
var date_field16459__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",-1637455513,null))),name__14406__auto__,value__14407__auto__);
});
date_field16459 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return date_field16459__1.call(this,name__14406__auto__);
case 2:
return date_field16459__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
date_field16459.cljs$core$IFn$_invoke$arity$1 = date_field16459__1;
date_field16459.cljs$core$IFn$_invoke$arity$2 = date_field16459__2;
return date_field16459;
})()
;
sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field16459);
/**
* Creates a datetime input field.
*/
sablono.core.datetime_field16460 = (function() {
var datetime_field16460 = null;
var datetime_field16460__1 = (function (name__14406__auto__){return datetime_field16460.call(null,name__14406__auto__,null);
});
var datetime_field16460__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",153171252,null))),name__14406__auto__,value__14407__auto__);
});
datetime_field16460 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return datetime_field16460__1.call(this,name__14406__auto__);
case 2:
return datetime_field16460__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
datetime_field16460.cljs$core$IFn$_invoke$arity$1 = datetime_field16460__1;
datetime_field16460.cljs$core$IFn$_invoke$arity$2 = datetime_field16460__2;
return datetime_field16460;
})()
;
sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field16460);
/**
* Creates a datetime-local input field.
*/
sablono.core.datetime_local_field16461 = (function() {
var datetime_local_field16461 = null;
var datetime_local_field16461__1 = (function (name__14406__auto__){return datetime_local_field16461.call(null,name__14406__auto__,null);
});
var datetime_local_field16461__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",1631019090,null))),name__14406__auto__,value__14407__auto__);
});
datetime_local_field16461 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return datetime_local_field16461__1.call(this,name__14406__auto__);
case 2:
return datetime_local_field16461__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
datetime_local_field16461.cljs$core$IFn$_invoke$arity$1 = datetime_local_field16461__1;
datetime_local_field16461.cljs$core$IFn$_invoke$arity$2 = datetime_local_field16461__2;
return datetime_local_field16461;
})()
;
sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field16461);
/**
* Creates a email input field.
*/
sablono.core.email_field16462 = (function() {
var email_field16462 = null;
var email_field16462__1 = (function (name__14406__auto__){return email_field16462.call(null,name__14406__auto__,null);
});
var email_field16462__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1543912107,null))),name__14406__auto__,value__14407__auto__);
});
email_field16462 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return email_field16462__1.call(this,name__14406__auto__);
case 2:
return email_field16462__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
email_field16462.cljs$core$IFn$_invoke$arity$1 = email_field16462__1;
email_field16462.cljs$core$IFn$_invoke$arity$2 = email_field16462__2;
return email_field16462;
})()
;
sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field16462);
/**
* Creates a file input field.
*/
sablono.core.file_field16463 = (function() {
var file_field16463 = null;
var file_field16463__1 = (function (name__14406__auto__){return file_field16463.call(null,name__14406__auto__,null);
});
var file_field16463__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",-1637388491,null))),name__14406__auto__,value__14407__auto__);
});
file_field16463 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return file_field16463__1.call(this,name__14406__auto__);
case 2:
return file_field16463__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
file_field16463.cljs$core$IFn$_invoke$arity$1 = file_field16463__1;
file_field16463.cljs$core$IFn$_invoke$arity$2 = file_field16463__2;
return file_field16463;
})()
;
sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field16463);
/**
* Creates a hidden input field.
*/
sablono.core.hidden_field16464 = (function() {
var hidden_field16464 = null;
var hidden_field16464__1 = (function (name__14406__auto__){return hidden_field16464.call(null,name__14406__auto__,null);
});
var hidden_field16464__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1436948323,null))),name__14406__auto__,value__14407__auto__);
});
hidden_field16464 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return hidden_field16464__1.call(this,name__14406__auto__);
case 2:
return hidden_field16464__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
hidden_field16464.cljs$core$IFn$_invoke$arity$1 = hidden_field16464__1;
hidden_field16464.cljs$core$IFn$_invoke$arity$2 = hidden_field16464__2;
return hidden_field16464;
})()
;
sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field16464);
/**
* Creates a month input field.
*/
sablono.core.month_field16465 = (function() {
var month_field16465 = null;
var month_field16465__1 = (function (name__14406__auto__){return month_field16465.call(null,name__14406__auto__,null);
});
var month_field16465__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-1536451527,null))),name__14406__auto__,value__14407__auto__);
});
month_field16465 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return month_field16465__1.call(this,name__14406__auto__);
case 2:
return month_field16465__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
month_field16465.cljs$core$IFn$_invoke$arity$1 = month_field16465__1;
month_field16465.cljs$core$IFn$_invoke$arity$2 = month_field16465__2;
return month_field16465;
})()
;
sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field16465);
/**
* Creates a number input field.
*/
sablono.core.number_field16466 = (function() {
var number_field16466 = null;
var number_field16466__1 = (function (name__14406__auto__){return number_field16466.call(null,name__14406__auto__,null);
});
var number_field16466__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",1620071682,null))),name__14406__auto__,value__14407__auto__);
});
number_field16466 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return number_field16466__1.call(this,name__14406__auto__);
case 2:
return number_field16466__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
number_field16466.cljs$core$IFn$_invoke$arity$1 = number_field16466__1;
number_field16466.cljs$core$IFn$_invoke$arity$2 = number_field16466__2;
return number_field16466;
})()
;
sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field16466);
/**
* Creates a password input field.
*/
sablono.core.password_field16467 = (function() {
var password_field16467 = null;
var password_field16467__1 = (function (name__14406__auto__){return password_field16467.call(null,name__14406__auto__,null);
});
var password_field16467__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",-423545772,null))),name__14406__auto__,value__14407__auto__);
});
password_field16467 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return password_field16467__1.call(this,name__14406__auto__);
case 2:
return password_field16467__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
password_field16467.cljs$core$IFn$_invoke$arity$1 = password_field16467__1;
password_field16467.cljs$core$IFn$_invoke$arity$2 = password_field16467__2;
return password_field16467;
})()
;
sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field16467);
/**
* Creates a range input field.
*/
sablono.core.range_field16468 = (function() {
var range_field16468 = null;
var range_field16468__1 = (function (name__14406__auto__){return range_field16468.call(null,name__14406__auto__,null);
});
var range_field16468__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1532251402,null))),name__14406__auto__,value__14407__auto__);
});
range_field16468 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return range_field16468__1.call(this,name__14406__auto__);
case 2:
return range_field16468__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
range_field16468.cljs$core$IFn$_invoke$arity$1 = range_field16468__1;
range_field16468.cljs$core$IFn$_invoke$arity$2 = range_field16468__2;
return range_field16468;
})()
;
sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field16468);
/**
* Creates a search input field.
*/
sablono.core.search_field16469 = (function() {
var search_field16469 = null;
var search_field16469__1 = (function (name__14406__auto__){return search_field16469.call(null,name__14406__auto__,null);
});
var search_field16469__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",1748098913,null))),name__14406__auto__,value__14407__auto__);
});
search_field16469 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return search_field16469__1.call(this,name__14406__auto__);
case 2:
return search_field16469__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
search_field16469.cljs$core$IFn$_invoke$arity$1 = search_field16469__1;
search_field16469.cljs$core$IFn$_invoke$arity$2 = search_field16469__2;
return search_field16469;
})()
;
sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field16469);
/**
* Creates a tel input field.
*/
sablono.core.tel_field16470 = (function() {
var tel_field16470 = null;
var tel_field16470__1 = (function (name__14406__auto__){return tel_field16470.call(null,name__14406__auto__,null);
});
var tel_field16470__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",-1640416812,null))),name__14406__auto__,value__14407__auto__);
});
tel_field16470 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return tel_field16470__1.call(this,name__14406__auto__);
case 2:
return tel_field16470__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
tel_field16470.cljs$core$IFn$_invoke$arity$1 = tel_field16470__1;
tel_field16470.cljs$core$IFn$_invoke$arity$2 = tel_field16470__2;
return tel_field16470;
})()
;
sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field16470);
/**
* Creates a text input field.
*/
sablono.core.text_field16471 = (function() {
var text_field16471 = null;
var text_field16471__1 = (function (name__14406__auto__){return text_field16471.call(null,name__14406__auto__,null);
});
var text_field16471__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-1636974874,null))),name__14406__auto__,value__14407__auto__);
});
text_field16471 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return text_field16471__1.call(this,name__14406__auto__);
case 2:
return text_field16471__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_field16471.cljs$core$IFn$_invoke$arity$1 = text_field16471__1;
text_field16471.cljs$core$IFn$_invoke$arity$2 = text_field16471__2;
return text_field16471;
})()
;
sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field16471);
/**
* Creates a time input field.
*/
sablono.core.time_field16472 = (function() {
var time_field16472 = null;
var time_field16472__1 = (function (name__14406__auto__){return time_field16472.call(null,name__14406__auto__,null);
});
var time_field16472__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1636971386,null))),name__14406__auto__,value__14407__auto__);
});
time_field16472 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return time_field16472__1.call(this,name__14406__auto__);
case 2:
return time_field16472__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
time_field16472.cljs$core$IFn$_invoke$arity$1 = time_field16472__1;
time_field16472.cljs$core$IFn$_invoke$arity$2 = time_field16472__2;
return time_field16472;
})()
;
sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field16472);
/**
* Creates a url input field.
*/
sablono.core.url_field16473 = (function() {
var url_field16473 = null;
var url_field16473__1 = (function (name__14406__auto__){return url_field16473.call(null,name__14406__auto__,null);
});
var url_field16473__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",-1640415448,null))),name__14406__auto__,value__14407__auto__);
});
url_field16473 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return url_field16473__1.call(this,name__14406__auto__);
case 2:
return url_field16473__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
url_field16473.cljs$core$IFn$_invoke$arity$1 = url_field16473__1;
url_field16473.cljs$core$IFn$_invoke$arity$2 = url_field16473__2;
return url_field16473;
})()
;
sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field16473);
/**
* Creates a week input field.
*/
sablono.core.week_field16474 = (function() {
var week_field16474 = null;
var week_field16474__1 = (function (name__14406__auto__){return week_field16474.call(null,name__14406__auto__,null);
});
var week_field16474__2 = (function (name__14406__auto__,value__14407__auto__){return sablono.core.input_field_STAR_.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",-1636886099,null))),name__14406__auto__,value__14407__auto__);
});
week_field16474 = function(name__14406__auto__,value__14407__auto__){
switch(arguments.length){
case 1:
return week_field16474__1.call(this,name__14406__auto__);
case 2:
return week_field16474__2.call(this,name__14406__auto__,value__14407__auto__);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
week_field16474.cljs$core$IFn$_invoke$arity$1 = week_field16474__1;
week_field16474.cljs$core$IFn$_invoke$arity$2 = week_field16474__2;
return week_field16474;
})()
;
sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field16474);
sablono.core.file_upload = sablono.core.file_field;
/**
* Creates a check box.
*/
sablono.core.check_box16475 = (function() {
var check_box16475 = null;
var check_box16475__1 = (function (name){return check_box16475.call(null,name,null);
});
var check_box16475__2 = (function (name,checked_QMARK_){return check_box16475.call(null,name,checked_QMARK_,"true");
});
var check_box16475__3 = (function (name,checked_QMARK_,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1017479852),"checkbox",new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",1125876963),value,new cljs.core.Keyword(null,"checked","checked",1756218137),checked_QMARK_], null)], null);
});
check_box16475 = function(name,checked_QMARK_,value){
switch(arguments.length){
case 1:
return check_box16475__1.call(this,name);
case 2:
return check_box16475__2.call(this,name,checked_QMARK_);
case 3:
return check_box16475__3.call(this,name,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
check_box16475.cljs$core$IFn$_invoke$arity$1 = check_box16475__1;
check_box16475.cljs$core$IFn$_invoke$arity$2 = check_box16475__2;
check_box16475.cljs$core$IFn$_invoke$arity$3 = check_box16475__3;
return check_box16475;
})()
;
sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box16475);
/**
* Creates a radio button.
*/
sablono.core.radio_button16476 = (function() {
var radio_button16476 = null;
var radio_button16476__1 = (function (group){return radio_button16476.call(null,group,null);
});
var radio_button16476__2 = (function (group,checked_QMARK_){return radio_button16476.call(null,group,checked_QMARK_,"true");
});
var radio_button16476__3 = (function (group,checked_QMARK_,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1017479852),"radio",new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,group))+"-"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(sablono.util.as_str.call(null,value)))),new cljs.core.Keyword(null,"value","value",1125876963),value,new cljs.core.Keyword(null,"checked","checked",1756218137),checked_QMARK_], null)], null);
});
radio_button16476 = function(group,checked_QMARK_,value){
switch(arguments.length){
case 1:
return radio_button16476__1.call(this,group);
case 2:
return radio_button16476__2.call(this,group,checked_QMARK_);
case 3:
return radio_button16476__3.call(this,group,checked_QMARK_,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
radio_button16476.cljs$core$IFn$_invoke$arity$1 = radio_button16476__1;
radio_button16476.cljs$core$IFn$_invoke$arity$2 = radio_button16476__2;
radio_button16476.cljs$core$IFn$_invoke$arity$3 = radio_button16476__3;
return radio_button16476;
})()
;
sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button16476);
/**
* Creates a seq of option tags from a collection.
*/
sablono.core.select_options16477 = (function() {
var select_options16477 = null;
var select_options16477__1 = (function (coll){return select_options16477.call(null,coll,null);
});
var select_options16477__2 = (function (coll,selected){var iter__8654__auto__ = (function iter__16486(s__16487){return (new cljs.core.LazySeq(null,(function (){var s__16487__$1 = s__16487;while(true){
var temp__4126__auto__ = cljs.core.seq.call(null,s__16487__$1);if(temp__4126__auto__)
{var s__16487__$2 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,s__16487__$2))
{var c__8652__auto__ = cljs.core.chunk_first.call(null,s__16487__$2);var size__8653__auto__ = cljs.core.count.call(null,c__8652__auto__);var b__16489 = cljs.core.chunk_buffer.call(null,size__8653__auto__);if((function (){var i__16488 = 0;while(true){
if((i__16488 < size__8653__auto__))
{var x = cljs.core._nth.call(null,c__8652__auto__,i__16488);cljs.core.chunk_append.call(null,b__16489,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16492 = x;var text = cljs.core.nth.call(null,vec__16492,0,null);var val = cljs.core.nth.call(null,vec__16492,1,null);var disabled_QMARK_ = cljs.core.nth.call(null,vec__16492,2,null);var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);if(cljs.core.sequential_QMARK_.call(null,val))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",933131038),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),text], null),select_options16477.call(null,val,selected)], null);
} else
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",1125876963),val,new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",1284845038),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,x,selected)], null),x], null)));
{
var G__16494 = (i__16488 + 1);
i__16488 = G__16494;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16489),iter__16486.call(null,cljs.core.chunk_rest.call(null,s__16487__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16489),null);
}
} else
{var x = cljs.core.first.call(null,s__16487__$2);return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__16493 = x;var text = cljs.core.nth.call(null,vec__16493,0,null);var val = cljs.core.nth.call(null,vec__16493,1,null);var disabled_QMARK_ = cljs.core.nth.call(null,vec__16493,2,null);var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);if(cljs.core.sequential_QMARK_.call(null,val))
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",933131038),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1116631654),text], null),select_options16477.call(null,val,selected)], null);
} else
{return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",1125876963),val,new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,val,selected),new cljs.core.Keyword(null,"disabled","disabled",1284845038),disabled_QMARK___$1], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",4298734567),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"selected","selected",2205476365),cljs.core._EQ_.call(null,x,selected)], null),x], null)),iter__16486.call(null,cljs.core.rest.call(null,s__16487__$2)));
}
} else
{return null;
}
break;
}
}),null,null));
});return iter__8654__auto__.call(null,coll);
});
select_options16477 = function(coll,selected){
switch(arguments.length){
case 1:
return select_options16477__1.call(this,coll);
case 2:
return select_options16477__2.call(this,coll,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
select_options16477.cljs$core$IFn$_invoke$arity$1 = select_options16477__1;
select_options16477.cljs$core$IFn$_invoke$arity$2 = select_options16477__2;
return select_options16477;
})()
;
sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options16477);
/**
* Creates a drop-down box using the <select> tag.
*/
sablono.core.drop_down16495 = (function() {
var drop_down16495 = null;
var drop_down16495__2 = (function (name,options){return drop_down16495.call(null,name,options,null);
});
var drop_down16495__3 = (function (name,options,selected){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",4402849902),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});
drop_down16495 = function(name,options,selected){
switch(arguments.length){
case 2:
return drop_down16495__2.call(this,name,options);
case 3:
return drop_down16495__3.call(this,name,options,selected);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
drop_down16495.cljs$core$IFn$_invoke$arity$2 = drop_down16495__2;
drop_down16495.cljs$core$IFn$_invoke$arity$3 = drop_down16495__3;
return drop_down16495;
})()
;
sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down16495);
/**
* Creates a text area element.
*/
sablono.core.text_area16496 = (function() {
var text_area16496 = null;
var text_area16496__1 = (function (name){return text_area16496.call(null,name,null);
});
var text_area16496__2 = (function (name,value){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",4305627820),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1017277949),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",1013907597),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",1125876963),value], null)], null);
});
text_area16496 = function(name,value){
switch(arguments.length){
case 1:
return text_area16496__1.call(this,name);
case 2:
return text_area16496__2.call(this,name,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
text_area16496.cljs$core$IFn$_invoke$arity$1 = text_area16496__1;
text_area16496.cljs$core$IFn$_invoke$arity$2 = text_area16496__2;
return text_area16496;
})()
;
sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area16496);
/**
* Creates a label for an input field with the supplied name.
*/
sablono.core.label16497 = (function label16497(name,text){return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1116631654),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",2249940112),sablono.core.make_id.call(null,name)], null),text], null);
});
sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label16497);
/**
* Creates a submit button.
*/
sablono.core.submit_button16498 = (function submit_button16498(text){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),"submit",new cljs.core.Keyword(null,"value","value",1125876963),text], null)], null);
});
sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button16498);
/**
* Creates a form reset button.
*/
sablono.core.reset_button16499 = (function reset_button16499(text){return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",1114262332),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1017479852),"reset",new cljs.core.Keyword(null,"value","value",1125876963),text], null)], null);
});
sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button16499);
/**
* Create a form that points to a particular method and route.
* e.g. (form-to [:put "/post"]
* ...)
* @param {...*} var_args
*/
sablono.core.form_to16500 = (function() { 
var form_to16500__delegate = function (p__16501,body){var vec__16503 = p__16501;var method = cljs.core.nth.call(null,vec__16503,0,null);var action = cljs.core.nth.call(null,vec__16503,1,null);var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));var action_uri = sablono.util.to_uri.call(null,action);return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1014006472),null,new cljs.core.Keyword(null,"post","post",1017351186),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",1017053238),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",4231316563),method_str,new cljs.core.Keyword(null,"action","action",3885920680),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",1017053238),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",4231316563),"POST",new cljs.core.Keyword(null,"action","action",3885920680),action_uri], null),sablono.core.hidden_field.call(null,"_method",method_str)], null)),body));
};
var form_to16500 = function (p__16501,var_args){
var body = null;if (arguments.length > 1) {
  body = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return form_to16500__delegate.call(this,p__16501,body);};
form_to16500.cljs$lang$maxFixedArity = 1;
form_to16500.cljs$lang$applyTo = (function (arglist__16504){
var p__16501 = cljs.core.first(arglist__16504);
var body = cljs.core.rest(arglist__16504);
return form_to16500__delegate(p__16501,body);
});
form_to16500.cljs$core$IFn$_invoke$arity$variadic = form_to16500__delegate;
return form_to16500;
})()
;
sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to16500);

//# sourceMappingURL=core.js.map