// Compiled by ClojureScript 0.0-2227
goog.provide('om_image_grid.cards');
goog.require('cljs.core');
goog.require('om_image_grid.core');
goog.require('om_image_grid.core');
goog.require('om.dom');
goog.require('om.dom');
goog.require('om.core');
goog.require('om.core');
goog.require('devcards.core');
goog.require('devcards.core');
cljs.core.enable_console_print_BANG_.call(null);
devcards.core.start_devcard_ui_BANG_.call(null);
devcards.core.start_figwheel_reloader_BANG_.call(null);
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"devcard-intro","devcard-intro",4151151286)], null),devcards.system.get_options.call(null,devcards.core.markdown_card.call(null,"# Om-image-grid\n\n    Github: [https://github.com/whodidthis/om-image-grid](https://github.com/whodidthis/om-image-grid).\n\n    An om component for creating justified image grids.\n    ### Usage\n    Takes images as a vector of maps\n    that each have `:src` for path, and `:width` and `:height` for dimensions.\n    ```\n    [{:src \"image1.jpg\" :width 123 :height 456}\n     {:src \"image2.jpg\" :width 246 :height 421}\n     ...]\n    ```\n    Found from clojars with `[whodidthis/om-image-grid \"0.3.0\"]`.\n    ```\n    (:require [om-image-grid.core :refer [image-grid]])\n    ```\n    Building the grid requires an image `:compo` to use for each image,\n    `:max-height` for images to display and additional `:spacing` each image\n    needs horizontally.\n    ")),(function (){return devcards.core.markdown_card.call(null,"# Om-image-grid\n\n    Github: [https://github.com/whodidthis/om-image-grid](https://github.com/whodidthis/om-image-grid).\n\n    An om component for creating justified image grids.\n    ### Usage\n    Takes images as a vector of maps\n    that each have `:src` for path, and `:width` and `:height` for dimensions.\n    ```\n    [{:src \"image1.jpg\" :width 123 :height 456}\n     {:src \"image2.jpg\" :width 246 :height 421}\n     ...]\n    ```\n    Found from clojars with `[whodidthis/om-image-grid \"0.3.0\"]`.\n    ```\n    (:require [om-image-grid.core :refer [image-grid]])\n    ```\n    Building the grid requires an image `:compo` to use for each image,\n    `:max-height` for images to display and additional `:spacing` each image\n    needs horizontally.\n    ");
}));
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"desc-images-200-px","desc-images-200-px",1024393774)], null),devcards.system.get_options.call(null,devcards.core.markdown_card.call(null,"### Example\n     Define an image component and build it with `om-image-grid.core/image-grid`\n     with max-height of the images to be shown and whatever additional horizontal\n     spacing each image needs. Each images local state will be updated with\n     `grid-width` and `grid-height`. Here each image has a padding of 2px so\n     additional horizontal spacing required by each image is 4px.\n     ```\n     (defn image-200-compo [{:keys [src width height]} owner]\n       (reify\n         om/IRenderState\n         (render-state [_ {:keys [grid-width grid-height]}]\n           (dom/div #js {:style #js {:display \"inline-block\" :padding 2}}\n             (dom/img #js {:src src :width (or grid-width width) :height (or grid-height height)})))))\n\n     (om/build image-grid images {:opts {:compo image-200-compo\n                                         :max-height 200\n                                         :spacing 4}})\n    ```")),(function (){return devcards.core.markdown_card.call(null,"### Example\n     Define an image component and build it with `om-image-grid.core/image-grid`\n     with max-height of the images to be shown and whatever additional horizontal\n     spacing each image needs. Each images local state will be updated with\n     `grid-width` and `grid-height`. Here each image has a padding of 2px so\n     additional horizontal spacing required by each image is 4px.\n     ```\n     (defn image-200-compo [{:keys [src width height]} owner]\n       (reify\n         om/IRenderState\n         (render-state [_ {:keys [grid-width grid-height]}]\n           (dom/div #js {:style #js {:display \"inline-block\" :padding 2}}\n             (dom/img #js {:src src :width (or grid-width width) :height (or grid-height height)})))))\n\n     (om/build image-grid images {:opts {:compo image-200-compo\n                                         :max-height 200\n                                         :spacing 4}})\n    ```");
}));
om_image_grid.cards.images_200 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/01.jpg",new cljs.core.Keyword(null,"width","width",1127031096),140,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/02.jpg",new cljs.core.Keyword(null,"width","width",1127031096),133,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/03.jpg",new cljs.core.Keyword(null,"width","width",1127031096),132,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/04.jpg",new cljs.core.Keyword(null,"width","width",1127031096),406,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/05.jpg",new cljs.core.Keyword(null,"width","width",1127031096),150,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/06.jpg",new cljs.core.Keyword(null,"width","width",1127031096),151,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/07.jpg",new cljs.core.Keyword(null,"width","width",1127031096),136,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/08.jpg",new cljs.core.Keyword(null,"width","width",1127031096),160,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/09.jpg",new cljs.core.Keyword(null,"width","width",1127031096),140,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/10.jpg",new cljs.core.Keyword(null,"width","width",1127031096),267,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/11.jpg",new cljs.core.Keyword(null,"width","width",1127031096),300,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/12.jpg",new cljs.core.Keyword(null,"width","width",1127031096),155,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/13.jpg",new cljs.core.Keyword(null,"width","width",1127031096),154,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/14.jpg",new cljs.core.Keyword(null,"width","width",1127031096),135,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/15.jpg",new cljs.core.Keyword(null,"width","width",1127031096),140,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/16.jpg",new cljs.core.Keyword(null,"width","width",1127031096),148,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/17.jpg",new cljs.core.Keyword(null,"width","width",1127031096),300,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/18.jpg",new cljs.core.Keyword(null,"width","width",1127031096),147,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/19.jpg",new cljs.core.Keyword(null,"width","width",1127031096),158,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"200/20.jpg",new cljs.core.Keyword(null,"width","width",1127031096),126,new cljs.core.Keyword(null,"height","height",4087841945),200], null)], null);
om_image_grid.cards.image_200_compo = (function image_200_compo(p__15595,owner){var map__15602 = p__15595;var map__15602__$1 = ((cljs.core.seq_QMARK_.call(null,map__15602))?cljs.core.apply.call(null,cljs.core.hash_map,map__15602):map__15602);var height = cljs.core.get.call(null,map__15602__$1,new cljs.core.Keyword(null,"height","height",4087841945));var width = cljs.core.get.call(null,map__15602__$1,new cljs.core.Keyword(null,"width","width",1127031096));var src = cljs.core.get.call(null,map__15602__$1,new cljs.core.Keyword(null,"src","src",1014018390));if(typeof om_image_grid.cards.t15603 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15603 = (function (src,width,height,map__15602,owner,p__15595,image_200_compo,meta15604){
this.src = src;
this.width = width;
this.height = height;
this.map__15602 = map__15602;
this.owner = owner;
this.p__15595 = p__15595;
this.image_200_compo = image_200_compo;
this.meta15604 = meta15604;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15603.cljs$lang$type = true;
om_image_grid.cards.t15603.cljs$lang$ctorStr = "om-image-grid.cards/t15603";
om_image_grid.cards.t15603.cljs$lang$ctorPrWriter = ((function (map__15602,map__15602__$1,height,width,src){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15603");
});})(map__15602,map__15602__$1,height,width,src))
;
om_image_grid.cards.t15603.prototype.om$core$IRenderState$ = true;
om_image_grid.cards.t15603.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15602,map__15602__$1,height,width,src){
return (function (_,p__15606){var self__ = this;
var map__15607 = p__15606;var map__15607__$1 = ((cljs.core.seq_QMARK_.call(null,map__15607))?cljs.core.apply.call(null,cljs.core.hash_map,map__15607):map__15607);var grid_height = cljs.core.get.call(null,map__15607__$1,new cljs.core.Keyword(null,"grid-height","grid-height",1423919360));var grid_width = cljs.core.get.call(null,map__15607__$1,new cljs.core.Keyword(null,"grid-width","grid-width",625456113));var ___$1 = this;return React.DOM.div({"style": {"padding": 2, "display": "inline-block"}},React.DOM.img({"height": (function (){var or__7931__auto__ = grid_height;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.height;
}
})(), "width": (function (){var or__7931__auto__ = grid_width;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.width;
}
})(), "src": self__.src}));
});})(map__15602,map__15602__$1,height,width,src))
;
om_image_grid.cards.t15603.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15602,map__15602__$1,height,width,src){
return (function (_15605){var self__ = this;
var _15605__$1 = this;return self__.meta15604;
});})(map__15602,map__15602__$1,height,width,src))
;
om_image_grid.cards.t15603.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15602,map__15602__$1,height,width,src){
return (function (_15605,meta15604__$1){var self__ = this;
var _15605__$1 = this;return (new om_image_grid.cards.t15603(self__.src,self__.width,self__.height,self__.map__15602,self__.owner,self__.p__15595,self__.image_200_compo,meta15604__$1));
});})(map__15602,map__15602__$1,height,width,src))
;
om_image_grid.cards.__GT_t15603 = ((function (map__15602,map__15602__$1,height,width,src){
return (function __GT_t15603(src__$1,width__$1,height__$1,map__15602__$2,owner__$1,p__15595__$1,image_200_compo__$1,meta15604){return (new om_image_grid.cards.t15603(src__$1,width__$1,height__$1,map__15602__$2,owner__$1,p__15595__$1,image_200_compo__$1,meta15604));
});})(map__15602,map__15602__$1,height,width,src))
;
}
return (new om_image_grid.cards.t15603(src,width,height,map__15602__$1,owner,p__15595,image_200_compo,null));
});
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"images-200-px","images-200-px",3635471466)], null),devcards.system.get_options.call(null,devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15608 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15608 = (function (owner,images,meta15609){
this.owner = owner;
this.images = images;
this.meta15609 = meta15609;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15608.cljs$lang$type = true;
om_image_grid.cards.t15608.cljs$lang$ctorStr = "om-image-grid.cards/t15608";
om_image_grid.cards.t15608.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15608");
});
om_image_grid.cards.t15608.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15608.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 2, "background-color": "#428bca"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_200_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),200,new cljs.core.Keyword(null,"spacing","spacing",3296712629),4], null)], null)));
});
om_image_grid.cards.t15608.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15610){var self__ = this;
var _15610__$1 = this;return self__.meta15609;
});
om_image_grid.cards.t15608.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15610,meta15609__$1){var self__ = this;
var _15610__$1 = this;return (new om_image_grid.cards.t15608(self__.owner,self__.images,meta15609__$1));
});
om_image_grid.cards.__GT_t15608 = (function __GT_t15608(owner__$1,images__$1,meta15609){return (new om_image_grid.cards.t15608(owner__$1,images__$1,meta15609));
});
}
return (new om_image_grid.cards.t15608(owner,images,null));
}),cljs.core.shuffle.call(null,om_image_grid.cards.images_200))),(function (){return devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15611 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15611 = (function (owner,images,meta15612){
this.owner = owner;
this.images = images;
this.meta15612 = meta15612;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15611.cljs$lang$type = true;
om_image_grid.cards.t15611.cljs$lang$ctorStr = "om-image-grid.cards/t15611";
om_image_grid.cards.t15611.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15611");
});
om_image_grid.cards.t15611.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15611.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 2, "background-color": "#428bca"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_200_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),200,new cljs.core.Keyword(null,"spacing","spacing",3296712629),4], null)], null)));
});
om_image_grid.cards.t15611.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15613){var self__ = this;
var _15613__$1 = this;return self__.meta15612;
});
om_image_grid.cards.t15611.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15613,meta15612__$1){var self__ = this;
var _15613__$1 = this;return (new om_image_grid.cards.t15611(self__.owner,self__.images,meta15612__$1));
});
om_image_grid.cards.__GT_t15611 = (function __GT_t15611(owner__$1,images__$1,meta15612){return (new om_image_grid.cards.t15611(owner__$1,images__$1,meta15612));
});
}
return (new om_image_grid.cards.t15611(owner,images,null));
}),cljs.core.shuffle.call(null,om_image_grid.cards.images_200));
}));
om_image_grid.cards.images_300 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/01.jpg",new cljs.core.Keyword(null,"width","width",1127031096),210,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/02.jpg",new cljs.core.Keyword(null,"width","width",1127031096),200,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/03.jpg",new cljs.core.Keyword(null,"width","width",1127031096),198,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/04.jpg",new cljs.core.Keyword(null,"width","width",1127031096),609,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/05.jpg",new cljs.core.Keyword(null,"width","width",1127031096),225,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/06.jpg",new cljs.core.Keyword(null,"width","width",1127031096),227,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/07.jpg",new cljs.core.Keyword(null,"width","width",1127031096),204,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/08.jpg",new cljs.core.Keyword(null,"width","width",1127031096),240,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/09.jpg",new cljs.core.Keyword(null,"width","width",1127031096),209,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/10.jpg",new cljs.core.Keyword(null,"width","width",1127031096),400,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/11.jpg",new cljs.core.Keyword(null,"width","width",1127031096),450,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/12.jpg",new cljs.core.Keyword(null,"width","width",1127031096),232,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/13.jpg",new cljs.core.Keyword(null,"width","width",1127031096),232,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/14.jpg",new cljs.core.Keyword(null,"width","width",1127031096),203,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/15.jpg",new cljs.core.Keyword(null,"width","width",1127031096),211,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/16.jpg",new cljs.core.Keyword(null,"width","width",1127031096),222,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/17.jpg",new cljs.core.Keyword(null,"width","width",1127031096),450,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/18.jpg",new cljs.core.Keyword(null,"width","width",1127031096),221,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/19.jpg",new cljs.core.Keyword(null,"width","width",1127031096),238,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"300/20.jpg",new cljs.core.Keyword(null,"width","width",1127031096),189,new cljs.core.Keyword(null,"height","height",4087841945),300], null)], null);
om_image_grid.cards.image_300_compo = (function image_300_compo(p__15614,owner){var map__15621 = p__15614;var map__15621__$1 = ((cljs.core.seq_QMARK_.call(null,map__15621))?cljs.core.apply.call(null,cljs.core.hash_map,map__15621):map__15621);var height = cljs.core.get.call(null,map__15621__$1,new cljs.core.Keyword(null,"height","height",4087841945));var width = cljs.core.get.call(null,map__15621__$1,new cljs.core.Keyword(null,"width","width",1127031096));var src = cljs.core.get.call(null,map__15621__$1,new cljs.core.Keyword(null,"src","src",1014018390));if(typeof om_image_grid.cards.t15622 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15622 = (function (src,width,height,map__15621,owner,p__15614,image_300_compo,meta15623){
this.src = src;
this.width = width;
this.height = height;
this.map__15621 = map__15621;
this.owner = owner;
this.p__15614 = p__15614;
this.image_300_compo = image_300_compo;
this.meta15623 = meta15623;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15622.cljs$lang$type = true;
om_image_grid.cards.t15622.cljs$lang$ctorStr = "om-image-grid.cards/t15622";
om_image_grid.cards.t15622.cljs$lang$ctorPrWriter = ((function (map__15621,map__15621__$1,height,width,src){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15622");
});})(map__15621,map__15621__$1,height,width,src))
;
om_image_grid.cards.t15622.prototype.om$core$IRenderState$ = true;
om_image_grid.cards.t15622.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15621,map__15621__$1,height,width,src){
return (function (_,p__15625){var self__ = this;
var map__15626 = p__15625;var map__15626__$1 = ((cljs.core.seq_QMARK_.call(null,map__15626))?cljs.core.apply.call(null,cljs.core.hash_map,map__15626):map__15626);var grid_height = cljs.core.get.call(null,map__15626__$1,new cljs.core.Keyword(null,"grid-height","grid-height",1423919360));var grid_width = cljs.core.get.call(null,map__15626__$1,new cljs.core.Keyword(null,"grid-width","grid-width",625456113));var ___$1 = this;return React.DOM.div({"style": {"padding": 5, "display": "inline-block"}},React.DOM.img({"height": (function (){var or__7931__auto__ = grid_height;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.height;
}
})(), "width": (function (){var or__7931__auto__ = grid_width;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.width;
}
})(), "src": self__.src}));
});})(map__15621,map__15621__$1,height,width,src))
;
om_image_grid.cards.t15622.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15621,map__15621__$1,height,width,src){
return (function (_15624){var self__ = this;
var _15624__$1 = this;return self__.meta15623;
});})(map__15621,map__15621__$1,height,width,src))
;
om_image_grid.cards.t15622.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15621,map__15621__$1,height,width,src){
return (function (_15624,meta15623__$1){var self__ = this;
var _15624__$1 = this;return (new om_image_grid.cards.t15622(self__.src,self__.width,self__.height,self__.map__15621,self__.owner,self__.p__15614,self__.image_300_compo,meta15623__$1));
});})(map__15621,map__15621__$1,height,width,src))
;
om_image_grid.cards.__GT_t15622 = ((function (map__15621,map__15621__$1,height,width,src){
return (function __GT_t15622(src__$1,width__$1,height__$1,map__15621__$2,owner__$1,p__15614__$1,image_300_compo__$1,meta15623){return (new om_image_grid.cards.t15622(src__$1,width__$1,height__$1,map__15621__$2,owner__$1,p__15614__$1,image_300_compo__$1,meta15623));
});})(map__15621,map__15621__$1,height,width,src))
;
}
return (new om_image_grid.cards.t15622(src,width,height,map__15621__$1,owner,p__15614,image_300_compo,null));
});
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"images-300-px","images-300-px",3664100617)], null),devcards.system.get_options.call(null,devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15627 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15627 = (function (owner,images,meta15628){
this.owner = owner;
this.images = images;
this.meta15628 = meta15628;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15627.cljs$lang$type = true;
om_image_grid.cards.t15627.cljs$lang$ctorStr = "om-image-grid.cards/t15627";
om_image_grid.cards.t15627.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15627");
});
om_image_grid.cards.t15627.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15627.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 5, "background-color": "#8a6d3b"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_300_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),300,new cljs.core.Keyword(null,"spacing","spacing",3296712629),10], null)], null)));
});
om_image_grid.cards.t15627.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15629){var self__ = this;
var _15629__$1 = this;return self__.meta15628;
});
om_image_grid.cards.t15627.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15629,meta15628__$1){var self__ = this;
var _15629__$1 = this;return (new om_image_grid.cards.t15627(self__.owner,self__.images,meta15628__$1));
});
om_image_grid.cards.__GT_t15627 = (function __GT_t15627(owner__$1,images__$1,meta15628){return (new om_image_grid.cards.t15627(owner__$1,images__$1,meta15628));
});
}
return (new om_image_grid.cards.t15627(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_300)))),(function (){return devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15630 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15630 = (function (owner,images,meta15631){
this.owner = owner;
this.images = images;
this.meta15631 = meta15631;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15630.cljs$lang$type = true;
om_image_grid.cards.t15630.cljs$lang$ctorStr = "om-image-grid.cards/t15630";
om_image_grid.cards.t15630.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15630");
});
om_image_grid.cards.t15630.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15630.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 5, "background-color": "#8a6d3b"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_300_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),300,new cljs.core.Keyword(null,"spacing","spacing",3296712629),10], null)], null)));
});
om_image_grid.cards.t15630.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15632){var self__ = this;
var _15632__$1 = this;return self__.meta15631;
});
om_image_grid.cards.t15630.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15632,meta15631__$1){var self__ = this;
var _15632__$1 = this;return (new om_image_grid.cards.t15630(self__.owner,self__.images,meta15631__$1));
});
om_image_grid.cards.__GT_t15630 = (function __GT_t15630(owner__$1,images__$1,meta15631){return (new om_image_grid.cards.t15630(owner__$1,images__$1,meta15631));
});
}
return (new om_image_grid.cards.t15630(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_300)));
}));
om_image_grid.cards.images_400 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/01.jpg",new cljs.core.Keyword(null,"width","width",1127031096),280,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/02.jpg",new cljs.core.Keyword(null,"width","width",1127031096),266,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/03.jpg",new cljs.core.Keyword(null,"width","width",1127031096),265,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/04.jpg",new cljs.core.Keyword(null,"width","width",1127031096),812,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/05.jpg",new cljs.core.Keyword(null,"width","width",1127031096),300,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/06.jpg",new cljs.core.Keyword(null,"width","width",1127031096),303,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/07.jpg",new cljs.core.Keyword(null,"width","width",1127031096),272,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/08.jpg",new cljs.core.Keyword(null,"width","width",1127031096),320,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/09.jpg",new cljs.core.Keyword(null,"width","width",1127031096),279,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/10.jpg",new cljs.core.Keyword(null,"width","width",1127031096),533,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/11.jpg",new cljs.core.Keyword(null,"width","width",1127031096),600,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/12.jpg",new cljs.core.Keyword(null,"width","width",1127031096),309,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/13.jpg",new cljs.core.Keyword(null,"width","width",1127031096),309,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/14.jpg",new cljs.core.Keyword(null,"width","width",1127031096),270,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/15.jpg",new cljs.core.Keyword(null,"width","width",1127031096),281,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/16.jpg",new cljs.core.Keyword(null,"width","width",1127031096),296,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/17.jpg",new cljs.core.Keyword(null,"width","width",1127031096),601,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/18.jpg",new cljs.core.Keyword(null,"width","width",1127031096),295,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/19.jpg",new cljs.core.Keyword(null,"width","width",1127031096),317,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",1014018390),"400/20.jpg",new cljs.core.Keyword(null,"width","width",1127031096),252,new cljs.core.Keyword(null,"height","height",4087841945),400], null)], null);
om_image_grid.cards.image_400_compo = (function image_400_compo(p__15633,owner){var map__15640 = p__15633;var map__15640__$1 = ((cljs.core.seq_QMARK_.call(null,map__15640))?cljs.core.apply.call(null,cljs.core.hash_map,map__15640):map__15640);var height = cljs.core.get.call(null,map__15640__$1,new cljs.core.Keyword(null,"height","height",4087841945));var width = cljs.core.get.call(null,map__15640__$1,new cljs.core.Keyword(null,"width","width",1127031096));var src = cljs.core.get.call(null,map__15640__$1,new cljs.core.Keyword(null,"src","src",1014018390));if(typeof om_image_grid.cards.t15641 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15641 = (function (src,width,height,map__15640,owner,p__15633,image_400_compo,meta15642){
this.src = src;
this.width = width;
this.height = height;
this.map__15640 = map__15640;
this.owner = owner;
this.p__15633 = p__15633;
this.image_400_compo = image_400_compo;
this.meta15642 = meta15642;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15641.cljs$lang$type = true;
om_image_grid.cards.t15641.cljs$lang$ctorStr = "om-image-grid.cards/t15641";
om_image_grid.cards.t15641.cljs$lang$ctorPrWriter = ((function (map__15640,map__15640__$1,height,width,src){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15641");
});})(map__15640,map__15640__$1,height,width,src))
;
om_image_grid.cards.t15641.prototype.om$core$IRenderState$ = true;
om_image_grid.cards.t15641.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15640,map__15640__$1,height,width,src){
return (function (_,p__15644){var self__ = this;
var map__15645 = p__15644;var map__15645__$1 = ((cljs.core.seq_QMARK_.call(null,map__15645))?cljs.core.apply.call(null,cljs.core.hash_map,map__15645):map__15645);var grid_height = cljs.core.get.call(null,map__15645__$1,new cljs.core.Keyword(null,"grid-height","grid-height",1423919360));var grid_width = cljs.core.get.call(null,map__15645__$1,new cljs.core.Keyword(null,"grid-width","grid-width",625456113));var ___$1 = this;return React.DOM.div({"style": {"display": "inline-block"}},React.DOM.img({"height": (function (){var or__7931__auto__ = grid_height;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.height;
}
})(), "width": (function (){var or__7931__auto__ = grid_width;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.width;
}
})(), "src": self__.src}));
});})(map__15640,map__15640__$1,height,width,src))
;
om_image_grid.cards.t15641.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15640,map__15640__$1,height,width,src){
return (function (_15643){var self__ = this;
var _15643__$1 = this;return self__.meta15642;
});})(map__15640,map__15640__$1,height,width,src))
;
om_image_grid.cards.t15641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15640,map__15640__$1,height,width,src){
return (function (_15643,meta15642__$1){var self__ = this;
var _15643__$1 = this;return (new om_image_grid.cards.t15641(self__.src,self__.width,self__.height,self__.map__15640,self__.owner,self__.p__15633,self__.image_400_compo,meta15642__$1));
});})(map__15640,map__15640__$1,height,width,src))
;
om_image_grid.cards.__GT_t15641 = ((function (map__15640,map__15640__$1,height,width,src){
return (function __GT_t15641(src__$1,width__$1,height__$1,map__15640__$2,owner__$1,p__15633__$1,image_400_compo__$1,meta15642){return (new om_image_grid.cards.t15641(src__$1,width__$1,height__$1,map__15640__$2,owner__$1,p__15633__$1,image_400_compo__$1,meta15642));
});})(map__15640,map__15640__$1,height,width,src))
;
}
return (new om_image_grid.cards.t15641(src,width,height,map__15640__$1,owner,p__15633,image_400_compo,null));
});
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"images-400-px","images-400-px",3692729768)], null),devcards.system.get_options.call(null,devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15646 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15646 = (function (owner,images,meta15647){
this.owner = owner;
this.images = images;
this.meta15647 = meta15647;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15646.cljs$lang$type = true;
om_image_grid.cards.t15646.cljs$lang$ctorStr = "om-image-grid.cards/t15646";
om_image_grid.cards.t15646.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15646");
});
om_image_grid.cards.t15646.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15646.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 10, "background-color": "#999"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_400_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),400,new cljs.core.Keyword(null,"spacing","spacing",3296712629),0], null)], null)));
});
om_image_grid.cards.t15646.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15648){var self__ = this;
var _15648__$1 = this;return self__.meta15647;
});
om_image_grid.cards.t15646.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15648,meta15647__$1){var self__ = this;
var _15648__$1 = this;return (new om_image_grid.cards.t15646(self__.owner,self__.images,meta15647__$1));
});
om_image_grid.cards.__GT_t15646 = (function __GT_t15646(owner__$1,images__$1,meta15647){return (new om_image_grid.cards.t15646(owner__$1,images__$1,meta15647));
});
}
return (new om_image_grid.cards.t15646(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_400)))),(function (){return devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15649 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15649 = (function (owner,images,meta15650){
this.owner = owner;
this.images = images;
this.meta15650 = meta15650;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15649.cljs$lang$type = true;
om_image_grid.cards.t15649.cljs$lang$ctorStr = "om-image-grid.cards/t15649";
om_image_grid.cards.t15649.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15649");
});
om_image_grid.cards.t15649.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15649.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 10, "background-color": "#999"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_400_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),400,new cljs.core.Keyword(null,"spacing","spacing",3296712629),0], null)], null)));
});
om_image_grid.cards.t15649.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15651){var self__ = this;
var _15651__$1 = this;return self__.meta15650;
});
om_image_grid.cards.t15649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15651,meta15650__$1){var self__ = this;
var _15651__$1 = this;return (new om_image_grid.cards.t15649(self__.owner,self__.images,meta15650__$1));
});
om_image_grid.cards.__GT_t15649 = (function __GT_t15649(owner__$1,images__$1,meta15650){return (new om_image_grid.cards.t15649(owner__$1,images__$1,meta15650));
});
}
return (new om_image_grid.cards.t15649(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_400)));
}));

//# sourceMappingURL=cards.js.map