// Compiled by ClojureScript 0.0-2227
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('goog.net.jsloader');
goog.require('goog.net.jsloader');
figwheel.client.log_style = "color:rgb(0,128,0);";
/**
* @param {...*} var_args
*/
figwheel.client.log = (function() { 
var log__delegate = function (p__16035,args){var map__16037 = p__16035;var map__16037__$1 = ((cljs.core.seq_QMARK_.call(null,map__16037))?cljs.core.apply.call(null,cljs.core.hash_map,map__16037):map__16037);var debug = cljs.core.get.call(null,map__16037__$1,new cljs.core.Keyword(null,"debug","debug",1109363141));if(cljs.core.truth_(debug))
{return console.log(cljs.core.to_array.call(null,args));
} else
{return null;
}
};
var log = function (p__16035,var_args){
var args = null;if (arguments.length > 1) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return log__delegate.call(this,p__16035,args);};
log.cljs$lang$maxFixedArity = 1;
log.cljs$lang$applyTo = (function (arglist__16038){
var p__16035 = cljs.core.first(arglist__16038);
var args = cljs.core.rest(arglist__16038);
return log__delegate(p__16035,args);
});
log.cljs$core$IFn$_invoke$arity$variadic = log__delegate;
return log;
})()
;
figwheel.client.reload_host = (function reload_host(p__16039){var map__16041 = p__16039;var map__16041__$1 = ((cljs.core.seq_QMARK_.call(null,map__16041))?cljs.core.apply.call(null,cljs.core.hash_map,map__16041):map__16041);var websocket_url = cljs.core.get.call(null,map__16041__$1,new cljs.core.Keyword(null,"websocket-url","websocket-url",633671131));return cljs.core.first.call(null,clojure.string.split.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,websocket_url,/^ws:/,""),/^\/\//,""),/\//));
});
figwheel.client.add_cache_buster = (function add_cache_buster(url){return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)+"?rel="+cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).getTime()));
});
figwheel.client.js_reload = (function js_reload(p__16042,callback){var map__16044 = p__16042;var map__16044__$1 = ((cljs.core.seq_QMARK_.call(null,map__16044))?cljs.core.apply.call(null,cljs.core.hash_map,map__16044):map__16044);var msg = map__16044__$1;var dependency_file = cljs.core.get.call(null,map__16044__$1,new cljs.core.Keyword(null,"dependency-file","dependency-file",2750516784));var namespace = cljs.core.get.call(null,map__16044__$1,new cljs.core.Keyword(null,"namespace","namespace",2266122445));var request_url = cljs.core.get.call(null,map__16044__$1,new cljs.core.Keyword(null,"request-url","request-url",2162835619));if(cljs.core.truth_((function (){var or__7929__auto__ = dependency_file;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return goog.isProvided_(namespace);
}
})()))
{return goog.net.jsloader.load(figwheel.client.add_cache_buster.call(null,request_url)).addCallback(((function (map__16044,map__16044__$1,msg,dependency_file,namespace,request_url){
return (function (){return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null));
});})(map__16044,map__16044__$1,msg,dependency_file,namespace,request_url))
);
} else
{return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg], null));
}
});
figwheel.client.reload_js_file = (function reload_js_file(file_msg){var out = cljs.core.async.chan.call(null);figwheel.client.js_reload.call(null,file_msg,((function (out){
return (function (url){cljs.core.async.put_BANG_.call(null,out,url);
return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);
return out;
});
figwheel.client.load_all_js_files = (function load_all_js_files(files){return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.async.filter_LT_.call(null,cljs.core.identity,cljs.core.async.merge.call(null,cljs.core.mapv.call(null,figwheel.client.reload_js_file,files))));
});
figwheel.client.add_request_url = (function add_request_url(p__16045,p__16046){var map__16049 = p__16045;var map__16049__$1 = ((cljs.core.seq_QMARK_.call(null,map__16049))?cljs.core.apply.call(null,cljs.core.hash_map,map__16049):map__16049);var opts = map__16049__$1;var url_rewriter = cljs.core.get.call(null,map__16049__$1,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",538861174));var map__16050 = p__16046;var map__16050__$1 = ((cljs.core.seq_QMARK_.call(null,map__16050))?cljs.core.apply.call(null,cljs.core.hash_map,map__16050):map__16050);var d = map__16050__$1;var file = cljs.core.get.call(null,map__16050__$1,new cljs.core.Keyword(null,"file","file",1017047278));return cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"request-url","request-url",2162835619),url_rewriter.call(null,("//"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.reload_host.call(null,opts))+cljs.core.str.cljs$core$IFn$_invoke$arity$1(file))));
});
figwheel.client.add_request_urls = (function add_request_urls(opts,files){return cljs.core.map.call(null,cljs.core.partial.call(null,figwheel.client.add_request_url,opts),files);
});
figwheel.client.reload_js_files = (function reload_js_files(p__16051,p__16052){var map__16093 = p__16051;var map__16093__$1 = ((cljs.core.seq_QMARK_.call(null,map__16093))?cljs.core.apply.call(null,cljs.core.hash_map,map__16093):map__16093);var opts = map__16093__$1;var on_jsload = cljs.core.get.call(null,map__16093__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",817745103));var before_jsload = cljs.core.get.call(null,map__16093__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",3705046831));var map__16094 = p__16052;var map__16094__$1 = ((cljs.core.seq_QMARK_.call(null,map__16094))?cljs.core.apply.call(null,cljs.core.hash_map,map__16094):map__16094);var files = cljs.core.get.call(null,map__16094__$1,new cljs.core.Keyword(null,"files","files",1111338473));var c__11412__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto__,map__16093,map__16093__$1,opts,on_jsload,before_jsload,map__16094,map__16094__$1,files){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto__,map__16093,map__16093__$1,opts,on_jsload,before_jsload,map__16094,map__16094__$1,files){
return (function (state_16116){var state_val_16117 = (state_16116[1]);if((state_val_16117 === 6))
{var inst_16099 = (state_16116[7]);var inst_16108 = (state_16116[2]);var inst_16109 = [inst_16099];var inst_16110 = (new cljs.core.PersistentVector(null,1,5,cljs.core.PersistentVector.EMPTY_NODE,inst_16109,null));var inst_16111 = cljs.core.apply.call(null,on_jsload,inst_16110);var state_16116__$1 = (function (){var statearr_16118 = state_16116;(statearr_16118[8] = inst_16108);
return statearr_16118;
})();var statearr_16119_16133 = state_16116__$1;(statearr_16119_16133[2] = inst_16111);
(statearr_16119_16133[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16117 === 5))
{var inst_16114 = (state_16116[2]);var state_16116__$1 = state_16116;return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16116__$1,inst_16114);
} else
{if((state_val_16117 === 4))
{var state_16116__$1 = state_16116;var statearr_16120_16134 = state_16116__$1;(statearr_16120_16134[2] = null);
(statearr_16120_16134[1] = 5);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16117 === 3))
{var inst_16099 = (state_16116[7]);var inst_16102 = console.log("%cFigwheel: loaded these files",figwheel.client.log_style);var inst_16103 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",1017047278),inst_16099);var inst_16104 = cljs.core.prn_str.call(null,inst_16103);var inst_16105 = console.log(inst_16104);var inst_16106 = cljs.core.async.timeout.call(null,10);var state_16116__$1 = (function (){var statearr_16121 = state_16116;(statearr_16121[9] = inst_16102);
(statearr_16121[10] = inst_16105);
return statearr_16121;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16116__$1,6,inst_16106);
} else
{if((state_val_16117 === 2))
{var inst_16099 = (state_16116[7]);var inst_16099__$1 = (state_16116[2]);var inst_16100 = cljs.core.not_empty.call(null,inst_16099__$1);var state_16116__$1 = (function (){var statearr_16122 = state_16116;(statearr_16122[7] = inst_16099__$1);
return statearr_16122;
})();if(cljs.core.truth_(inst_16100))
{var statearr_16123_16135 = state_16116__$1;(statearr_16123_16135[1] = 3);
} else
{var statearr_16124_16136 = state_16116__$1;(statearr_16124_16136[1] = 4);
}
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if((state_val_16117 === 1))
{var inst_16095 = before_jsload.call(null,files);var inst_16096 = figwheel.client.add_request_urls.call(null,opts,files);var inst_16097 = figwheel.client.load_all_js_files.call(null,inst_16096);var state_16116__$1 = (function (){var statearr_16125 = state_16116;(statearr_16125[11] = inst_16095);
return statearr_16125;
})();return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16116__$1,2,inst_16097);
} else
{return null;
}
}
}
}
}
}
});})(c__11412__auto__,map__16093,map__16093__$1,opts,on_jsload,before_jsload,map__16094,map__16094__$1,files))
;return ((function (switch__11347__auto__,c__11412__auto__,map__16093,map__16093__$1,opts,on_jsload,before_jsload,map__16094,map__16094__$1,files){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_16129 = [null,null,null,null,null,null,null,null,null,null,null,null];(statearr_16129[0] = state_machine__11348__auto__);
(statearr_16129[1] = 1);
return statearr_16129;
});
var state_machine__11348__auto____1 = (function (state_16116){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_16116);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e16130){if((e16130 instanceof Object))
{var ex__11351__auto__ = e16130;var statearr_16131_16137 = state_16116;(statearr_16131_16137[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16116);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e16130;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__16138 = state_16116;
state_16116 = G__16138;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_16116){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_16116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto__,map__16093,map__16093__$1,opts,on_jsload,before_jsload,map__16094,map__16094__$1,files))
})();var state__11414__auto__ = (function (){var statearr_16132 = f__11413__auto__.call(null);(statearr_16132[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto__);
return statearr_16132;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto__,map__16093,map__16093__$1,opts,on_jsload,before_jsload,map__16094,map__16094__$1,files))
);
return c__11412__auto__;
});
figwheel.client.current_links = (function current_links(){return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.truncate_url = (function truncate_url(url){return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),(''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol)+"//"),""),"http://",""),"https://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.matches_file_QMARK_ = (function matches_file_QMARK_(p__16139,link_href){var map__16141 = p__16139;var map__16141__$1 = ((cljs.core.seq_QMARK_.call(null,map__16141))?cljs.core.apply.call(null,cljs.core.hash_map,map__16141):map__16141);var request_url = cljs.core.get.call(null,map__16141__$1,new cljs.core.Keyword(null,"request-url","request-url",2162835619));var file = cljs.core.get.call(null,map__16141__$1,new cljs.core.Keyword(null,"file","file",1017047278));var trunc_href = figwheel.client.truncate_url.call(null,link_href);return (cljs.core._EQ_.call(null,file,trunc_href)) || (cljs.core._EQ_.call(null,figwheel.client.truncate_url.call(null,request_url),trunc_href));
});
figwheel.client.get_correct_link = (function get_correct_link(f_data){return cljs.core.some.call(null,(function (l){if(figwheel.client.matches_file_QMARK_.call(null,f_data,l.href))
{return l;
} else
{return null;
}
}),figwheel.client.current_links.call(null));
});
figwheel.client.clone_link = (function clone_link(link,url){var clone = document.createElement("link");clone.rel = "stylesheet";
clone.media = link.media;
clone.disabled = link.disabled;
clone.href = figwheel.client.add_cache_buster.call(null,url);
return clone;
});
figwheel.client.create_link = (function create_link(url){var link = document.createElement("link");link.rel = "stylesheet";
link.href = figwheel.client.add_cache_buster.call(null,url);
return link;
});
figwheel.client.add_link_to_doc = (function() {
var add_link_to_doc = null;
var add_link_to_doc__1 = (function (new_link){return (document.getElementsByTagName("head")[0]).appendChild(new_link);
});
var add_link_to_doc__2 = (function (orig_link,klone){var parent = orig_link.parentNode;if(cljs.core._EQ_.call(null,orig_link,parent.lastChild))
{parent.appendChild(klone);
} else
{parent.insertBefore(klone,orig_link.nextSibling);
}
var c__11412__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto__,parent){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto__,parent){
return (function (state_16162){var state_val_16163 = (state_16162[1]);if((state_val_16163 === 2))
{var inst_16159 = (state_16162[2]);var inst_16160 = parent.removeChild(orig_link);var state_16162__$1 = (function (){var statearr_16164 = state_16162;(statearr_16164[7] = inst_16159);
return statearr_16164;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16162__$1,inst_16160);
} else
{if((state_val_16163 === 1))
{var inst_16157 = cljs.core.async.timeout.call(null,200);var state_16162__$1 = state_16162;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16162__$1,2,inst_16157);
} else
{return null;
}
}
});})(c__11412__auto__,parent))
;return ((function (switch__11347__auto__,c__11412__auto__,parent){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_16168 = [null,null,null,null,null,null,null,null];(statearr_16168[0] = state_machine__11348__auto__);
(statearr_16168[1] = 1);
return statearr_16168;
});
var state_machine__11348__auto____1 = (function (state_16162){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_16162);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e16169){if((e16169 instanceof Object))
{var ex__11351__auto__ = e16169;var statearr_16170_16172 = state_16162;(statearr_16170_16172[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16162);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e16169;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__16173 = state_16162;
state_16162 = G__16173;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_16162){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_16162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto__,parent))
})();var state__11414__auto__ = (function (){var statearr_16171 = f__11413__auto__.call(null);(statearr_16171[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto__);
return statearr_16171;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto__,parent))
);
return c__11412__auto__;
});
add_link_to_doc = function(orig_link,klone){
switch(arguments.length){
case 1:
return add_link_to_doc__1.call(this,orig_link);
case 2:
return add_link_to_doc__2.call(this,orig_link,klone);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = add_link_to_doc__1;
add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = add_link_to_doc__2;
return add_link_to_doc;
})()
;
figwheel.client.reload_css_file = (function reload_css_file(p__16174){var map__16176 = p__16174;var map__16176__$1 = ((cljs.core.seq_QMARK_.call(null,map__16176))?cljs.core.apply.call(null,cljs.core.hash_map,map__16176):map__16176);var f_data = map__16176__$1;var request_url = cljs.core.get.call(null,map__16176__$1,new cljs.core.Keyword(null,"request-url","request-url",2162835619));var file = cljs.core.get.call(null,map__16176__$1,new cljs.core.Keyword(null,"file","file",1017047278));var temp__4124__auto__ = figwheel.client.get_correct_link.call(null,f_data);if(cljs.core.truth_(temp__4124__auto__))
{var link = temp__4124__auto__;return figwheel.client.add_link_to_doc.call(null,link,figwheel.client.clone_link.call(null,link,request_url));
} else
{return figwheel.client.add_link_to_doc.call(null,figwheel.client.create_link.call(null,request_url));
}
});
figwheel.client.reload_css_files = (function reload_css_files(p__16177,files_msg){var map__16199 = p__16177;var map__16199__$1 = ((cljs.core.seq_QMARK_.call(null,map__16199))?cljs.core.apply.call(null,cljs.core.hash_map,map__16199):map__16199);var opts = map__16199__$1;var on_cssload = cljs.core.get.call(null,map__16199__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1611735789));var seq__16200_16220 = cljs.core.seq.call(null,figwheel.client.add_request_urls.call(null,opts,new cljs.core.Keyword(null,"files","files",1111338473).cljs$core$IFn$_invoke$arity$1(files_msg)));var chunk__16201_16221 = null;var count__16202_16222 = 0;var i__16203_16223 = 0;while(true){
if((i__16203_16223 < count__16202_16222))
{var f_16224 = cljs.core._nth.call(null,chunk__16201_16221,i__16203_16223);figwheel.client.reload_css_file.call(null,f_16224);
{
var G__16225 = seq__16200_16220;
var G__16226 = chunk__16201_16221;
var G__16227 = count__16202_16222;
var G__16228 = (i__16203_16223 + 1);
seq__16200_16220 = G__16225;
chunk__16201_16221 = G__16226;
count__16202_16222 = G__16227;
i__16203_16223 = G__16228;
continue;
}
} else
{var temp__4126__auto___16229 = cljs.core.seq.call(null,seq__16200_16220);if(temp__4126__auto___16229)
{var seq__16200_16230__$1 = temp__4126__auto___16229;if(cljs.core.chunked_seq_QMARK_.call(null,seq__16200_16230__$1))
{var c__8685__auto___16231 = cljs.core.chunk_first.call(null,seq__16200_16230__$1);{
var G__16232 = cljs.core.chunk_rest.call(null,seq__16200_16230__$1);
var G__16233 = c__8685__auto___16231;
var G__16234 = cljs.core.count.call(null,c__8685__auto___16231);
var G__16235 = 0;
seq__16200_16220 = G__16232;
chunk__16201_16221 = G__16233;
count__16202_16222 = G__16234;
i__16203_16223 = G__16235;
continue;
}
} else
{var f_16236 = cljs.core.first.call(null,seq__16200_16230__$1);figwheel.client.reload_css_file.call(null,f_16236);
{
var G__16237 = cljs.core.next.call(null,seq__16200_16230__$1);
var G__16238 = null;
var G__16239 = 0;
var G__16240 = 0;
seq__16200_16220 = G__16237;
chunk__16201_16221 = G__16238;
count__16202_16222 = G__16239;
i__16203_16223 = G__16240;
continue;
}
}
} else
{}
}
break;
}
var c__11412__auto__ = cljs.core.async.chan.call(null,1);cljs.core.async.impl.dispatch.run.call(null,((function (c__11412__auto__,map__16199,map__16199__$1,opts,on_cssload){
return (function (){var f__11413__auto__ = (function (){var switch__11347__auto__ = ((function (c__11412__auto__,map__16199,map__16199__$1,opts,on_cssload){
return (function (state_16210){var state_val_16211 = (state_16210[1]);if((state_val_16211 === 2))
{var inst_16206 = (state_16210[2]);var inst_16207 = new cljs.core.Keyword(null,"files","files",1111338473).cljs$core$IFn$_invoke$arity$1(files_msg);var inst_16208 = on_cssload.call(null,inst_16207);var state_16210__$1 = (function (){var statearr_16212 = state_16210;(statearr_16212[7] = inst_16206);
return statearr_16212;
})();return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16210__$1,inst_16208);
} else
{if((state_val_16211 === 1))
{var inst_16204 = cljs.core.async.timeout.call(null,100);var state_16210__$1 = state_16210;return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16210__$1,2,inst_16204);
} else
{return null;
}
}
});})(c__11412__auto__,map__16199,map__16199__$1,opts,on_cssload))
;return ((function (switch__11347__auto__,c__11412__auto__,map__16199,map__16199__$1,opts,on_cssload){
return (function() {
var state_machine__11348__auto__ = null;
var state_machine__11348__auto____0 = (function (){var statearr_16216 = [null,null,null,null,null,null,null,null];(statearr_16216[0] = state_machine__11348__auto__);
(statearr_16216[1] = 1);
return statearr_16216;
});
var state_machine__11348__auto____1 = (function (state_16210){while(true){
var ret_value__11349__auto__ = (function (){try{while(true){
var result__11350__auto__ = switch__11347__auto__.call(null,state_16210);if(cljs.core.keyword_identical_QMARK_.call(null,result__11350__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
continue;
}
} else
{return result__11350__auto__;
}
break;
}
}catch (e16217){if((e16217 instanceof Object))
{var ex__11351__auto__ = e16217;var statearr_16218_16241 = state_16210;(statearr_16218_16241[5] = ex__11351__auto__);
cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16210);
return new cljs.core.Keyword(null,"recur","recur",1122293407);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{throw e16217;
} else
{return null;
}
}
}})();if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11349__auto__,new cljs.core.Keyword(null,"recur","recur",1122293407)))
{{
var G__16242 = state_16210;
state_16210 = G__16242;
continue;
}
} else
{return ret_value__11349__auto__;
}
break;
}
});
state_machine__11348__auto__ = function(state_16210){
switch(arguments.length){
case 0:
return state_machine__11348__auto____0.call(this);
case 1:
return state_machine__11348__auto____1.call(this,state_16210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$0 = state_machine__11348__auto____0;
state_machine__11348__auto__.cljs$core$IFn$_invoke$arity$1 = state_machine__11348__auto____1;
return state_machine__11348__auto__;
})()
;})(switch__11347__auto__,c__11412__auto__,map__16199,map__16199__$1,opts,on_cssload))
})();var state__11414__auto__ = (function (){var statearr_16219 = f__11413__auto__.call(null);(statearr_16219[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11412__auto__);
return statearr_16219;
})();return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11414__auto__);
});})(c__11412__auto__,map__16199,map__16199__$1,opts,on_cssload))
);
return c__11412__auto__;
});
figwheel.client.compile_failed = (function compile_failed(fail_msg,compile_fail_callback){return compile_fail_callback.call(null,cljs.core.dissoc.call(null,fail_msg,new cljs.core.Keyword(null,"msg-name","msg-name",3979112649)));
});
figwheel.client.figwheel_closure_import_script = (function figwheel_closure_import_script(src){if(cljs.core.truth_(goog.inHtmlDocument_()))
{goog.net.jsloader.load(figwheel.client.add_cache_buster.call(null,src));
return true;
} else
{return false;
}
});
figwheel.client.patch_goog_base = (function patch_goog_base(){goog.provide = goog.exportPath_;
return goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.figwheel_closure_import_script;
});
figwheel.client.watch_and_reload_STAR_ = (function watch_and_reload_STAR_(p__16243){var map__16248 = p__16243;var map__16248__$1 = ((cljs.core.seq_QMARK_.call(null,map__16248))?cljs.core.apply.call(null,cljs.core.hash_map,map__16248):map__16248);var opts = map__16248__$1;var on_compile_fail = cljs.core.get.call(null,map__16248__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",846779160));var jsload_callback = cljs.core.get.call(null,map__16248__$1,new cljs.core.Keyword(null,"jsload-callback","jsload-callback",3126035989));var websocket_url = cljs.core.get.call(null,map__16248__$1,new cljs.core.Keyword(null,"websocket-url","websocket-url",633671131));var retry_count = cljs.core.get.call(null,map__16248__$1,new cljs.core.Keyword(null,"retry-count","retry-count",2949373212));console.log("%cFigwheel: trying to open cljs reload socket",figwheel.client.log_style);
var socket = (new WebSocket(websocket_url));socket.onmessage = ((function (socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (msg_str){var msg = cljs.reader.read_string.call(null,msg_str.data);var pred__16249 = cljs.core._EQ_;var expr__16250 = new cljs.core.Keyword(null,"msg-name","msg-name",3979112649).cljs$core$IFn$_invoke$arity$1(msg);if(cljs.core.truth_(pred__16249.call(null,new cljs.core.Keyword(null,"files-changed","files-changed",2807270608),expr__16250)))
{return figwheel.client.reload_js_files.call(null,opts,msg);
} else
{if(cljs.core.truth_(pred__16249.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",1058553478),expr__16250)))
{return figwheel.client.reload_css_files.call(null,opts,msg);
} else
{if(cljs.core.truth_(pred__16249.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",630802569),expr__16250)))
{return figwheel.client.compile_failed.call(null,msg,on_compile_fail);
} else
{return null;
}
}
}
});})(socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
socket.onopen = ((function (socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){figwheel.client.patch_goog_base.call(null);
return console.log("%cFigwheel: socket connection established",figwheel.client.log_style);
});})(socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
socket.onclose = ((function (socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){figwheel.client.log.call(null,opts,"Figwheel: socket closed or failed to open");
if((retry_count > 0))
{return window.setTimeout(((function (socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (){return watch_and_reload_STAR_.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"retry-count","retry-count",2949373212),(retry_count - 1)));
});})(socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
,2000);
} else
{return null;
}
});})(socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
return socket.onerror = ((function (socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count){
return (function (x){return figwheel.client.log.call(null,opts,"Figwheel: socket error ");
});})(socket,map__16248,map__16248__$1,opts,on_compile_fail,jsload_callback,websocket_url,retry_count))
;
});
figwheel.client.default_on_jsload = (function default_on_jsload(url){return document.querySelector("body").dispatchEvent((new CustomEvent("figwheel.js-reload",(function (){var obj16255 = {"detail":url};return obj16255;
})())));
});
figwheel.client.get_essential_messages = (function get_essential_messages(ed){if(cljs.core.truth_(ed))
{return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",1968829305),new cljs.core.Keyword(null,"class","class",1108647146)], null)),get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",1108338651).cljs$core$IFn$_invoke$arity$1(ed)));
} else
{return null;
}
});
figwheel.client.error_msg_format = (function error_msg_format(p__16256){var map__16258 = p__16256;var map__16258__$1 = ((cljs.core.seq_QMARK_.call(null,map__16258))?cljs.core.apply.call(null,cljs.core.hash_map,map__16258):map__16258);var class$ = cljs.core.get.call(null,map__16258__$1,new cljs.core.Keyword(null,"class","class",1108647146));var message = cljs.core.get.call(null,map__16258__$1,new cljs.core.Keyword(null,"message","message",1968829305));return (''+cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)+" : "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(message));
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.default_on_compile_fail = (function default_on_compile_fail(p__16259){var map__16265 = p__16259;var map__16265__$1 = ((cljs.core.seq_QMARK_.call(null,map__16265))?cljs.core.apply.call(null,cljs.core.hash_map,map__16265):map__16265);var ed = map__16265__$1;var exception_data = cljs.core.get.call(null,map__16265__$1,new cljs.core.Keyword(null,"exception-data","exception-data",922291674));var formatted_exception = cljs.core.get.call(null,map__16265__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",1408867312));console.log("%cFigwheel: Compile Exception",figwheel.client.log_style);
var seq__16266_16270 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));var chunk__16267_16271 = null;var count__16268_16272 = 0;var i__16269_16273 = 0;while(true){
if((i__16269_16273 < count__16268_16272))
{var msg_16274 = cljs.core._nth.call(null,chunk__16267_16271,i__16269_16273);console.log(msg_16274);
{
var G__16275 = seq__16266_16270;
var G__16276 = chunk__16267_16271;
var G__16277 = count__16268_16272;
var G__16278 = (i__16269_16273 + 1);
seq__16266_16270 = G__16275;
chunk__16267_16271 = G__16276;
count__16268_16272 = G__16277;
i__16269_16273 = G__16278;
continue;
}
} else
{var temp__4126__auto___16279 = cljs.core.seq.call(null,seq__16266_16270);if(temp__4126__auto___16279)
{var seq__16266_16280__$1 = temp__4126__auto___16279;if(cljs.core.chunked_seq_QMARK_.call(null,seq__16266_16280__$1))
{var c__8685__auto___16281 = cljs.core.chunk_first.call(null,seq__16266_16280__$1);{
var G__16282 = cljs.core.chunk_rest.call(null,seq__16266_16280__$1);
var G__16283 = c__8685__auto___16281;
var G__16284 = cljs.core.count.call(null,c__8685__auto___16281);
var G__16285 = 0;
seq__16266_16270 = G__16282;
chunk__16267_16271 = G__16283;
count__16268_16272 = G__16284;
i__16269_16273 = G__16285;
continue;
}
} else
{var msg_16286 = cljs.core.first.call(null,seq__16266_16280__$1);console.log(msg_16286);
{
var G__16287 = cljs.core.next.call(null,seq__16266_16280__$1);
var G__16288 = null;
var G__16289 = 0;
var G__16290 = 0;
seq__16266_16270 = G__16287;
chunk__16267_16271 = G__16288;
count__16268_16272 = G__16289;
i__16269_16273 = G__16290;
continue;
}
}
} else
{}
}
break;
}
return ed;
});
figwheel.client.default_before_load = (function default_before_load(files){console.log("%cFigwheel: loading files",figwheel.client.log_style);
return files;
});
figwheel.client.default_on_cssload = (function default_on_cssload(files){console.log("%cFigwheel: loaded CSS files",figwheel.client.log_style);
console.log(cljs.core.prn_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",1017047278),files)));
return files;
});
figwheel.client.watch_and_reload_with_opts = (function watch_and_reload_with_opts(opts){if(cljs.core.truth_(figwheel.client.hasOwnProperty("watch_and_reload_singleton")))
{return null;
} else
{figwheel.client.watch_and_reload_singleton = figwheel.client.watch_and_reload_STAR_.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"retry-count","retry-count",2949373212),100,new cljs.core.Keyword(null,"jsload-callback","jsload-callback",3126035989),figwheel.client.default_on_jsload,new cljs.core.Keyword(null,"on-jsload","on-jsload",817745103),(function (){var or__7929__auto__ = new cljs.core.Keyword(null,"jsload-callback","jsload-callback",3126035989).cljs$core$IFn$_invoke$arity$1(opts);if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return figwheel.client.default_on_jsload;
}
})(),new cljs.core.Keyword(null,"on-cssload","on-cssload",1611735789),figwheel.client.default_on_cssload,new cljs.core.Keyword(null,"before-jsload","before-jsload",3705046831),figwheel.client.default_before_load,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",846779160),figwheel.client.default_on_compile_fail,new cljs.core.Keyword(null,"url-rewriter","url-rewriter",538861174),cljs.core.identity,new cljs.core.Keyword(null,"websocket-url","websocket-url",633671131),("ws://"+cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.host)+"/figwheel-ws")], null),opts));
}
});
/**
* @param {...*} var_args
*/
figwheel.client.watch_and_reload = (function() { 
var watch_and_reload__delegate = function (p__16291){var map__16293 = p__16291;var map__16293__$1 = ((cljs.core.seq_QMARK_.call(null,map__16293))?cljs.core.apply.call(null,cljs.core.hash_map,map__16293):map__16293);var opts = map__16293__$1;return figwheel.client.watch_and_reload_with_opts.call(null,opts);
};
var watch_and_reload = function (var_args){
var p__16291 = null;if (arguments.length > 0) {
  p__16291 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return watch_and_reload__delegate.call(this,p__16291);};
watch_and_reload.cljs$lang$maxFixedArity = 0;
watch_and_reload.cljs$lang$applyTo = (function (arglist__16294){
var p__16291 = cljs.core.seq(arglist__16294);
return watch_and_reload__delegate(p__16291);
});
watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = watch_and_reload__delegate;
return watch_and_reload;
})()
;

//# sourceMappingURL=client.js.map