// Compiled by ClojureScript 0.0-2227
goog.provide('crate.binding');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('clojure.set');

/**
* @constructor
*/
crate.binding.SubAtom = (function (atm,path,prevhash,watches,key){
this.atm = atm;
this.path = path;
this.prevhash = prevhash;
this.watches = watches;
this.key = key;
this.cljs$lang$protocol_mask$partition0$ = 2153807872;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
crate.binding.SubAtom.cljs$lang$type = true;
crate.binding.SubAtom.cljs$lang$ctorStr = "crate.binding/SubAtom";
crate.binding.SubAtom.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"crate.binding/SubAtom");
});
crate.binding.SubAtom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return goog.getUid(this$__$1);
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){var self__ = this;
var this$__$1 = this;var seq__20024 = cljs.core.seq.call(null,self__.watches);var chunk__20025 = null;var count__20026 = 0;var i__20027 = 0;while(true){
if((i__20027 < count__20026))
{var vec__20028 = cljs.core._nth.call(null,chunk__20025,i__20027);var key__$1 = cljs.core.nth.call(null,vec__20028,0,null);var f = cljs.core.nth.call(null,vec__20028,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__20030 = seq__20024;
var G__20031 = chunk__20025;
var G__20032 = count__20026;
var G__20033 = (i__20027 + 1);
seq__20024 = G__20030;
chunk__20025 = G__20031;
count__20026 = G__20032;
i__20027 = G__20033;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__20024);if(temp__4126__auto__)
{var seq__20024__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__20024__$1))
{var c__8685__auto__ = cljs.core.chunk_first.call(null,seq__20024__$1);{
var G__20034 = cljs.core.chunk_rest.call(null,seq__20024__$1);
var G__20035 = c__8685__auto__;
var G__20036 = cljs.core.count.call(null,c__8685__auto__);
var G__20037 = 0;
seq__20024 = G__20034;
chunk__20025 = G__20035;
count__20026 = G__20036;
i__20027 = G__20037;
continue;
}
} else
{var vec__20029 = cljs.core.first.call(null,seq__20024__$1);var key__$1 = cljs.core.nth.call(null,vec__20029,0,null);var f = cljs.core.nth.call(null,vec__20029,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__20038 = cljs.core.next.call(null,seq__20024__$1);
var G__20039 = null;
var G__20040 = 0;
var G__20041 = 0;
seq__20024 = G__20038;
chunk__20025 = G__20039;
count__20026 = G__20040;
i__20027 = G__20041;
continue;
}
}
} else
{return null;
}
}
break;
}
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key__$1,f){var self__ = this;
var this$__$1 = this;if(cljs.core.truth_(f))
{return this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key__$1,f);
} else
{return null;
}
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key__$1){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key__$1);
});
crate.binding.SubAtom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){var self__ = this;
var this$__$1 = this;return cljs.core._write.call(null,writer,("#<SubAtom: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,self__.atm),self__.path)))+">"));
});
crate.binding.SubAtom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return cljs.core.get_in.call(null,cljs.core.deref.call(null,self__.atm),self__.path);
});
crate.binding.SubAtom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){var self__ = this;
var o__$1 = this;return (o__$1 === other);
});
crate.binding.__GT_SubAtom = (function __GT_SubAtom(atm,path,prevhash,watches,key){return (new crate.binding.SubAtom(atm,path,prevhash,watches,key));
});
crate.binding.subatom = (function subatom(atm,path){var path__$1 = ((cljs.core.coll_QMARK_.call(null,path))?path:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [path], null));var vec__20043 = (((atm instanceof crate.binding.SubAtom))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atm.atm,cljs.core.concat.call(null,atm.path,path__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atm,path__$1], null));var atm__$1 = cljs.core.nth.call(null,vec__20043,0,null);var path__$2 = cljs.core.nth.call(null,vec__20043,1,null);var k = cljs.core.gensym.call(null,"subatom");var sa = (new crate.binding.SubAtom(atm__$1,path__$2,cljs.core.hash.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,atm__$1),path__$2)),null,k));cljs.core.add_watch.call(null,atm__$1,k,((function (path__$1,vec__20043,atm__$1,path__$2,k,sa){
return (function (_,___$1,ov,nv){var latest = cljs.core.get_in.call(null,nv,path__$2);var prev = cljs.core.get_in.call(null,ov,path__$2);var latest_hash = cljs.core.hash.call(null,latest);if((cljs.core.not_EQ_.call(null,sa.prevhash,latest_hash)) && (cljs.core.not_EQ_.call(null,prev,latest)))
{sa.prevhash = latest_hash;
return cljs.core._notify_watches.call(null,sa,cljs.core.get_in.call(null,ov,path__$2),latest);
} else
{return null;
}
});})(path__$1,vec__20043,atm__$1,path__$2,k,sa))
);
return sa;
});
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
crate.binding.sub_reset_BANG_ = (function sub_reset_BANG_(sa,new_value){cljs.core.swap_BANG_.call(null,sa.atm,cljs.core.assoc_in,sa.path,new_value);
return new_value;
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
crate.binding.sub_swap_BANG_ = (function() {
var sub_swap_BANG_ = null;
var sub_swap_BANG___2 = (function (sa,f){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa)));
});
var sub_swap_BANG___3 = (function (sa,f,x){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x));
});
var sub_swap_BANG___4 = (function (sa,f,x,y){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x,y));
});
var sub_swap_BANG___5 = (function (sa,f,x,y,z){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x,y,z));
});
var sub_swap_BANG___6 = (function() { 
var G__20044__delegate = function (sa,f,x,y,z,more){return crate.binding.sub_reset_BANG_.call(null,sa,cljs.core.apply.call(null,f,cljs.core.deref.call(null,sa),x,y,z,more));
};
var G__20044 = function (sa,f,x,y,z,var_args){
var more = null;if (arguments.length > 5) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);} 
return G__20044__delegate.call(this,sa,f,x,y,z,more);};
G__20044.cljs$lang$maxFixedArity = 5;
G__20044.cljs$lang$applyTo = (function (arglist__20045){
var sa = cljs.core.first(arglist__20045);
arglist__20045 = cljs.core.next(arglist__20045);
var f = cljs.core.first(arglist__20045);
arglist__20045 = cljs.core.next(arglist__20045);
var x = cljs.core.first(arglist__20045);
arglist__20045 = cljs.core.next(arglist__20045);
var y = cljs.core.first(arglist__20045);
arglist__20045 = cljs.core.next(arglist__20045);
var z = cljs.core.first(arglist__20045);
var more = cljs.core.rest(arglist__20045);
return G__20044__delegate(sa,f,x,y,z,more);
});
G__20044.cljs$core$IFn$_invoke$arity$variadic = G__20044__delegate;
return G__20044;
})()
;
sub_swap_BANG_ = function(sa,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return sub_swap_BANG___2.call(this,sa,f);
case 3:
return sub_swap_BANG___3.call(this,sa,f,x);
case 4:
return sub_swap_BANG___4.call(this,sa,f,x,y);
case 5:
return sub_swap_BANG___5.call(this,sa,f,x,y,z);
default:
return sub_swap_BANG___6.cljs$core$IFn$_invoke$arity$variadic(sa,f,x,y,z, cljs.core.array_seq(arguments, 5));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub_swap_BANG_.cljs$lang$maxFixedArity = 5;
sub_swap_BANG_.cljs$lang$applyTo = sub_swap_BANG___6.cljs$lang$applyTo;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = sub_swap_BANG___2;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = sub_swap_BANG___3;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = sub_swap_BANG___4;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = sub_swap_BANG___5;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = sub_swap_BANG___6.cljs$core$IFn$_invoke$arity$variadic;
return sub_swap_BANG_;
})()
;
crate.binding.sub_destroy_BANG_ = (function sub_destroy_BANG_(sa){cljs.core.remove_watch.call(null,sa.atm,sa.key);
sa.watches = null;
return sa.atm = null;
});
crate.binding.computable = (function (){var obj20047 = {};return obj20047;
})();
crate.binding._compute = (function _compute(this$){if((function (){var and__7917__auto__ = this$;if(and__7917__auto__)
{return this$.crate$binding$computable$_compute$arity$1;
} else
{return and__7917__auto__;
}
})())
{return this$.crate$binding$computable$_compute$arity$1(this$);
} else
{var x__8556__auto__ = (((this$ == null))?null:this$);return (function (){var or__7929__auto__ = (crate.binding._compute[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (crate.binding._compute["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"computable.-compute",this$);
}
}
})().call(null,this$);
}
});

/**
* @constructor
*/
crate.binding.Computed = (function (atms,value,func,watches,key){
this.atms = atms;
this.value = value;
this.func = func;
this.watches = watches;
this.key = key;
this.cljs$lang$protocol_mask$partition0$ = 2153807872;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
crate.binding.Computed.cljs$lang$type = true;
crate.binding.Computed.cljs$lang$ctorStr = "crate.binding/Computed";
crate.binding.Computed.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"crate.binding/Computed");
});
crate.binding.Computed.prototype.crate$binding$computable$ = true;
crate.binding.Computed.prototype.crate$binding$computable$_compute$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;var old = this$__$1.value;this$__$1.value = cljs.core.apply.call(null,self__.func,cljs.core.map.call(null,cljs.core.deref,self__.atms));
return cljs.core._notify_watches.call(null,this$__$1,old,this$__$1.value);
});
crate.binding.Computed.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return goog.getUid(this$__$1);
});
crate.binding.Computed.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){var self__ = this;
var this$__$1 = this;var seq__20048 = cljs.core.seq.call(null,self__.watches);var chunk__20049 = null;var count__20050 = 0;var i__20051 = 0;while(true){
if((i__20051 < count__20050))
{var vec__20052 = cljs.core._nth.call(null,chunk__20049,i__20051);var key__$1 = cljs.core.nth.call(null,vec__20052,0,null);var f = cljs.core.nth.call(null,vec__20052,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__20054 = seq__20048;
var G__20055 = chunk__20049;
var G__20056 = count__20050;
var G__20057 = (i__20051 + 1);
seq__20048 = G__20054;
chunk__20049 = G__20055;
count__20050 = G__20056;
i__20051 = G__20057;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__20048);if(temp__4126__auto__)
{var seq__20048__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__20048__$1))
{var c__8685__auto__ = cljs.core.chunk_first.call(null,seq__20048__$1);{
var G__20058 = cljs.core.chunk_rest.call(null,seq__20048__$1);
var G__20059 = c__8685__auto__;
var G__20060 = cljs.core.count.call(null,c__8685__auto__);
var G__20061 = 0;
seq__20048 = G__20058;
chunk__20049 = G__20059;
count__20050 = G__20060;
i__20051 = G__20061;
continue;
}
} else
{var vec__20053 = cljs.core.first.call(null,seq__20048__$1);var key__$1 = cljs.core.nth.call(null,vec__20053,0,null);var f = cljs.core.nth.call(null,vec__20053,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__20062 = cljs.core.next.call(null,seq__20048__$1);
var G__20063 = null;
var G__20064 = 0;
var G__20065 = 0;
seq__20048 = G__20062;
chunk__20049 = G__20063;
count__20050 = G__20064;
i__20051 = G__20065;
continue;
}
}
} else
{return null;
}
}
break;
}
});
crate.binding.Computed.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key__$1,f){var self__ = this;
var this$__$1 = this;if(cljs.core.truth_(f))
{return this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key__$1,f);
} else
{return null;
}
});
crate.binding.Computed.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key__$1){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key__$1);
});
crate.binding.Computed.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){var self__ = this;
var this$__$1 = this;return cljs.core._write.call(null,writer,("#<Computed: "+cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_str.call(null,self__.value))+">"));
});
crate.binding.Computed.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.value;
});
crate.binding.Computed.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){var self__ = this;
var o__$1 = this;return (o__$1 === other);
});
crate.binding.__GT_Computed = (function __GT_Computed(atms,value,func,watches,key){return (new crate.binding.Computed(atms,value,func,watches,key));
});
crate.binding.computed = (function computed(atms,func){var k = cljs.core.gensym.call(null,"computed");var neue = (new crate.binding.Computed(atms,null,func,null,k));crate.binding._compute.call(null,neue);
var seq__20070_20074 = cljs.core.seq.call(null,atms);var chunk__20071_20075 = null;var count__20072_20076 = 0;var i__20073_20077 = 0;while(true){
if((i__20073_20077 < count__20072_20076))
{var atm_20078 = cljs.core._nth.call(null,chunk__20071_20075,i__20073_20077);cljs.core.add_watch.call(null,atm_20078,k,((function (seq__20070_20074,chunk__20071_20075,count__20072_20076,i__20073_20077,atm_20078,k,neue){
return (function (_,___$1,___$2,___$3){return crate.binding._compute.call(null,neue);
});})(seq__20070_20074,chunk__20071_20075,count__20072_20076,i__20073_20077,atm_20078,k,neue))
);
{
var G__20079 = seq__20070_20074;
var G__20080 = chunk__20071_20075;
var G__20081 = count__20072_20076;
var G__20082 = (i__20073_20077 + 1);
seq__20070_20074 = G__20079;
chunk__20071_20075 = G__20080;
count__20072_20076 = G__20081;
i__20073_20077 = G__20082;
continue;
}
} else
{var temp__4126__auto___20083 = cljs.core.seq.call(null,seq__20070_20074);if(temp__4126__auto___20083)
{var seq__20070_20084__$1 = temp__4126__auto___20083;if(cljs.core.chunked_seq_QMARK_.call(null,seq__20070_20084__$1))
{var c__8685__auto___20085 = cljs.core.chunk_first.call(null,seq__20070_20084__$1);{
var G__20086 = cljs.core.chunk_rest.call(null,seq__20070_20084__$1);
var G__20087 = c__8685__auto___20085;
var G__20088 = cljs.core.count.call(null,c__8685__auto___20085);
var G__20089 = 0;
seq__20070_20074 = G__20086;
chunk__20071_20075 = G__20087;
count__20072_20076 = G__20088;
i__20073_20077 = G__20089;
continue;
}
} else
{var atm_20090 = cljs.core.first.call(null,seq__20070_20084__$1);cljs.core.add_watch.call(null,atm_20090,k,((function (seq__20070_20074,chunk__20071_20075,count__20072_20076,i__20073_20077,atm_20090,seq__20070_20084__$1,temp__4126__auto___20083,k,neue){
return (function (_,___$1,___$2,___$3){return crate.binding._compute.call(null,neue);
});})(seq__20070_20074,chunk__20071_20075,count__20072_20076,i__20073_20077,atm_20090,seq__20070_20084__$1,temp__4126__auto___20083,k,neue))
);
{
var G__20091 = cljs.core.next.call(null,seq__20070_20084__$1);
var G__20092 = null;
var G__20093 = 0;
var G__20094 = 0;
seq__20070_20074 = G__20091;
chunk__20071_20075 = G__20092;
count__20072_20076 = G__20093;
i__20073_20077 = G__20094;
continue;
}
}
} else
{}
}
break;
}
return neue;
});
crate.binding.z = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
crate.binding.y = crate.binding.computed.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crate.binding.z], null),(function (z){return cljs.core.filter.call(null,cljs.core.even_QMARK_,z);
}));
crate.binding.r = crate.binding.computed.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [crate.binding.y], null),(function (y){return cljs.core.filter.call(null,(function (p1__20095_SHARP_){return (p1__20095_SHARP_ > 100);
}),y);
}));
cljs.core.swap_BANG_.call(null,crate.binding.z,cljs.core.conj,1340);
cljs.core.deref.call(null,crate.binding.y);
cljs.core.deref.call(null,crate.binding.r);
crate.binding.notify = (function notify(w,o,v){return cljs.core._notify_watches.call(null,w,o,v);
});
crate.binding.bindable_coll = (function (){var obj20097 = {};return obj20097;
})();
crate.binding.bindable = (function (){var obj20099 = {};return obj20099;
})();
crate.binding._value = (function _value(this$){if((function (){var and__7917__auto__ = this$;if(and__7917__auto__)
{return this$.crate$binding$bindable$_value$arity$1;
} else
{return and__7917__auto__;
}
})())
{return this$.crate$binding$bindable$_value$arity$1(this$);
} else
{var x__8556__auto__ = (((this$ == null))?null:this$);return (function (){var or__7929__auto__ = (crate.binding._value[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (crate.binding._value["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"bindable.-value",this$);
}
}
})().call(null,this$);
}
});
crate.binding._on_change = (function _on_change(this$,func){if((function (){var and__7917__auto__ = this$;if(and__7917__auto__)
{return this$.crate$binding$bindable$_on_change$arity$2;
} else
{return and__7917__auto__;
}
})())
{return this$.crate$binding$bindable$_on_change$arity$2(this$,func);
} else
{var x__8556__auto__ = (((this$ == null))?null:this$);return (function (){var or__7929__auto__ = (crate.binding._on_change[goog.typeOf(x__8556__auto__)]);if(or__7929__auto__)
{return or__7929__auto__;
} else
{var or__7929__auto____$1 = (crate.binding._on_change["_"]);if(or__7929__auto____$1)
{return or__7929__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"bindable.-on-change",this$);
}
}
})().call(null,this$,func);
}
});

/**
* @constructor
*/
crate.binding.atom_binding = (function (atm,value_func){
this.atm = atm;
this.value_func = value_func;
})
crate.binding.atom_binding.cljs$lang$type = true;
crate.binding.atom_binding.cljs$lang$ctorStr = "crate.binding/atom-binding";
crate.binding.atom_binding.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"crate.binding/atom-binding");
});
crate.binding.atom_binding.prototype.crate$binding$bindable$ = true;
crate.binding.atom_binding.prototype.crate$binding$bindable$_value$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return self__.value_func.call(null,cljs.core.deref.call(null,self__.atm));
});
crate.binding.atom_binding.prototype.crate$binding$bindable$_on_change$arity$2 = (function (this$,func){var self__ = this;
var this$__$1 = this;return cljs.core.add_watch.call(null,self__.atm,cljs.core.gensym.call(null,"atom-binding"),((function (this$__$1){
return (function (){return func.call(null,crate.binding._value.call(null,this$__$1));
});})(this$__$1))
);
});
crate.binding.__GT_atom_binding = (function __GT_atom_binding(atm,value_func){return (new crate.binding.atom_binding(atm,value_func));
});

/**
* @constructor
*/
crate.binding.notifier = (function (watches){
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 0;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
crate.binding.notifier.cljs$lang$type = true;
crate.binding.notifier.cljs$lang$ctorStr = "crate.binding/notifier";
crate.binding.notifier.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"crate.binding/notifier");
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){var self__ = this;
var this$__$1 = this;var seq__20100 = cljs.core.seq.call(null,self__.watches);var chunk__20101 = null;var count__20102 = 0;var i__20103 = 0;while(true){
if((i__20103 < count__20102))
{var vec__20104 = cljs.core._nth.call(null,chunk__20101,i__20103);var key = cljs.core.nth.call(null,vec__20104,0,null);var f = cljs.core.nth.call(null,vec__20104,1,null);f.call(null,key,this$__$1,oldval,newval);
{
var G__20106 = seq__20100;
var G__20107 = chunk__20101;
var G__20108 = count__20102;
var G__20109 = (i__20103 + 1);
seq__20100 = G__20106;
chunk__20101 = G__20107;
count__20102 = G__20108;
i__20103 = G__20109;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__20100);if(temp__4126__auto__)
{var seq__20100__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__20100__$1))
{var c__8685__auto__ = cljs.core.chunk_first.call(null,seq__20100__$1);{
var G__20110 = cljs.core.chunk_rest.call(null,seq__20100__$1);
var G__20111 = c__8685__auto__;
var G__20112 = cljs.core.count.call(null,c__8685__auto__);
var G__20113 = 0;
seq__20100 = G__20110;
chunk__20101 = G__20111;
count__20102 = G__20112;
i__20103 = G__20113;
continue;
}
} else
{var vec__20105 = cljs.core.first.call(null,seq__20100__$1);var key = cljs.core.nth.call(null,vec__20105,0,null);var f = cljs.core.nth.call(null,vec__20105,1,null);f.call(null,key,this$__$1,oldval,newval);
{
var G__20114 = cljs.core.next.call(null,seq__20100__$1);
var G__20115 = null;
var G__20116 = 0;
var G__20117 = 0;
seq__20100 = G__20114;
chunk__20101 = G__20115;
count__20102 = G__20116;
i__20103 = G__20117;
continue;
}
}
} else
{return null;
}
}
break;
}
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key,f);
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key);
});
crate.binding.__GT_notifier = (function __GT_notifier(watches){return (new crate.binding.notifier(watches));
});

/**
* @constructor
*/
crate.binding.bound_collection = (function (atm,notif,opts,stuff){
this.atm = atm;
this.notif = notif;
this.opts = opts;
this.stuff = stuff;
})
crate.binding.bound_collection.cljs$lang$type = true;
crate.binding.bound_collection.cljs$lang$ctorStr = "crate.binding/bound-collection";
crate.binding.bound_collection.cljs$lang$ctorPrWriter = (function (this__8496__auto__,writer__8497__auto__,opt__8498__auto__){return cljs.core._write.call(null,writer__8497__auto__,"crate.binding/bound-collection");
});
crate.binding.bound_collection.prototype.crate$binding$bindable$ = true;
crate.binding.bound_collection.prototype.crate$binding$bindable$_value$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return cljs.core.map.call(null,new cljs.core.Keyword(null,"elem","elem",1017020161),cljs.core.vals.call(null,this$__$1.stuff));
});
crate.binding.bound_collection.prototype.crate$binding$bindable$_on_change$arity$2 = (function (this$,func){var self__ = this;
var this$__$1 = this;return cljs.core.add_watch.call(null,self__.notif,cljs.core.gensym.call(null,"bound-coll"),((function (this$__$1){
return (function (_,___$1,___$2,p__20118){var vec__20119 = p__20118;var event = cljs.core.nth.call(null,vec__20119,0,null);var el = cljs.core.nth.call(null,vec__20119,1,null);var v = cljs.core.nth.call(null,vec__20119,2,null);return func.call(null,event,el,v);
});})(this$__$1))
);
});
crate.binding.bound_collection.prototype.crate$binding$bindable_coll$ = true;
crate.binding.__GT_bound_collection = (function __GT_bound_collection(atm,notif,opts,stuff){return (new crate.binding.bound_collection(atm,notif,opts,stuff));
});
crate.binding.opt = (function opt(bc,k){return bc.opts.call(null,k);
});
crate.binding.bc_add = (function bc_add(bc,path,key){var sa = crate.binding.subatom.call(null,bc.atm,path);var elem = crate.binding.opt.call(null,bc,new cljs.core.Keyword(null,"as","as",1013907364)).call(null,sa);bc.stuff = cljs.core.assoc.call(null,bc.stuff,key,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"elem","elem",1017020161),elem,new cljs.core.Keyword(null,"subatom","subatom",3440732931),sa], null));
return crate.binding.notify.call(null,bc.notif,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"add","add",1014000659),elem,cljs.core.deref.call(null,sa)], null));
});
crate.binding.bc_remove = (function bc_remove(bc,key){var notif = bc.notif;var prev = bc.stuff.call(null,key);bc.stuff = cljs.core.dissoc.call(null,bc.stuff,key);
crate.binding.notify.call(null,bc.notif,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remove","remove",4374260726),new cljs.core.Keyword(null,"elem","elem",1017020161).cljs$core$IFn$_invoke$arity$1(prev),null], null));
return crate.binding.sub_destroy_BANG_.call(null,new cljs.core.Keyword(null,"subatom","subatom",3440732931).cljs$core$IFn$_invoke$arity$1(prev));
});
crate.binding.__GT_indexed = (function __GT_indexed(coll){if(cljs.core.map_QMARK_.call(null,coll))
{return cljs.core.seq.call(null,coll);
} else
{if(cljs.core.set_QMARK_.call(null,coll))
{return cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.identity,cljs.core.identity),coll);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
} else
{return null;
}
}
}
});
crate.binding.__GT_keyed = (function __GT_keyed(coll,keyfn){return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,keyfn,crate.binding.__GT_indexed.call(null,coll)));
});
/**
* @param {...*} var_args
*/
crate.binding.__GT_path = (function() { 
var __GT_path__delegate = function (bc,segs){return cljs.core.concat.call(null,(function (){var or__7929__auto__ = crate.binding.opt.call(null,bc,new cljs.core.Keyword(null,"path","path",1017337751));if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),segs);
};
var __GT_path = function (bc,var_args){
var segs = null;if (arguments.length > 1) {
  segs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __GT_path__delegate.call(this,bc,segs);};
__GT_path.cljs$lang$maxFixedArity = 1;
__GT_path.cljs$lang$applyTo = (function (arglist__20120){
var bc = cljs.core.first(arglist__20120);
var segs = cljs.core.rest(arglist__20120);
return __GT_path__delegate(bc,segs);
});
__GT_path.cljs$core$IFn$_invoke$arity$variadic = __GT_path__delegate;
return __GT_path;
})()
;
crate.binding.bc_compare = (function bc_compare(bc,neue){var prev = bc.stuff;var pset = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.keys.call(null,prev));var nset = crate.binding.__GT_keyed.call(null,neue,crate.binding.opt.call(null,bc,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433)));var added = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,nset,pset));var removed = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,pset,nset));var seq__20129_20137 = cljs.core.seq.call(null,added);var chunk__20130_20138 = null;var count__20131_20139 = 0;var i__20132_20140 = 0;while(true){
if((i__20132_20140 < count__20131_20139))
{var a_20141 = cljs.core._nth.call(null,chunk__20130_20138,i__20132_20140);crate.binding.bc_add.call(null,bc,a_20141,a_20141);
{
var G__20142 = seq__20129_20137;
var G__20143 = chunk__20130_20138;
var G__20144 = count__20131_20139;
var G__20145 = (i__20132_20140 + 1);
seq__20129_20137 = G__20142;
chunk__20130_20138 = G__20143;
count__20131_20139 = G__20144;
i__20132_20140 = G__20145;
continue;
}
} else
{var temp__4126__auto___20146 = cljs.core.seq.call(null,seq__20129_20137);if(temp__4126__auto___20146)
{var seq__20129_20147__$1 = temp__4126__auto___20146;if(cljs.core.chunked_seq_QMARK_.call(null,seq__20129_20147__$1))
{var c__8685__auto___20148 = cljs.core.chunk_first.call(null,seq__20129_20147__$1);{
var G__20149 = cljs.core.chunk_rest.call(null,seq__20129_20147__$1);
var G__20150 = c__8685__auto___20148;
var G__20151 = cljs.core.count.call(null,c__8685__auto___20148);
var G__20152 = 0;
seq__20129_20137 = G__20149;
chunk__20130_20138 = G__20150;
count__20131_20139 = G__20151;
i__20132_20140 = G__20152;
continue;
}
} else
{var a_20153 = cljs.core.first.call(null,seq__20129_20147__$1);crate.binding.bc_add.call(null,bc,a_20153,a_20153);
{
var G__20154 = cljs.core.next.call(null,seq__20129_20147__$1);
var G__20155 = null;
var G__20156 = 0;
var G__20157 = 0;
seq__20129_20137 = G__20154;
chunk__20130_20138 = G__20155;
count__20131_20139 = G__20156;
i__20132_20140 = G__20157;
continue;
}
}
} else
{}
}
break;
}
var seq__20133 = cljs.core.seq.call(null,removed);var chunk__20134 = null;var count__20135 = 0;var i__20136 = 0;while(true){
if((i__20136 < count__20135))
{var r = cljs.core._nth.call(null,chunk__20134,i__20136);crate.binding.bc_remove.call(null,bc,r);
{
var G__20158 = seq__20133;
var G__20159 = chunk__20134;
var G__20160 = count__20135;
var G__20161 = (i__20136 + 1);
seq__20133 = G__20158;
chunk__20134 = G__20159;
count__20135 = G__20160;
i__20136 = G__20161;
continue;
}
} else
{var temp__4126__auto__ = cljs.core.seq.call(null,seq__20133);if(temp__4126__auto__)
{var seq__20133__$1 = temp__4126__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__20133__$1))
{var c__8685__auto__ = cljs.core.chunk_first.call(null,seq__20133__$1);{
var G__20162 = cljs.core.chunk_rest.call(null,seq__20133__$1);
var G__20163 = c__8685__auto__;
var G__20164 = cljs.core.count.call(null,c__8685__auto__);
var G__20165 = 0;
seq__20133 = G__20162;
chunk__20134 = G__20163;
count__20135 = G__20164;
i__20136 = G__20165;
continue;
}
} else
{var r = cljs.core.first.call(null,seq__20133__$1);crate.binding.bc_remove.call(null,bc,r);
{
var G__20166 = cljs.core.next.call(null,seq__20133__$1);
var G__20167 = null;
var G__20168 = 0;
var G__20169 = 0;
seq__20133 = G__20166;
chunk__20134 = G__20167;
count__20135 = G__20168;
i__20136 = G__20169;
continue;
}
}
} else
{return null;
}
}
break;
}
});
/**
* @param {...*} var_args
*/
crate.binding.bound_coll = (function() { 
var bound_coll__delegate = function (atm,p__20170){var vec__20173 = p__20170;var path = cljs.core.nth.call(null,vec__20173,0,null);var opts = cljs.core.nth.call(null,vec__20173,1,null);var vec__20174 = (cljs.core.truth_(opts)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,opts], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,path], null));var path__$1 = cljs.core.nth.call(null,vec__20174,0,null);var opts__$1 = cljs.core.nth.call(null,vec__20174,1,null);var atm__$1 = ((cljs.core.not.call(null,path__$1))?atm:crate.binding.subatom.call(null,atm,path__$1));var opts__$2 = cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"path","path",1017337751),path__$1);var opts__$3 = ((cljs.core.not.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$2)))?cljs.core.assoc.call(null,opts__$2,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.first):cljs.core.assoc.call(null,opts__$2,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.comp.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$2),cljs.core.second)));var bc = (new crate.binding.bound_collection(atm__$1,(new crate.binding.notifier(null)),opts__$3,cljs.core.sorted_map.call(null)));cljs.core.add_watch.call(null,atm__$1,cljs.core.gensym.call(null,"bound-coll"),((function (vec__20174,path__$1,opts__$1,atm__$1,opts__$2,opts__$3,bc,vec__20173,path,opts){
return (function (_,___$1,___$2,neue){return crate.binding.bc_compare.call(null,bc,neue);
});})(vec__20174,path__$1,opts__$1,atm__$1,opts__$2,opts__$3,bc,vec__20173,path,opts))
);
crate.binding.bc_compare.call(null,bc,cljs.core.deref.call(null,atm__$1));
return bc;
};
var bound_coll = function (atm,var_args){
var p__20170 = null;if (arguments.length > 1) {
  p__20170 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return bound_coll__delegate.call(this,atm,p__20170);};
bound_coll.cljs$lang$maxFixedArity = 1;
bound_coll.cljs$lang$applyTo = (function (arglist__20175){
var atm = cljs.core.first(arglist__20175);
var p__20170 = cljs.core.rest(arglist__20175);
return bound_coll__delegate(atm,p__20170);
});
bound_coll.cljs$core$IFn$_invoke$arity$variadic = bound_coll__delegate;
return bound_coll;
})()
;
/**
* @param {...*} var_args
*/
crate.binding.map_bound = (function() { 
var map_bound__delegate = function (as,atm,p__20176){var vec__20178 = p__20176;var opts = cljs.core.nth.call(null,vec__20178,0,null);var opts__$1 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"as","as",1013907364),as);var atm__$1 = ((cljs.core.not.call(null,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(opts__$1)))?atm:crate.binding.subatom.call(null,atm,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(opts__$1)));var opts__$2 = ((cljs.core.not.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$1)))?cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.first):cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.comp.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$1),cljs.core.second)));var bc = (new crate.binding.bound_collection(atm__$1,(new crate.binding.notifier(null)),opts__$2,cljs.core.sorted_map.call(null)));cljs.core.add_watch.call(null,atm__$1,cljs.core.gensym.call(null,"bound-coll"),((function (opts__$1,atm__$1,opts__$2,bc,vec__20178,opts){
return (function (_,___$1,___$2,neue){return crate.binding.bc_compare.call(null,bc,neue);
});})(opts__$1,atm__$1,opts__$2,bc,vec__20178,opts))
);
crate.binding.bc_compare.call(null,bc,cljs.core.deref.call(null,atm__$1));
return bc;
};
var map_bound = function (as,atm,var_args){
var p__20176 = null;if (arguments.length > 2) {
  p__20176 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return map_bound__delegate.call(this,as,atm,p__20176);};
map_bound.cljs$lang$maxFixedArity = 2;
map_bound.cljs$lang$applyTo = (function (arglist__20179){
var as = cljs.core.first(arglist__20179);
arglist__20179 = cljs.core.next(arglist__20179);
var atm = cljs.core.first(arglist__20179);
var p__20176 = cljs.core.rest(arglist__20179);
return map_bound__delegate(as,atm,p__20176);
});
map_bound.cljs$core$IFn$_invoke$arity$variadic = map_bound__delegate;
return map_bound;
})()
;
crate.binding.binding_QMARK_ = (function binding_QMARK_(b){var G__20181 = b;if(G__20181)
{var bit__8579__auto__ = null;if(cljs.core.truth_((function (){var or__7929__auto__ = bit__8579__auto__;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return G__20181.crate$binding$bindable$;
}
})()))
{return true;
} else
{if((!G__20181.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable,G__20181);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable,G__20181);
}
});
crate.binding.binding_coll_QMARK_ = (function binding_coll_QMARK_(b){var G__20183 = b;if(G__20183)
{var bit__8579__auto__ = null;if(cljs.core.truth_((function (){var or__7929__auto__ = bit__8579__auto__;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return G__20183.crate$binding$bindable_coll$;
}
})()))
{return true;
} else
{if((!G__20183.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable_coll,G__20183);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable_coll,G__20183);
}
});
crate.binding.deref_QMARK_ = (function deref_QMARK_(atm){var G__20185 = atm;if(G__20185)
{var bit__8579__auto__ = (G__20185.cljs$lang$protocol_mask$partition0$ & 32768);if((bit__8579__auto__) || (G__20185.cljs$core$IDeref$))
{return true;
} else
{if((!G__20185.cljs$lang$protocol_mask$partition0$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,G__20185);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,G__20185);
}
});
crate.binding.value = (function value(b){return crate.binding._value.call(null,b);
});
crate.binding.index = (function index(sub_atom){return cljs.core.last.call(null,sub_atom.path);
});
crate.binding.on_change = (function on_change(b,func){return crate.binding._on_change.call(null,b,func);
});
/**
* @param {...*} var_args
*/
crate.binding.bound = (function() { 
var bound__delegate = function (atm,p__20186){var vec__20188 = p__20186;var func = cljs.core.nth.call(null,vec__20188,0,null);var func__$1 = (function (){var or__7929__auto__ = func;if(cljs.core.truth_(or__7929__auto__))
{return or__7929__auto__;
} else
{return cljs.core.identity;
}
})();return (new crate.binding.atom_binding(atm,func__$1));
};
var bound = function (atm,var_args){
var p__20186 = null;if (arguments.length > 1) {
  p__20186 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return bound__delegate.call(this,atm,p__20186);};
bound.cljs$lang$maxFixedArity = 1;
bound.cljs$lang$applyTo = (function (arglist__20189){
var atm = cljs.core.first(arglist__20189);
var p__20186 = cljs.core.rest(arglist__20189);
return bound__delegate(atm,p__20186);
});
bound.cljs$core$IFn$_invoke$arity$variadic = bound__delegate;
return bound;
})()
;

//# sourceMappingURL=binding.js.map