// Compiled by ClojureScript 0.0-2227
goog.provide('om_image_grid.cards');
goog.require('cljs.core');
goog.require('om_image_grid.core');
goog.require('om_image_grid.core');
goog.require('om.dom');
goog.require('om.dom');
goog.require('om.core');
goog.require('om.core');
goog.require('devcards.core');
goog.require('devcards.core');
cljs.core.enable_console_print_BANG_.call(null);
devcards.core.start_devcard_ui_BANG_.call(null);
devcards.core.start_figwheel_reloader_BANG_.call(null);
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"devcard-intro","devcard-intro",4151151286)], null),devcards.system.get_options.call(null,devcards.core.markdown_card.call(null,"# Om-image-grid\n\n    Github: [https://github.com/whodidthis/om-image-grid](https://github.com/whodidthis/om-image-grid).\n\n    An om component for creating justified image grids.\n    ### Usage\n    Takes images as a vector of maps\n    that each have `:file` for path, and `:width` and `:height` for dimensions.\n    ```\n    [{:file \"image1.jpg\" :width 123 :height 456}\n     {:file \"image2.jpg\" :width 246 :height 421}\n     ...]\n    ```\n    Found from clojars with `[whodidthis/om-image-grid \"0.3.0\"]`.\n    ```\n    (:require [om-image-grid.core :refer [image-grid]])\n    ```\n    Building the grid requires an image `:compo` to use for each image,\n    `:max-height` for images to display and additional `:spacing` each image\n    needs horizontally.\n    ")),(function (){return devcards.core.markdown_card.call(null,"# Om-image-grid\n\n    Github: [https://github.com/whodidthis/om-image-grid](https://github.com/whodidthis/om-image-grid).\n\n    An om component for creating justified image grids.\n    ### Usage\n    Takes images as a vector of maps\n    that each have `:file` for path, and `:width` and `:height` for dimensions.\n    ```\n    [{:file \"image1.jpg\" :width 123 :height 456}\n     {:file \"image2.jpg\" :width 246 :height 421}\n     ...]\n    ```\n    Found from clojars with `[whodidthis/om-image-grid \"0.3.0\"]`.\n    ```\n    (:require [om-image-grid.core :refer [image-grid]])\n    ```\n    Building the grid requires an image `:compo` to use for each image,\n    `:max-height` for images to display and additional `:spacing` each image\n    needs horizontally.\n    ");
}));
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"desc-images-200-px","desc-images-200-px",1024393774)], null),devcards.system.get_options.call(null,devcards.core.markdown_card.call(null,"### Example\n     Define an image component and build it with `om-image-grid.core/image-grid`\n     with max-height of the images to be shown and whatever additional horizontal\n     spacing each image needs. Each images local state will be updated with\n     `grid-width` and `grid-height`. Here each image has a padding of 2px so\n     additional horizontal spacing required by each image is 4px.\n     ```\n     (defn image-200-compo [{:keys [file width height]} owner]\n       (reify\n         om/IRenderState\n         (render-state [_ {:keys [grid-width grid-height]}]\n           (dom/div #js {:style #js {:display \"inline-block\" :padding 2}}\n             (dom/img #js {:src file :width (or grid-width width) :height (or grid-height height)})))))\n\n     (om/build image-grid images {:opts {:compo image-200-compo\n                                         :max-height 200\n                                         :spacing 4}})\n    ```")),(function (){return devcards.core.markdown_card.call(null,"### Example\n     Define an image component and build it with `om-image-grid.core/image-grid`\n     with max-height of the images to be shown and whatever additional horizontal\n     spacing each image needs. Each images local state will be updated with\n     `grid-width` and `grid-height`. Here each image has a padding of 2px so\n     additional horizontal spacing required by each image is 4px.\n     ```\n     (defn image-200-compo [{:keys [file width height]} owner]\n       (reify\n         om/IRenderState\n         (render-state [_ {:keys [grid-width grid-height]}]\n           (dom/div #js {:style #js {:display \"inline-block\" :padding 2}}\n             (dom/img #js {:src file :width (or grid-width width) :height (or grid-height height)})))))\n\n     (om/build image-grid images {:opts {:compo image-200-compo\n                                         :max-height 200\n                                         :spacing 4}})\n    ```");
}));
om_image_grid.cards.images_200 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/01.jpg",new cljs.core.Keyword(null,"width","width",1127031096),140,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/02.jpg",new cljs.core.Keyword(null,"width","width",1127031096),133,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/03.jpg",new cljs.core.Keyword(null,"width","width",1127031096),132,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/04.jpg",new cljs.core.Keyword(null,"width","width",1127031096),406,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/05.jpg",new cljs.core.Keyword(null,"width","width",1127031096),150,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/06.jpg",new cljs.core.Keyword(null,"width","width",1127031096),151,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/07.jpg",new cljs.core.Keyword(null,"width","width",1127031096),136,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/08.jpg",new cljs.core.Keyword(null,"width","width",1127031096),160,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/09.jpg",new cljs.core.Keyword(null,"width","width",1127031096),140,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/10.jpg",new cljs.core.Keyword(null,"width","width",1127031096),267,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/11.jpg",new cljs.core.Keyword(null,"width","width",1127031096),300,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/12.jpg",new cljs.core.Keyword(null,"width","width",1127031096),155,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/13.jpg",new cljs.core.Keyword(null,"width","width",1127031096),154,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/14.jpg",new cljs.core.Keyword(null,"width","width",1127031096),135,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/15.jpg",new cljs.core.Keyword(null,"width","width",1127031096),140,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/16.jpg",new cljs.core.Keyword(null,"width","width",1127031096),148,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/17.jpg",new cljs.core.Keyword(null,"width","width",1127031096),300,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/18.jpg",new cljs.core.Keyword(null,"width","width",1127031096),147,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/19.jpg",new cljs.core.Keyword(null,"width","width",1127031096),158,new cljs.core.Keyword(null,"height","height",4087841945),200], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"200/20.jpg",new cljs.core.Keyword(null,"width","width",1127031096),126,new cljs.core.Keyword(null,"height","height",4087841945),200], null)], null);
om_image_grid.cards.image_200_compo = (function image_200_compo(p__15628,owner){var map__15635 = p__15628;var map__15635__$1 = ((cljs.core.seq_QMARK_.call(null,map__15635))?cljs.core.apply.call(null,cljs.core.hash_map,map__15635):map__15635);var height = cljs.core.get.call(null,map__15635__$1,new cljs.core.Keyword(null,"height","height",4087841945));var width = cljs.core.get.call(null,map__15635__$1,new cljs.core.Keyword(null,"width","width",1127031096));var file = cljs.core.get.call(null,map__15635__$1,new cljs.core.Keyword(null,"file","file",1017047278));if(typeof om_image_grid.cards.t15636 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15636 = (function (file,width,height,map__15635,owner,p__15628,image_200_compo,meta15637){
this.file = file;
this.width = width;
this.height = height;
this.map__15635 = map__15635;
this.owner = owner;
this.p__15628 = p__15628;
this.image_200_compo = image_200_compo;
this.meta15637 = meta15637;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15636.cljs$lang$type = true;
om_image_grid.cards.t15636.cljs$lang$ctorStr = "om-image-grid.cards/t15636";
om_image_grid.cards.t15636.cljs$lang$ctorPrWriter = ((function (map__15635,map__15635__$1,height,width,file){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15636");
});})(map__15635,map__15635__$1,height,width,file))
;
om_image_grid.cards.t15636.prototype.om$core$IRenderState$ = true;
om_image_grid.cards.t15636.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15635,map__15635__$1,height,width,file){
return (function (_,p__15639){var self__ = this;
var map__15640 = p__15639;var map__15640__$1 = ((cljs.core.seq_QMARK_.call(null,map__15640))?cljs.core.apply.call(null,cljs.core.hash_map,map__15640):map__15640);var grid_height = cljs.core.get.call(null,map__15640__$1,new cljs.core.Keyword(null,"grid-height","grid-height",1423919360));var grid_width = cljs.core.get.call(null,map__15640__$1,new cljs.core.Keyword(null,"grid-width","grid-width",625456113));var ___$1 = this;return React.DOM.div({"style": {"padding": 2, "display": "inline-block"}},React.DOM.img({"height": (function (){var or__7931__auto__ = grid_height;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.height;
}
})(), "width": (function (){var or__7931__auto__ = grid_width;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.width;
}
})(), "src": self__.file}));
});})(map__15635,map__15635__$1,height,width,file))
;
om_image_grid.cards.t15636.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15635,map__15635__$1,height,width,file){
return (function (_15638){var self__ = this;
var _15638__$1 = this;return self__.meta15637;
});})(map__15635,map__15635__$1,height,width,file))
;
om_image_grid.cards.t15636.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15635,map__15635__$1,height,width,file){
return (function (_15638,meta15637__$1){var self__ = this;
var _15638__$1 = this;return (new om_image_grid.cards.t15636(self__.file,self__.width,self__.height,self__.map__15635,self__.owner,self__.p__15628,self__.image_200_compo,meta15637__$1));
});})(map__15635,map__15635__$1,height,width,file))
;
om_image_grid.cards.__GT_t15636 = ((function (map__15635,map__15635__$1,height,width,file){
return (function __GT_t15636(file__$1,width__$1,height__$1,map__15635__$2,owner__$1,p__15628__$1,image_200_compo__$1,meta15637){return (new om_image_grid.cards.t15636(file__$1,width__$1,height__$1,map__15635__$2,owner__$1,p__15628__$1,image_200_compo__$1,meta15637));
});})(map__15635,map__15635__$1,height,width,file))
;
}
return (new om_image_grid.cards.t15636(file,width,height,map__15635__$1,owner,p__15628,image_200_compo,null));
});
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"images-200-px","images-200-px",3635471466)], null),devcards.system.get_options.call(null,devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15641 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15641 = (function (owner,images,meta15642){
this.owner = owner;
this.images = images;
this.meta15642 = meta15642;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15641.cljs$lang$type = true;
om_image_grid.cards.t15641.cljs$lang$ctorStr = "om-image-grid.cards/t15641";
om_image_grid.cards.t15641.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15641");
});
om_image_grid.cards.t15641.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15641.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 2, "background-color": "#428bca"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_200_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),200,new cljs.core.Keyword(null,"spacing","spacing",3296712629),4], null)], null)));
});
om_image_grid.cards.t15641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15643){var self__ = this;
var _15643__$1 = this;return self__.meta15642;
});
om_image_grid.cards.t15641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15643,meta15642__$1){var self__ = this;
var _15643__$1 = this;return (new om_image_grid.cards.t15641(self__.owner,self__.images,meta15642__$1));
});
om_image_grid.cards.__GT_t15641 = (function __GT_t15641(owner__$1,images__$1,meta15642){return (new om_image_grid.cards.t15641(owner__$1,images__$1,meta15642));
});
}
return (new om_image_grid.cards.t15641(owner,images,null));
}),cljs.core.shuffle.call(null,om_image_grid.cards.images_200))),(function (){return devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15644 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15644 = (function (owner,images,meta15645){
this.owner = owner;
this.images = images;
this.meta15645 = meta15645;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15644.cljs$lang$type = true;
om_image_grid.cards.t15644.cljs$lang$ctorStr = "om-image-grid.cards/t15644";
om_image_grid.cards.t15644.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15644");
});
om_image_grid.cards.t15644.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15644.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 2, "background-color": "#428bca"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_200_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),200,new cljs.core.Keyword(null,"spacing","spacing",3296712629),4], null)], null)));
});
om_image_grid.cards.t15644.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15646){var self__ = this;
var _15646__$1 = this;return self__.meta15645;
});
om_image_grid.cards.t15644.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15646,meta15645__$1){var self__ = this;
var _15646__$1 = this;return (new om_image_grid.cards.t15644(self__.owner,self__.images,meta15645__$1));
});
om_image_grid.cards.__GT_t15644 = (function __GT_t15644(owner__$1,images__$1,meta15645){return (new om_image_grid.cards.t15644(owner__$1,images__$1,meta15645));
});
}
return (new om_image_grid.cards.t15644(owner,images,null));
}),cljs.core.shuffle.call(null,om_image_grid.cards.images_200));
}));
om_image_grid.cards.images_300 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/01.jpg",new cljs.core.Keyword(null,"width","width",1127031096),210,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/02.jpg",new cljs.core.Keyword(null,"width","width",1127031096),200,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/03.jpg",new cljs.core.Keyword(null,"width","width",1127031096),198,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/04.jpg",new cljs.core.Keyword(null,"width","width",1127031096),609,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/05.jpg",new cljs.core.Keyword(null,"width","width",1127031096),225,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/06.jpg",new cljs.core.Keyword(null,"width","width",1127031096),227,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/07.jpg",new cljs.core.Keyword(null,"width","width",1127031096),204,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/08.jpg",new cljs.core.Keyword(null,"width","width",1127031096),240,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/09.jpg",new cljs.core.Keyword(null,"width","width",1127031096),209,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/10.jpg",new cljs.core.Keyword(null,"width","width",1127031096),400,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/11.jpg",new cljs.core.Keyword(null,"width","width",1127031096),450,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/12.jpg",new cljs.core.Keyword(null,"width","width",1127031096),232,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/13.jpg",new cljs.core.Keyword(null,"width","width",1127031096),232,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/14.jpg",new cljs.core.Keyword(null,"width","width",1127031096),203,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/15.jpg",new cljs.core.Keyword(null,"width","width",1127031096),211,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/16.jpg",new cljs.core.Keyword(null,"width","width",1127031096),222,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/17.jpg",new cljs.core.Keyword(null,"width","width",1127031096),450,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/18.jpg",new cljs.core.Keyword(null,"width","width",1127031096),221,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/19.jpg",new cljs.core.Keyword(null,"width","width",1127031096),238,new cljs.core.Keyword(null,"height","height",4087841945),300], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"300/20.jpg",new cljs.core.Keyword(null,"width","width",1127031096),189,new cljs.core.Keyword(null,"height","height",4087841945),300], null)], null);
om_image_grid.cards.image_300_compo = (function image_300_compo(p__15647,owner){var map__15654 = p__15647;var map__15654__$1 = ((cljs.core.seq_QMARK_.call(null,map__15654))?cljs.core.apply.call(null,cljs.core.hash_map,map__15654):map__15654);var height = cljs.core.get.call(null,map__15654__$1,new cljs.core.Keyword(null,"height","height",4087841945));var width = cljs.core.get.call(null,map__15654__$1,new cljs.core.Keyword(null,"width","width",1127031096));var file = cljs.core.get.call(null,map__15654__$1,new cljs.core.Keyword(null,"file","file",1017047278));if(typeof om_image_grid.cards.t15655 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15655 = (function (file,width,height,map__15654,owner,p__15647,image_300_compo,meta15656){
this.file = file;
this.width = width;
this.height = height;
this.map__15654 = map__15654;
this.owner = owner;
this.p__15647 = p__15647;
this.image_300_compo = image_300_compo;
this.meta15656 = meta15656;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15655.cljs$lang$type = true;
om_image_grid.cards.t15655.cljs$lang$ctorStr = "om-image-grid.cards/t15655";
om_image_grid.cards.t15655.cljs$lang$ctorPrWriter = ((function (map__15654,map__15654__$1,height,width,file){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15655");
});})(map__15654,map__15654__$1,height,width,file))
;
om_image_grid.cards.t15655.prototype.om$core$IRenderState$ = true;
om_image_grid.cards.t15655.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15654,map__15654__$1,height,width,file){
return (function (_,p__15658){var self__ = this;
var map__15659 = p__15658;var map__15659__$1 = ((cljs.core.seq_QMARK_.call(null,map__15659))?cljs.core.apply.call(null,cljs.core.hash_map,map__15659):map__15659);var grid_height = cljs.core.get.call(null,map__15659__$1,new cljs.core.Keyword(null,"grid-height","grid-height",1423919360));var grid_width = cljs.core.get.call(null,map__15659__$1,new cljs.core.Keyword(null,"grid-width","grid-width",625456113));var ___$1 = this;return React.DOM.div({"style": {"padding": 5, "display": "inline-block"}},React.DOM.img({"height": (function (){var or__7931__auto__ = grid_height;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.height;
}
})(), "width": (function (){var or__7931__auto__ = grid_width;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.width;
}
})(), "src": self__.file}));
});})(map__15654,map__15654__$1,height,width,file))
;
om_image_grid.cards.t15655.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15654,map__15654__$1,height,width,file){
return (function (_15657){var self__ = this;
var _15657__$1 = this;return self__.meta15656;
});})(map__15654,map__15654__$1,height,width,file))
;
om_image_grid.cards.t15655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15654,map__15654__$1,height,width,file){
return (function (_15657,meta15656__$1){var self__ = this;
var _15657__$1 = this;return (new om_image_grid.cards.t15655(self__.file,self__.width,self__.height,self__.map__15654,self__.owner,self__.p__15647,self__.image_300_compo,meta15656__$1));
});})(map__15654,map__15654__$1,height,width,file))
;
om_image_grid.cards.__GT_t15655 = ((function (map__15654,map__15654__$1,height,width,file){
return (function __GT_t15655(file__$1,width__$1,height__$1,map__15654__$2,owner__$1,p__15647__$1,image_300_compo__$1,meta15656){return (new om_image_grid.cards.t15655(file__$1,width__$1,height__$1,map__15654__$2,owner__$1,p__15647__$1,image_300_compo__$1,meta15656));
});})(map__15654,map__15654__$1,height,width,file))
;
}
return (new om_image_grid.cards.t15655(file,width,height,map__15654__$1,owner,p__15647,image_300_compo,null));
});
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"images-300-px","images-300-px",3664100617)], null),devcards.system.get_options.call(null,devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15660 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15660 = (function (owner,images,meta15661){
this.owner = owner;
this.images = images;
this.meta15661 = meta15661;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15660.cljs$lang$type = true;
om_image_grid.cards.t15660.cljs$lang$ctorStr = "om-image-grid.cards/t15660";
om_image_grid.cards.t15660.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15660");
});
om_image_grid.cards.t15660.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15660.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 5, "background-color": "#8a6d3b"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_300_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),300,new cljs.core.Keyword(null,"spacing","spacing",3296712629),10], null)], null)));
});
om_image_grid.cards.t15660.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15662){var self__ = this;
var _15662__$1 = this;return self__.meta15661;
});
om_image_grid.cards.t15660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15662,meta15661__$1){var self__ = this;
var _15662__$1 = this;return (new om_image_grid.cards.t15660(self__.owner,self__.images,meta15661__$1));
});
om_image_grid.cards.__GT_t15660 = (function __GT_t15660(owner__$1,images__$1,meta15661){return (new om_image_grid.cards.t15660(owner__$1,images__$1,meta15661));
});
}
return (new om_image_grid.cards.t15660(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_300)))),(function (){return devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15663 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15663 = (function (owner,images,meta15664){
this.owner = owner;
this.images = images;
this.meta15664 = meta15664;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15663.cljs$lang$type = true;
om_image_grid.cards.t15663.cljs$lang$ctorStr = "om-image-grid.cards/t15663";
om_image_grid.cards.t15663.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15663");
});
om_image_grid.cards.t15663.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15663.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 5, "background-color": "#8a6d3b"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_300_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),300,new cljs.core.Keyword(null,"spacing","spacing",3296712629),10], null)], null)));
});
om_image_grid.cards.t15663.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15665){var self__ = this;
var _15665__$1 = this;return self__.meta15664;
});
om_image_grid.cards.t15663.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15665,meta15664__$1){var self__ = this;
var _15665__$1 = this;return (new om_image_grid.cards.t15663(self__.owner,self__.images,meta15664__$1));
});
om_image_grid.cards.__GT_t15663 = (function __GT_t15663(owner__$1,images__$1,meta15664){return (new om_image_grid.cards.t15663(owner__$1,images__$1,meta15664));
});
}
return (new om_image_grid.cards.t15663(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_300)));
}));
om_image_grid.cards.images_400 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/01.jpg",new cljs.core.Keyword(null,"width","width",1127031096),280,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/02.jpg",new cljs.core.Keyword(null,"width","width",1127031096),266,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/03.jpg",new cljs.core.Keyword(null,"width","width",1127031096),265,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/04.jpg",new cljs.core.Keyword(null,"width","width",1127031096),812,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/05.jpg",new cljs.core.Keyword(null,"width","width",1127031096),300,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/06.jpg",new cljs.core.Keyword(null,"width","width",1127031096),303,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/07.jpg",new cljs.core.Keyword(null,"width","width",1127031096),272,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/08.jpg",new cljs.core.Keyword(null,"width","width",1127031096),320,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/09.jpg",new cljs.core.Keyword(null,"width","width",1127031096),279,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/10.jpg",new cljs.core.Keyword(null,"width","width",1127031096),533,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/11.jpg",new cljs.core.Keyword(null,"width","width",1127031096),600,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/12.jpg",new cljs.core.Keyword(null,"width","width",1127031096),309,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/13.jpg",new cljs.core.Keyword(null,"width","width",1127031096),309,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/14.jpg",new cljs.core.Keyword(null,"width","width",1127031096),270,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/15.jpg",new cljs.core.Keyword(null,"width","width",1127031096),281,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/16.jpg",new cljs.core.Keyword(null,"width","width",1127031096),296,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/17.jpg",new cljs.core.Keyword(null,"width","width",1127031096),601,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/18.jpg",new cljs.core.Keyword(null,"width","width",1127031096),295,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/19.jpg",new cljs.core.Keyword(null,"width","width",1127031096),317,new cljs.core.Keyword(null,"height","height",4087841945),400], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"file","file",1017047278),"400/20.jpg",new cljs.core.Keyword(null,"width","width",1127031096),252,new cljs.core.Keyword(null,"height","height",4087841945),400], null)], null);
om_image_grid.cards.image_400_compo = (function image_400_compo(p__15666,owner){var map__15673 = p__15666;var map__15673__$1 = ((cljs.core.seq_QMARK_.call(null,map__15673))?cljs.core.apply.call(null,cljs.core.hash_map,map__15673):map__15673);var height = cljs.core.get.call(null,map__15673__$1,new cljs.core.Keyword(null,"height","height",4087841945));var width = cljs.core.get.call(null,map__15673__$1,new cljs.core.Keyword(null,"width","width",1127031096));var file = cljs.core.get.call(null,map__15673__$1,new cljs.core.Keyword(null,"file","file",1017047278));if(typeof om_image_grid.cards.t15674 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15674 = (function (file,width,height,map__15673,owner,p__15666,image_400_compo,meta15675){
this.file = file;
this.width = width;
this.height = height;
this.map__15673 = map__15673;
this.owner = owner;
this.p__15666 = p__15666;
this.image_400_compo = image_400_compo;
this.meta15675 = meta15675;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15674.cljs$lang$type = true;
om_image_grid.cards.t15674.cljs$lang$ctorStr = "om-image-grid.cards/t15674";
om_image_grid.cards.t15674.cljs$lang$ctorPrWriter = ((function (map__15673,map__15673__$1,height,width,file){
return (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15674");
});})(map__15673,map__15673__$1,height,width,file))
;
om_image_grid.cards.t15674.prototype.om$core$IRenderState$ = true;
om_image_grid.cards.t15674.prototype.om$core$IRenderState$render_state$arity$2 = ((function (map__15673,map__15673__$1,height,width,file){
return (function (_,p__15677){var self__ = this;
var map__15678 = p__15677;var map__15678__$1 = ((cljs.core.seq_QMARK_.call(null,map__15678))?cljs.core.apply.call(null,cljs.core.hash_map,map__15678):map__15678);var grid_height = cljs.core.get.call(null,map__15678__$1,new cljs.core.Keyword(null,"grid-height","grid-height",1423919360));var grid_width = cljs.core.get.call(null,map__15678__$1,new cljs.core.Keyword(null,"grid-width","grid-width",625456113));var ___$1 = this;return React.DOM.div({"style": {"display": "inline-block"}},React.DOM.img({"height": (function (){var or__7931__auto__ = grid_height;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.height;
}
})(), "width": (function (){var or__7931__auto__ = grid_width;if(cljs.core.truth_(or__7931__auto__))
{return or__7931__auto__;
} else
{return self__.width;
}
})(), "src": self__.file}));
});})(map__15673,map__15673__$1,height,width,file))
;
om_image_grid.cards.t15674.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (map__15673,map__15673__$1,height,width,file){
return (function (_15676){var self__ = this;
var _15676__$1 = this;return self__.meta15675;
});})(map__15673,map__15673__$1,height,width,file))
;
om_image_grid.cards.t15674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (map__15673,map__15673__$1,height,width,file){
return (function (_15676,meta15675__$1){var self__ = this;
var _15676__$1 = this;return (new om_image_grid.cards.t15674(self__.file,self__.width,self__.height,self__.map__15673,self__.owner,self__.p__15666,self__.image_400_compo,meta15675__$1));
});})(map__15673,map__15673__$1,height,width,file))
;
om_image_grid.cards.__GT_t15674 = ((function (map__15673,map__15673__$1,height,width,file){
return (function __GT_t15674(file__$1,width__$1,height__$1,map__15673__$2,owner__$1,p__15666__$1,image_400_compo__$1,meta15675){return (new om_image_grid.cards.t15674(file__$1,width__$1,height__$1,map__15673__$2,owner__$1,p__15666__$1,image_400_compo__$1,meta15675));
});})(map__15673,map__15673__$1,height,width,file))
;
}
return (new om_image_grid.cards.t15674(file,width,height,map__15673__$1,owner,p__15666,image_400_compo,null));
});
devcards.core.register_card.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"om_image_grid.cards","om_image_grid.cards",2430347218),new cljs.core.Keyword(null,"images-400-px","images-400-px",3692729768)], null),devcards.system.get_options.call(null,devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15679 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15679 = (function (owner,images,meta15680){
this.owner = owner;
this.images = images;
this.meta15680 = meta15680;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15679.cljs$lang$type = true;
om_image_grid.cards.t15679.cljs$lang$ctorStr = "om-image-grid.cards/t15679";
om_image_grid.cards.t15679.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15679");
});
om_image_grid.cards.t15679.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15679.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 10, "background-color": "#999"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_400_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),400,new cljs.core.Keyword(null,"spacing","spacing",3296712629),0], null)], null)));
});
om_image_grid.cards.t15679.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15681){var self__ = this;
var _15681__$1 = this;return self__.meta15680;
});
om_image_grid.cards.t15679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15681,meta15680__$1){var self__ = this;
var _15681__$1 = this;return (new om_image_grid.cards.t15679(self__.owner,self__.images,meta15680__$1));
});
om_image_grid.cards.__GT_t15679 = (function __GT_t15679(owner__$1,images__$1,meta15680){return (new om_image_grid.cards.t15679(owner__$1,images__$1,meta15680));
});
}
return (new om_image_grid.cards.t15679(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_400)))),(function (){return devcards.core.om_root_card.call(null,(function (images,owner){if(typeof om_image_grid.cards.t15682 !== 'undefined')
{} else
{
/**
* @constructor
*/
om_image_grid.cards.t15682 = (function (owner,images,meta15683){
this.owner = owner;
this.images = images;
this.meta15683 = meta15683;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
om_image_grid.cards.t15682.cljs$lang$type = true;
om_image_grid.cards.t15682.cljs$lang$ctorStr = "om-image-grid.cards/t15682";
om_image_grid.cards.t15682.cljs$lang$ctorPrWriter = (function (this__8498__auto__,writer__8499__auto__,opt__8500__auto__){return cljs.core._write.call(null,writer__8499__auto__,"om-image-grid.cards/t15682");
});
om_image_grid.cards.t15682.prototype.om$core$IRender$ = true;
om_image_grid.cards.t15682.prototype.om$core$IRender$render$arity$1 = (function (this__9509__auto__){var self__ = this;
var this__9509__auto____$1 = this;return React.DOM.div({"style": {"padding": 10, "background-color": "#999"}},om.core.build.call(null,om_image_grid.core.image_grid,self__.images,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"opts","opts",1017322386),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compo","compo",1108747954),om_image_grid.cards.image_400_compo,new cljs.core.Keyword(null,"max-height","max-height",585117986),400,new cljs.core.Keyword(null,"spacing","spacing",3296712629),0], null)], null)));
});
om_image_grid.cards.t15682.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15684){var self__ = this;
var _15684__$1 = this;return self__.meta15683;
});
om_image_grid.cards.t15682.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15684,meta15683__$1){var self__ = this;
var _15684__$1 = this;return (new om_image_grid.cards.t15682(self__.owner,self__.images,meta15683__$1));
});
om_image_grid.cards.__GT_t15682 = (function __GT_t15682(owner__$1,images__$1,meta15683){return (new om_image_grid.cards.t15682(owner__$1,images__$1,meta15683));
});
}
return (new om_image_grid.cards.t15682(owner,images,null));
}),cljs.core.take.call(null,10,cljs.core.shuffle.call(null,om_image_grid.cards.images_400)));
}));

//# sourceMappingURL=cards.js.map