(defproject whodidthis/om-image-grid "0.3.0"
  :description "That justified image grid thingie"
  :url "http://github.com/whodidthis/om-image-grid"
  :license {:name "Eclipse Public License - v 1.0"
            :url "http://www.eclipse.org/legal/epl-v10.html"
            :distribution :repo}

  :source-paths  ["src"]

  :dependencies [[org.clojure/clojure "1.6.0"]
                 [org.clojure/clojurescript "0.0-2227"]
                 [om "0.6.4"]]

  :profiles { :dev {:dependencies [[devcards "0.1.0-SNAPSHOT"]]
                    :plugins [[lein-cljsbuild "1.0.3"]
                              [lein-figwheel "0.1.3-SNAPSHOT"]] }}

  :cljsbuild {
    :builds [{:id "devcards"
              :source-paths ["devcards_src" "src"]
              :compiler {
                :output-to "resources/public/js/compiled/om_image_grid.cards.js"
                :output-dir "resources/public/js/compiled/out"
                :optimizations :none
                :source-map true}}
             ;; gh-pages
             {:id "pages"
              :source-paths ["src" "examples/hello/src"]
              :compiler {
                :optimizations :advanced
                :output-to "pages.js"
                :pretty-print false
                :preamble ["react/react.min.js"]
                :externs ["react/externs/react.js"]}}]})
