## Om-image-grid

Justified image grids for [Om](https://github.com/swannodette/om). 

#### Run devcards example


Clone repository, run `lein figwheel` and open `http://localhost:3449/index.html` in your browser.

### Usage
```clojure
[whodidthis/om-justified "0.3.0"]
```
Om-justified expects images delivered as 
```clojure
[{:src "a.jpg" :width 100 :height 150}
 {:src "b.jpg" :width 125 :height 150} ...]
```
where size of the images is already calculated to whatever max-height of the images you plan on using. 

```clojure
;; require
(:require [om-image-grid.core :refer [image-grid])
;; an image component to use
(defn image-component [{:keys [file width height]} owner]
  (reify
    om/IRenderState
    (render-state [_ {:keys [grid-width grid-height]}]
      (dom/img #js {:src file 
                    ;; Om-image-grid sets grid-width and grid-height on images local state after calculation.
                    ;; Use them only when available.
                    :width (or grid-width width) :height (or grid-height height)
                    :style #js {:margin 2}}))))
                  
;; use in some component
(fn [{:keys [images]} owner]
  (reify
    om/IRender
    (render [_]
      (dom/div nil
        ;; image-grid needs - images in a vector cursor
        ;;                  - an image-component to render for each image
        ;;                  - additional total spacing each image requires horizontally from paddings, margins and stuff
        (om/build image-grid images {:opts {:compo image-component
                                            :spacing 4}} ; image components styling requires 4px of spacing)))))
  
```
