(ns webnf.cljs.enlive.data.dom
  (:require
   [goog.dom :as dom]
   [clojure.string :as str]))

(defn to-str [i]
  (cond
    (keyword? i) (name i)
    (symbol? i) (name i)
    :default (str i)))

(defn child-nodes [node]
  (into [] (array-seq (dom/getChildren node))))

(defn tag=
  "Selector predicate, :foo is as short-hand for (tag= :foo)."
  [tag-name]
  (let [tag-name (.toUpperCase (to-str tag-name))]
    #(= (.-tagName %) tag-name)))

(defn attr= [attr val]
  (let [as (to-str attr)]
    #(= (.getAttribute % as) val)))

(defn id=
  "Selector predicate, :#foo is as short-hand for (id= \"foo\")."
  [id]
  (attr= :id id))

(defn attr-values
  "Returns the whitespace-separated values of the specified attr as a set or nil."
  [node attr]
  (when-let [v (.getAttribute node (to-str attr))]
    (set (str/split v #"\s+"))))

(defn as-nodes [node-or-nodes]
  (cond
    (seqable? node-or-nodes) node-or-nodes
    (= js/DocumentFragment (type node-or-nodes)) (child-nodes node-or-nodes)
    :else (cons node-or-nodes nil)))
