# json-schema tools

Currently contains only a very minimal JSON schema validator using cheshire to parse JSON.
Supportes linked schemas with $ref and allows user to specify
how linked URIs are resolved.

[![Clojars Project](http://clojars.org/webjure/json-schema/latest-version.svg)](http://clojars.org/webjure/json-schema)

## Usage

The function version (runtime loading of schema):

```clojure
(ns my.app
  (:require [webjure.json-schema.validator :refer [validate]]
            [cheshire.core :as cheshire]))

;;; then in some function
(validate (cheshire/parse-string json-schema)
          (cheshire/parse-string json-data))

```

Macro version loads and parses the schema and generates the validation function at compile time.
The returned errors are exactly the same as in the runtime version.

```clojure
(ns my.app
  (:require [webjure.json-schema.validator.macro :refer [make-validator]]
            [cheshire.core :as cheshire]))

(def my-schema-validator
     (make-validator (cheshire/parse-string json-schema) {}))

;; Then in some function
(my-schema-validator (cheshire/parse-string json-data))
```