(ns leiningen.new.webdb
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "webdb"))

(defn webdb
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["src/webapp/framework/client/core.cljs" (render "core.cljs" data)]
["src/webapp/server/fns.clj" (render "fns.clj" data)]
["project.clj" (render "project.clj" data)]
["src/webapp/client/main.cljs" (render "main.cljs" data)]
["test/webapp/core_test.clj" (render "core_test.clj" data)]
["src/webapp/framework/server/core.clj" (render "core.clj" data)]
["src/webapp/framework/client/help.cljs" (render "help.cljs" data)]
["resources/public/jquery-1.10.1.js" (render "jquery_1.10.1.js")]
["resources/public/bootstrap/css/bootstrap.min.css" (render "bootstrap.min.css")]
["src/webapp/server/.DS_Store" (render ".DS_Store")]
["resources/public/css/ui-lightness/images/ui-icons_222222_256x240.png" (render "ui_icons_222222_256x240.png")]
["resources/public/css/ui-lightness/images/ui-bg_diagonals-thick_20_666666_40x40.png" (render "ui_bg_diagonals_thick_20_666666_40x40.png")]
["resources/public/css/ui-lightness/images/ui-icons_ffffff_256x240.png" (render "ui_icons_ffffff_256x240.png")]
["resources/public/bootstrap/.DS_Store" (render ".DS_Store")]
["resources/public/main.js" (render "main.js")]
["resources/public/bootstrap/img/glyphicons-halflings-white.png" (render "glyphicons_halflings_white.png")]
["resources/public/css/ui-lightness/images/ui-bg_glass_65_ffffff_1x400.png" (render "ui_bg_glass_65_ffffff_1x400.png")]
["resources/public/main.html" (render "main.html")]
["resources/public/css/ui-lightness/images/ui-bg_glass_100_fdf5ce_1x400.png" (render "ui_bg_glass_100_fdf5ce_1x400.png")]
["resources/public/css/ui-lightness/images/ui-bg_highlight-soft_75_ffe45c_1x100.png" (render "ui_bg_highlight_soft_75_ffe45c_1x100.png")]
["resources/public/google_maps_api_v3_3.js" (render "google_maps_api_v3_3.js")]
["resources/public/.DS_Store" (render ".DS_Store")]
["resources/public/css/ui-lightness/images/ui-bg_glass_100_f6f6f6_1x400.png" (render "ui_bg_glass_100_f6f6f6_1x400.png")]
["resources/public/bootstrap/img/glyphicons-halflings.png" (render "glyphicons_halflings.png")]
["src/webapp/.DS_Store" (render ".DS_Store")]
["resources/links.txt" (render "links.txt")]
["src/.DS_Store" (render ".DS_Store")]
["resources/public/css/ui-lightness/images/ui-bg_gloss-wave_35_f6a828_500x100.png" (render "ui_bg_gloss_wave_35_f6a828_500x100.png")]
["resources/public/css/ui-lightness/jquery-ui-1.10.3.custom.css" (render "jquery_ui_1.10.3.custom.css")]
["resources/public/css/ui-lightness/images/ui-bg_highlight-soft_100_eeeeee_1x100.png" (render "ui_bg_highlight_soft_100_eeeeee_1x100.png")]
["resources/.DS_Store" (render ".DS_Store")]
["resources/public/jquery-1.9.js" (render "jquery_1.9.js")]
["resources/public/bootstrap/js/bootstrap.min.js" (render "bootstrap.min.js")]
["resources/public/css/ui-lightness/images/ui-bg_flat_10_000000_40x100.png" (render "ui_bg_flat_10_000000_40x100.png")]
["resources/public/css/ui-lightness/jquery-ui-1.10.3.custom.min.css" (render "jquery_ui_1.10.3.custom.min.css")]
["resources/public/bootstrap/js/bootstrap.js" (render "bootstrap.js")]
["src/webapp/framework/server/.DS_Store" (render ".DS_Store")]
["resources/public/css/ui-lightness/images/ui-bg_diagonals-thick_18_b81900_40x40.png" (render "ui_bg_diagonals_thick_18_b81900_40x40.png")]
["resources/public/css/ui-lightness/images/ui-icons_ef8c08_256x240.png" (render "ui_icons_ef8c08_256x240.png")]
["resources/public/css/ui-lightness/images/animated-overlay.gif" (render "animated_overlay.gif")]
["resources/public/jquery-ui-1.10.3.custom.js" (render "jquery_ui_1.10.3.custom.js")]
["resources/public/css/.DS_Store" (render ".DS_Store")]
["resources/public/css/ui-lightness/images/ui-icons_ffd27a_256x240.png" (render "ui_icons_ffd27a_256x240.png")]
["resources/public/css/ui-lightness/images/ui-icons_228ef1_256x240.png" (render "ui_icons_228ef1_256x240.png")]
["resources/public/bootstrap/css/bootstrap.css" (render "bootstrap.css")]
)))