(ns webapp.client.main
    (:require
        [cljs.reader :as reader]
    )
    (:use
        [webapp.framework.client.core  :only [help remote onclick add-to]]
        [jayq.core                     :only [$ css inner toggle append]]
        [webapp.framework.client.help  :only [help]]
    )
)


(add-to :body [:div#main])

(add-to :#main [:h1 {:style "padding: 20px;"}
                        "Clojure on Coils"])

(add-to :#main [:div {:style "padding: 20px;"}
                        "Welcome to Clojure on Coils."])



(add-to :#main [:div {:style "padding: 20px;"}
                          "Clojure on Coils is a Clojure based webapp framework
                           for single page database backed webapps"])

(add-to :#main [:div {:style "padding: 20px;"}
      "Uses: Clojure, Clojurescript, JQuery, Bootstrap.js"])


(add-to
     :#main
     [:button#help-button
          {:style "margin: 20px;"
           :class "btn btn-large"}
           "Help"])



(add-to
     :#main
     [:button#remote-button
          {:style "margin: 20px;"
           :class "btn btn-large"}
           "Remote call"])

(add-to
     :#main
     [:button#remote-db-button
          {:style "margin: 20px;"
           :class "btn btn-large"}
           "Remote DB call"])

(add-to
     :#main
     [:button#disappear-button
          {:style "margin: 20px;"
           :class "btn btn-large"}
           "Dissappear"])


(onclick
        :element    "disappear-button"
        :fn-to-call
             (fn[] (-> ($ :#main) (toggle "explode"))))

(onclick
        :element    "help-button"
        :fn-to-call
             help)



(onclick
        :element    "remote-button"
        :fn-to-call
            #(remote "test-call" {:a {:c 2 :d 3}}
                 (fn [reply]
                     (js/alert reply))))


(onclick
        :element    "remote-db-button"
        :fn-to-call
            #(remote "get-db-data" {:a 1}
               (fn [reply]
                   (js/alert (count reply)))))

