(defproject {{ns-name}} "0.2.0-SNAPSHOT"
  :dependencies [
                   [org.clojure/clojure "1.5.1"]
                   [org.clojure/google-closure-library-third-party "0.0-2029"]
                   [domina "1.0.1"]
                   [crate "0.2.4"]
                   [prismatic/dommy "0.1.1"]
                   [korma "0.3.0-RC5"]
                   [org.postgresql/postgresql "9.2-1002-jdbc4"]
                   [compojure "1.1.5"]
                   [shoreleave "0.3.0"]
                   [shoreleave/shoreleave-remote-ring "0.3.0"]
                   [ring-middleware-format "0.3.0"]
                   [ring/ring-json "0.2.0"]
                   [jayq "2.3.0"]
                ]

  :plugins  [
               [lein-cljsbuild "0.3.0"]
               [lein-httpd "1.0.0"]
               [lein-ring "0.8.5"]
            ]

  :source-paths ["src"]

  :ring {:handler webapp.framework.server.core/app}

  :cljsbuild
  {
    :builds
     [
      {
         :source-paths ["src"]
         :compiler     {
                         :output-to      "resources/public/main.js"
                         :optimizations  :simple
                         :externs        ["resources/public/jquery.js" "resources/public/google_maps_api_v3_3.js"]
                         :pretty-print   false
                       }
      }
     ]

  }
)
