(ns {{name}}.core.db-util-test
    (:require
      [clojure.test :refer :all])
    (:use
      [user]
      [{{name}}.core.db-util]))

(deftest get-sql-test
  (testing "test get sql "
    (let [db-file (load-db-file "db.sql")
          sql (get-sql db-file "users")]
      (println sql))))


(deftest get-sql-with-params-test
  (testing "test get sql "
    (let [db-file (load-db-file "db.sql")
          sql (get-sql-with-params db-file "user-by-id" {:id 3})]
      (println sql))))


(defn jdbc-execute [app-context]
  (fn [q-str]
    (clojure.tools.logging/info q-str)
    {:id 1234
     :name "Mamun"
     :other "hello"}))


;(def test-sql-data (rdump.core.db-util/load-db-file "db.sql"))

(def test-sql-data {:user {:name "user",
                           :doc "User table ",
                           :rename-keys {:id :user-id },
                           :default-params {:id 2},
                           :sql "SELECT * FROM USER where ID=:id;select * from dual; "},
                    :customer {:name "customer",
                               :doc "Customer table  ",
                               :sql "SELECT * FROM CUSTOMER where ID=:CUST  "},
                    :table-by-id {:name "table-by-id",
                                  :doc " Any table with id  ",
                                  :sql "SELECT * FROM :tname where id=:id; "},
                    :table {:name "table",
                            :doc "hello query that reutrn data from server ",
                            :sql "SELECT * FROM :tname "}})




(deftest test-load-default-params
  (testing "test load default params "
    (let [expeted-result {:id 2}
          actual-result (load-default-params test-sql-data :user)]
      (is actual-result expeted-result))))

(->
 test-sql-data
 (rdump.core.db-util/sql :user ))

(->
 test-sql-data
 (rdump.core.db-util/sql-with-params :user {}))

(->
 test-sql-data
 (rdump.core.db-util/sql-with-params :user {:id 4}))


(->
 test-sql-data
 (rdump.core.db-util/sql :customer ))

(->
 test-sql-data
 (rdump.core.db-util/sql-with-params :customer {}))

(->
 test-sql-data
 (rdump.core.db-util/sql-with-params :customer {:CUST 23}))



 (-> test-sql-data
     (sql-with-params :user {:id 3})
     (run-query (jdbc-execute nil))
     (rename-keys test-sql-data :user ))



 (-> test-sql-data
     (rdump.core.db-util/sql-with-params :customer {:CUST 4})
     (rdump.core.db-util/run-query (jdbc-execute nil))
     (rename-keys test-sql-data :customer ))






