(ns {{name}}.service.user-service
  (:require
    [clojure.java.jdbc :as jdbc]
    [clojure.tools.logging :as log]))


(def ID (atom 100))
(defn uuid [] (str (java.util.UUID/randomUUID)))


(defn create! [context params]
  (let [data (assoc params :id (swap! ID inc) )]
    (log/info data)
    (jdbc/insert! (get-in context [:sqldb :ds])
                  :users data)) )


(defn update! [context id params]
  (jdbc/update! (get-in context [:sqldb :ds])
                :users
                params
                ["id=?" id]))









