(ns {{name}}.service.query-service
    (:require
      [clojure.tools.logging :as log]
      [clojure.java.jdbc :as jdbc]
      [tie.core :as tie]))


(defn jdbc-execute [ds]
  (reify
    tie/IQueryExecutor
    (execute [_ query]
        (jdbc/query ds [query]))))


(defn response [{:keys [data error]}]
  (if data
    [data nil]
    [nil error]))

(defn error-response [& [msg]]
  (response {:error (or msg "Input format is wrong, should be name=query&id=1")}))


(defn name? [n]
   (if n
     (if (keyword? n) n (keyword n))))


(defn data
  "Default handler for query execution. Rename {name, parameter} using *rename-map* then execute query.

   @param {map} app-context \"App context must contain [:sqldb :conn] for database connection.
                             and [:sqldb :db] for query file.\"
   @param {string | keyword} name \"Name of the query.\"
   @param {map} params \"Parameter of the query.\"
   @return {vec} \" First -> data, second -> error. On of them will be null [data nil] or [nil data]\""
  [app-context q-name params]
  (try
    (if-let [name (name? q-name)]
      (let [tms (get-in app-context [:sqldb :tie])
            executor (jdbc-execute (get-in app-context [:sqldb :ds]))]
        (->>
         (tie/slurp-data tms executor name params)
         (response)))
      (error-response))
    (catch Exception e
      (do
        (log/info (format "sql statement failed name: %s params: %s" name (pr-str params)))
        (log/error e)
        (error-response "Query operation fail, please check log ")))))


