(ns {{name}}.modules.user.user-handler
  (:require
    [compojure.core :refer :all]
    [ring.util.response :as resp]
    [clojure.java.jdbc :as jdbc]
    [clojure.tools.logging :as log]))


(def ID (atom 100))
(defn uuid [] (str (java.util.UUID/randomUUID)))


(defn create! [context params]
  (let [data (assoc params :id (swap! ID inc) )]
    (log/info data)
    (jdbc/insert! @(get-in context [:sqldb :conn])
                  :users data)) )


(defn update! [context id params]
  (jdbc/update! @(get-in context [:sqldb :conn])
                :users
                params
                ["id=?" id]))



(defn user-routes
  "Routes for user_handler

  @param {map} app-context \"App context map generated by system init\"
  @return {compojure.core.routes}"
  [app-context]
  (routes
    (POST "/" [:as {:keys [params]}]
          (resp/response (create! app-context params)))
    (context "/:id" [id]
             (routes
               (POST "/" [:as {:keys [params]}]
                     (resp/response (update! app-context id params)))))))






