(ns {{name}}.modules.reporting.report-handler
  (:use
    [incanter core stats charts])
  (:require
    [compojure.core :refer :all]
    [ring.util.response :as resp])
  (:import
    (java.io ByteArrayOutputStream
                    ByteArrayInputStream)))


(defn gen-samp-hist-png
  "Generate histogram chart "
  [request size-str mean-str sd-str]
  (let [size (if (nil? size-str)
               1000
               (Integer/parseInt size-str))
        m (if (nil? mean-str)
            0
            (Double/parseDouble mean-str))
        s (if (nil? sd-str)
            1
            (Double/parseDouble sd-str))
        samp (sample-normal size
                            :mean m
                            :sd s)
        chart (histogram
               samp
               :title "Normal Sample"
               :x-label (str "sample-size = " size
                             ", mean = " m
                             ", sd = " s))
        out-stream (ByteArrayOutputStream.)
        in-stream (do
                    (save chart out-stream)
                    (ByteArrayInputStream.
                     (.toByteArray out-stream)))]
    in-stream))


(defn report-routes
  "Routes for report_handler

  @param {map} app-context \"App context map generated by system init\"
  @return {compojure.core.routes}"
  [app-context]
  (routes
    (GET "/img" [size mean sd :as r]
         (->
           (gen-samp-hist-png r size mean sd)
           (resp/response)
           (resp/content-type "image/png")))))
