(ns {{name}}.modules.query-handler
    (:use
     [compojure.core])
    (:require
      [ring.util.response :as resp]
      [clojure.tools.logging :as log]
      [clojure.java.jdbc :as jdbc]
      [dbquery.core :as dq]))


(defn jdbc-execute [app-context]
  (reify
    dq/IQueryExecutor
    (execute [_ query]
      (let [conn (get-in app-context [:sqldb :conn])]
        (jdbc/query conn [query])))))


#_(defn get-name [q-n params]
  (let [v (if (and (= q-n "table") (get params :id))
                   "table-by-id"
                   q-n)]
    (if (keyword? v) v
      (keyword v))))

#_(->> db
                          (dq/sql-with-params q-name params)
                          (dq/run-query (jdbc-execute app-context))
                          (dq/rename-keys )
                          (dq/identity-keys))

(defn handler
  "Default handler for query execution. Rename {name, parameter} using *rename-map* then execute query.

   @param {map} app-context \"App context must contain [:sqldb :conn] for database connection.
                             and [:sqldb :db] for query file.\"
   @param {string | keyword} name \"Name of the query.\"
   @param {map} params \"Parameter of the query.\"
   @return {vec} \" First -> data, second -> error. On of them will be null [data nil] or [nil data]\""
  [app-context n params]
  (try
    (let [q-name (if (keyword? n) n (keyword n))
          db (get-in app-context [:sqldb :db])
          e (jdbc-execute app-context)
          {:keys [data error]} (dq/load-data db e q-name params)]
      (if data data error))
    (catch Exception e
      (do
        (log/info (format "sql statement failed name: %s params: %s" name (pr-str params)))
        (log/error e)
        "Query operation fail, please check log "))))



(defn query-routes
  "Routes for query_handler

   @param {map} app-context \"App context map generated by system init\"
   @return {compojure.core.routes}"
  [app-context]
  (routes
    (GET "/" [:as {:keys [params]}]
         (resp/response (handler app-context (:name params) params)))
    (context "/:name" [name]
             (routes
               (GET "/" [:as {:keys [params]}]
                    (resp/response (handler app-context name params)))))))
