(ns {{name}}.modules.home.home-handler
   (:use
     [compojure.core])
   (:require
     [ring.util.response :as resp]))


(defn data []
  "return home data")

(defn home-routes
  "Routes for home_handler

  @param {map} app-context \"App context map generated by system init\"
  @return {compojure.core.routes}"
  [app-context]
  (routes
    (GET "/"  [:as r](resp/response [{:data "Get All"}]))
    (POST "/" [:as r](resp/response {:data "Create New"}))
    (context "/:id" [id]
             (routes
               (GET "/" [](resp/response {:data "Get ID"}))
               (DELETE "/" [](resp/response {:data "Delete"}))
               (PUT "/" [](resp/response {:data "Update"}))))) )
