(ns {{name}}.http-route.service-routes
    (:require
     [compojure.core :refer :all]
     [ring.util.response :as resp]
     [clojure.tools.logging :as log]
     [{{name}}.service.query-service :as q]
     [{{name}}.service.user-service :as u]))


(defn user-routes
  "Routes for user_handler

  @param {map} app-context \"App context map generated by system init\"
  @return {compojure.core.routes}"
  [app-context]
  (routes
    (POST "/" [:as {:keys [params]}]
          (resp/response (u/create! app-context params)))
    (context "/:id" [id]
             (routes
               (POST "/" [:as {:keys [params]}]
                     (resp/response (u/update! app-context id params)))))))


(defn query-routes
  "Routes for query_handler

   @param {map} app-context \"App context map generated by system init\"
   @return {compojure.core.routes}"
  [app-context]
  (routes
    (GET "/" [:as {:keys [params]}]
         (resp/response (q/data app-context (:name params) params)))
    (context "/:name" [name]
             (routes
               (GET "/" [:as {:keys [params]}]
                    (resp/response (q/data app-context name params)))))))
