(ns {{name}}.db
    (:require
     [clojure.tools.logging :as log]
     [clojure.java.jdbc :as sql]
     [tie.core :as tie]))


(defn init-db [tms db-conn]
  (log/info "Database initialization start. ")
  (doseq [d [:create-db :init-db]]
    (let [{:keys [sql]} (tie/get-module d tms)]
      (if sql
        (try
          (log/info (pr-str sql) )
          (apply sql/db-do-commands db-conn false sql)
          (log/info "Database initialization is done. ")
          (catch Exception e
            (log/error e)))))))


(defn clean-db [tms db-conn]
  (doseq [d [:drop-db]]
    (let [{:keys [sql]} (tie/get-module d tms)]
      (if sql
        (try
          (log/info (pr-str sql) )
          (apply sql/db-do-commands db-conn false sql)
          (log/info "Database cleaning is done.")
          (catch Exception e
            (log/info "Database cleaning error.")
            (log/error e)))))))
