/*
{:name "db-config"
 :doc "Data source for sql server "
 :datasource {:classname "org.h2.Driver"
              :subprotocol "h2:file"
              :subname "check"
              :user "sa"
              :password ""
              :maxPoolSize 6
              :minPoolSize 1
              :initialPoolSize 1}}
*/


/*
{:name "langById"
 :doc "Min Example "
 :sql "
*/
SELECT * FROM lang where id=:id;
-- "}


/*
{:name "lang"
 :doc "Full example "
 :default-params {:id 1}
 :rename-keys {:ID :LangId}
 :identity [:lang :designer]
 :sql "
*/
SELECT * FROM lang;
select * from lang_designer;
-- "}

/*
{:name "designer"
 :doc "Full example with validation "
 :default-params {:id 1}
 :validation {:id [(fn [v]
                     true)]}
 :rename-keys {:ID :LangId}
 :identity [:lang]
 :sql "
*/
SELECT * FROM lang where id=:id;
-- "}



