/*
{:name "db-config"
 :doc "Data source for sql server "
 :datasource {:classname "org.h2.Driver"
              :subprotocol "h2:file"
              :subname "check"
              :user "sa"
              :password ""
              :maxPoolSize 6
              :minPoolSize 1
              :initialPoolSize 1}}
*/

/*
{:name "create-db"
 :doc "Define create data defination "
 :sql "
*/

CREATE TABLE lang (
     id    integer PRIMARY KEY,
     name  varchar(40) NOT NULL
);

CREATE TABLE lang_designer (
     id   integer PRIMARY KEY,
     name varchar (40)
);

-- "}


/*
{:name "drop-db"
 :doc "Define drop data defination  "
 :sql "
*/
drop table lang;
drop table lang_designer;
-- "}


/*
{:name "init-db"
 :doc "Define drop data defination  "
 :sql "
*/
insert into lang values (1, 'C');
insert into lang values (2, 'Ptthon');
insert into lang values (3, 'Clojure');
insert into lang_designer values (1, 'Dennis Ritchie' );
insert into lang_designer values (2, 'Guido van Rossum' );
insert into lang_designer values (3, 'Rich Hickey' );
-- "}


/*
{:name "langById"
 :doc "Min Example "
 :sql "
*/
SELECT * FROM lang where id=:id;
-- "}


/*
{:name "lang"
 :doc "Full example "
 :default-params {:id 1}
 :rename-keys {:ID :LangId}
 :identity [:lang :designer]
 :sql "
*/
SELECT * FROM lang;
select * from lang_designer;
-- "}

/*
{:name "designer"
 :doc "Full example with validation "
 :default-params {:id 1}
 :validation {:id [(fn [v]
                     true)]}
 :rename-keys {:ID :LangId}
 :identity [:lang]
 :sql "
*/
SELECT * FROM lang where id=:id;
-- "}



