(ns dev
  (:use
   [ring.middleware file-info file])
  (:require
   [ring.server.standalone :refer :all]
   [{{name}}.core.lifeCycle :refer :all]))


(defonce handler nil)


(defn default-handler []
  (-> (fn [r]
        {:status 200
         :headers {"Content-Type" "text/html"}
         :body (pr-str r)})
      (wrap-file "resources/public")
      (wrap-file-info)))


(defrecord Server [^Integer port]
  LifeCycle
  (start [this comp]
    (println (get-in comp [:web :handler]))
    (alter-var-root #'handler (constantly (or (get-in comp [:web :handler]) (default-handler))))
    (if-not (nil? (:server this))
      this
      (let [port (if port port 8080)
            server (serve (var handler)
                          {:port port
                           :auto-reload? true
                           :join true
                           :open-browser? false})]
        (println (str "You can view the site at http://localhost:" port))
        (assoc this :server server))))
  (stop [this]
    (if (nil? (:server this))
      this
      (do
        (.stop (:server this))
        (alter-var-root #'handler (constantly nil))
        (dissoc this :server)))))





                                        ;(in-ns 'dev)
