(ns leiningen.new.web-app
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "web-app"))

(defn web-app
  "Generating clojure web app"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore")]

             ;; development file use only for development env
             ["dev-tools/user.clj" (render "dev-tools/user.clj" data)]
             ["dev-tools/dev.clj" (render "dev-tools/dev.clj" data)]

             ;;;;;;;;;;;;;;;;;;;;;;;;
             ;; Backend server file
             ;;;;;;;;;;;;;;;;;;;;;;;;
          ;   ["src/{{name}}/core/db_util.clj" (render "src/web_app/core/db_util.clj" data )]
             ["src/{{name}}/core/lifeCycle.clj" (render "src/web_app/core/lifeCycle.clj" data )]

             ["src/{{name}}/system.clj" (render "src/web_app/system.clj" data)]
            ; ["src/{{name}}/db.clj" (render "src/web_app/db.clj" data)]
             ["src/{{name}}/http_route/routes.clj" (render "src/web_app/http_route/routes.clj" data)]
             ["src/{{name}}/http_route/service_routes.clj" (render "src/web_app/http_route/service_routes.clj" data)]
             ["src/{{name}}/http_route/view/template.clj" (render "src/web_app/http_route/view/template.clj" data)]


            ; ["src/{{name}}/modules/user/user_util.clj" (render "src/web_app/modules/user/user_util.clj" data )]
             ["src/{{name}}/service/user_service.clj" (render "src/web_app/service/user_service.clj" data )]
             ["src/{{name}}/service/query_service.clj" (render "src/web_app/service/query_service.clj" data )]
           ;  ["src/{{name}}/modules/user/auth_handler.clj" (render "src/web_app/modules/user/auth_handler.clj" data )]

            ; ["src/{{name}}/modules/home/home_handler.clj" (render "src/web_app/modules/home/home_handler.clj" data )]

            ; ["src/{{name}}/modules/reporting/report_handler.clj" (render "src/web_app/modules/reporting/report_handler.clj" data )]
            ; ["src/{{name}}/modules/upload/upload_handler.clj" (render "src/web_app/modules/upload/upload_handler.clj" data )]

            ; ["src/{{name}}/modules/remote_handler.clj" (render "src/web_app/modules/remote_handler.clj" data )]


             ;;Testing file
           ;  ["test/{{name}}/routes_test.clj" (render "test/web_app/routes_test.clj" data)]
            ; ["test/{{name}}/views_test.clj" (render "test/web_app/views_test.clj" data)]
           ;  ["test/{{name}}/core/db_util_test.clj" (render "test/web_app/core/db_util_test.clj" data)]
             ;["test/{{name}}/modules/user/auth_handler_test.clj" (render "test/web_app/modules/user/auth_handler_test.clj" data)]
             ;["test/{{name}}/service/user_service_test.clj" (render "test/web_app/service/user_service_test.clj" data)]
             ["test/{{name}}/service/query_service_test.clj" (render "test/web_app/service/query_service_test.clj" data)]

             ;;config file for development mode
             ["resources/config/dev/logback.xml" (render "resources/config/dev/logback.xml" )]
             ["resources/config/dev/config.edn" (render "resources/config/dev/config.edn"  data)]
             ["resources/config/dev/db.sql" (render "resources/config/dev/db.sql")]
             ;;["resources/config/dev/datomicSchema.edn" (render "resources/config/dev/datomicSchema.edn")]

             ;;config file for production mode- uberjar, uberwar
             ["resources/config/prod/logback.xml" (render "resources/config/prod/logback.xml" )]
             ["resources/config/prod/config.edn" (render "resources/config/prod/config.edn"  data)]
             ["resources/config/prod/db.sql" (render "resources/config/prod/db.sql")]
             ;;["resources/config/prod/datomicSchema.edn" (render "resources/config/prod/datomicSchema.edn")]

             ;; For web module

             ["web/.bowerrc"
              (render "web/bowerrc" data)]
             ["web/package.json"
              (render "web/package.json" data)]
             ["web/bower.json"
              (render "web/bower.json" data)]
             ["web/Gruntfile.js"
              (render "web/Gruntfile.js" data)]


             ["web/resources/public/index.html"
              (render "web/resources/public/index.html" data)]
          ;   ["client/resources/public/inner.html"
          ;    (render "client/resources/public/inner.html"  )]
             ["web/resources/public/login.html"
              (render "web/resources/public/login.html"  data)]

         ;    ["client/resources/public/app/home/home.html"
         ;     (render "client/resources/public/app/home/home.html"  )]
         ;    ["client/resources/public/app/home/report.html"
         ;     (render "client/resources/public/app/home/report.html"  )]
         ;    ["client/resources/public/app/home/timeline.html"
         ;     (render "client/resources/public/app/home/timeline.html"  )]
         ;    ["client/resources/public/app/home/upload.html"
         ;     (render "client/resources/public/app/home/upload.html"  )]
         ;    ["client/resources/public/app/home/user.details.html"
         ;     (render "client/resources/public/app/home/user.details.html"  )]
         ;    ["client/resources/public/app/home/user.edit.html"
         ;     (render "client/resources/public/app/home/user.edit.html"  )]
         ;    ["client/resources/public/app/home/user.list.html"
        ;      (render "client/resources/public/app/home/user.list.html"  )]

             ["web/resources/public/assets/css/app.css"
              (render "web/resources/public/assets/css/app.css"  )]
            ; ["client/resources/public/assets/css/page.css"
            ;  (render "client/resources/public/assets/css/page.css"  )]
            ; ["client/resources/public/app/app.js"
            ;  (render "client/resources/public/app/app.js"  )]


             ;; For clojure+script module
             ["web/project.clj"
              (render "web/project.clj" data )]
             ["web/src/{{name}}/core.cljs"
              (render "web/src/web_app/core.cljs" data )]
            ; ["client/src/{{name}}/user.cljs"
            ;  (render "client/src/web_app/user.cljs" data )]
             ["web/src/{{name}}/api.cljs"
              (render "web/src/web_app/api.cljs" data )]
            ; ["client/src/{{name}}/macros.clj"
            ;  (render "client/src/web_app/macros.clj" data )]
             "web/test/{{name}}"
             ["web/resources/public/dev.html"
              (render "web/resources/public/dev.html" data)])))
