(ns {{name}}.views
   (:require
     [clojure.tools.logging :as log]
     [net.cgrand.enlive-html :as html]))


(html/deftemplate index-template "public/index.html" [{:keys [title]}]
  [:head :title] (html/content title)
  [:script html/any-node] (html/replace-vars {:name "world" }))


(html/deftemplate login-template "public/login.html" [title params]
  [:head :title] (html/content title)
  [:div#main-content :form ]
  (html/do->
   (html/set-attr :action "/login")
   (html/set-attr :method "POST"))
  [:div#main-content :form :p]
  (html/do->
   (html/content (if (not-empty  params) "Sorry, UserName or Password is wrong" ))
   (html/set-attr :style (if (not-empty  params)  "color:red" ))))



(defn index
  "Default template for index page use public/index.html"
  [{:keys [title]}]
  (apply str (index-template title)))


(defn login
  "Login template for login page use public/login.html

  @param {string} title \"Title of the template\"
  @param {map} params \"Form params \"
  @return {string} \" Return login tempalte as string\""
  [title params]
  (apply str (login-template title params)))
