(ns {{name}}.core
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [om.core :as om :include-macros true]
            [om.dom :as dom :include-macros true]
            [cljs.core.async :refer [put! chan]]))


(enable-console-print!)


(def app-state
  (atom
    {:view "edit"
     :contacts
     [{:first "Ben" :last "Bitdiddle" :email "benb@mit.edu"}
      {:first "Alyssa" :middle-initial "P" :last "Hacker" :email "aphacker@mit.edu"}
      {:first "Eva" :middle "Lu" :last "Ator" :email "eval@mit.edu"}
      {:first "Louis" :last "Reasoner" :email "prolog@mit.edu"}
      {:first "Cy" :middle-initial "D" :last "Effect" :email "bugs@mit.edu"}
      {:first "Lem" :middle-initial "E" :last "Tweakit" :email "morebugs@mit.edu"}]}))


(defn switch-view [ app view]
  (om/update! app assoc :view view))


(defn middle-name [{:keys [middle middle-initial]}]
  (cond
    middle (str " " middle)
    middle-initial (str " " middle-initial ".")))


(defn display-name [{:keys [first last] :as contact}]
  (str last ", " first (middle-name contact)))


(defn contact-view [app owner]
  (reify
    om/IRenderState
    (render-state [this state]
       (dom/div nil
          (dom/span nil (:first app))
          (dom/span nil " ")
          (dom/span nil (:last app))))))


(defn add-contact [app owner]
  (let [fname (-> (om/get-node owner "first")
                   .-value)
        lname (-> (om/get-node owner "last")
                   .-value)
        option (->(om/get-node owner "option")
                   .-value)
        v {:first fname :last lname}]
    (om/update! app update-in [:contacts] conj v)
    (om/update! app assoc :view "list")))


(defn handle-change [e owner {:keys [first]}]
  (let [value (.. e -target -value)]
    (if-not (re-find #"[0-9]" value)
      (om/set-state! owner :first value)
      (om/set-state! owner :first first))))


(defn add-contact-view [app owner]
  (reify
    om/IInitState
    (init-state [this]
      {:first "Check"
       :last "Add last name here"})
    om/IRenderState
    (render-state [this state]
      (dom/div nil
          (dom/input
           #js {:type "text"
                :ref "first"
                :value (:first state)
                :onChange #(handle-change % owner state)})
          (dom/br nil)
          (dom/input
           #js {:placeholder (:last state)
                :ref "last"})
          (dom/br nil)
          (dom/select #js {:ref "option"}
            (dom/option #js {:value 1} "One")
            (dom/option #js {:value 2} "Two"))
          (dom/br nil)
          (dom/br nil)
          (dom/button #js {:onClick #(add-contact app owner)} "Submit")))))



(defn contacts-view [app owner]
  (reify
    om/IRenderState
    (render-state [_ _]
        (dom/div nil
          (if (= (:view app) "edit")
            (dom/div #js {:className "panel panel-primary"}
              (dom/div #js {:className "panel-heading"}
               (dom/h4 nil "Personal Info"))
              (dom/div #js {:className "panel-body"}
               (om/build add-contact-view app )))
            (dom/div #js {:className "panel panel-primary"}
               (dom/div #js {:className "panel-heading"}
               (dom/h4 nil "Personal Info"))
               (dom/div #js {:className "panel-body"}
                (om/build-all contact-view (:contacts app))
                (dom/button #js {:onClick #(switch-view app "edit")} "Add New"))))))))


(om/root
 app-state
 contacts-view
 (. js/document (getElementById "contacts")))













