(ns {{name}}.modules.remote-handler
    (:use
     [compojure.core]
     [cljs.net.remote.service])
    (:require
     [cemerick.friend :as friend]
     [{{name}}.modules.user.user-handler :as u]))


(defremote user-defaults [[] & [opt]]
  {:sname "" :lname "" :id  "" })


(defremote user-delete [[user] & [{:keys [context request]}]]
  (u/user-delete! context user))


(defremote user-list [[page] & [{:keys [context request]}]]
  (u/user-list! context page))


(defremote user-details [[name] & [{:keys [context request]}]]
  (u/user-details! context name))


(defremote user-save [[user params] & [{:keys [context request]}]]
  (u/user-save! context user params) )


(defn handler [app-context]
  (let [r (routes
           (REMOTE POST "/_fetch" [:as request]
                   (fn [f] (f request {:request request
                                      :context app-context}))))]
    [(context "/remote" [] r)]))
