(ns {{name}}.modules.home.home-handler
    (:use
     [noir.request]
     [compojure.core] )
    (:require
      [cemerick.friend :as friend]
      [ring.util.response :as resp]))


(defn handler [app-context]
  (let [r (routes
           (GET "/"  [:as r]
                (resp/response [{:data "Get All"}]))
           (POST "/" [:as r]
                 (resp/response {:data "Create New"}))
           (context "/:id" [id]
                    (routes
                     (GET "/" []
                          (resp/response {:data "Get ID"}))
                     (DELETE "/" []
                             (resp/response {:data "Delete"}))
                     (PUT "/" []
                          (resp/response {:data "Update"})))))]
    [(context "/home" [] r)]))
