(ns {{name}}.modules.user.user-handler
  (:use
   [noir.request]
   [compojure.core]
   [cljs.net.remote.service])
  (:require
   [clojure.tools.logging :as log]
   [ring.util.response :as resp]
   [cemerick.friend :as friend]
   [{{name}}.modules.user.user :as u]))



(defn user-list! [context page]
  (log/info "Getting user list")
  (let [size 15
        page (Integer/parseInt (or page "1"))]
    (-> context
       (get-in [:datomic :conn])
       (u/find-all page size))))


(defn user-details! [context name]
  (log/info "Getting user details")
  (try
    (-> context
       (get-in [:datomic :conn])
       (u/find-by-name name))
    (catch Exception e
      {:error (.getMessage e)})) )


(defn user-save! [context params & [user]]
 (try
   (if (nil? user)
      (-> context
          (get-in [:datomic :conn])
          (u/create params))
      (-> context
          (get-in [:datomic :conn])
          (u/update user params)))
    {:success true}
    (catch Exception e
      (log/info (.getMessage e))
      {:error (.getMessage e)})))


(defn user-delete! [context user]
 (try
    (-> context
     (get-in [:datomic :conn])
     (u/delete user))
    {:success true}
    (catch Exception e
      {:error (.getMessage e)})))


(defn handler [app-context]
  (let [r (routes
           (GET "/"  [page :as r]
                (resp/response (user-list! app-context page)))
           (POST "/" [:as {:keys [params]}]
                (resp/response (user-save! app-context params )))
           (context "/:id" [id]
                    (routes
                     (GET "/" []
                          (resp/response (user-details! app-context id) ) )
                     (DELETE "/" []
                          (resp/response (user-delete! app-context id)))
                     (PUT "/" [:as {:keys [params]}]
                          (resp/response (user-save! app-context params id))))))]
    [(context "/user" [] (friend/authenticated r))]))



