(ns leiningen.new.web-app
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "web-app"))

(defn web-app
  "Generating clojure web app"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore")]

             ["dev/user.clj" (render "dev/user.clj" data)]
             ["dev/dev.clj" (render "dev/dev.clj" data)]

             ["src/logback.xml" (render "src/logback.xml" )]
             ["src/config.edn" (render "src/config.edn"  data)]
             ["src/db.sql" (render "src/db.sql")]
             ["src//datomicSchema.edn" (render "src/datomicSchema.edn")]

             ["src/{{name}}/core/db_util.clj" (render "src/web_app/core/db_util.clj" data )]
             ["src/{{name}}/core/lifeCycle.clj" (render "src/web_app/core/lifeCycle.clj" data )]

             ["src/{{name}}/system.clj" (render "src/web_app/system.clj" data)]
             ["src/{{name}}/handler.clj" (render "src/web_app/handler.clj" data)]
             ["src/{{name}}/db.clj" (render "src/web_app/db.clj" data)]


             ["src/{{name}}/modules/user/user_util.clj" (render "src/web_app/modules/user/user_util.clj" data )]
             ["src/{{name}}/modules/user/user.clj" (render "src/web_app/modules/user/user.clj" data )]
             ["src/{{name}}/modules/user/userdb.clj" (render "src/web_app/modules/user/userdb.clj" data )]
             ["src/{{name}}/modules/user/user_handler.clj" (render "src/web_app/modules/user/user_handler.clj" data )]
             ["src/{{name}}/modules/user/auth_handler.clj" (render "src/web_app/modules/user/auth_handler.clj" data )]

             ["src/{{name}}/modules/home/home_handler.clj" (render "src/web_app/modules/home/home_handler.clj" data )]

             ["src/{{name}}/modules/reporting/report.clj" (render "src/web_app/modules/reporting/report.clj" data )]
             ["src/{{name}}/modules/upload/upload_handler.clj" (render "src/web_app/modules/upload/upload_handler.clj" data )]

             ["src/{{name}}/modules/remote_handler.clj" (render "src/web_app/modules/remote_handler.clj" data )]
             ["src/{{name}}/modules/query_handler.clj" (render "src/web_app/modules/query_handler.clj" data )]

             ["test/{{name}}/modules/user_test.clj" (render "test/web_app/modules/user_test.clj" data)]
             ["test/{{name}}/modules/user_handler_test.clj" (render "test/web_app/modules/user_handler_test.clj" data)]


             ["resources/public/index.html" (render "resources/public/index.html" data)]

             ["resources/public/inner.html" (render "resources/public/inner.html"  )]
             ["resources/public/login.html" (render "resources/public/login.html"  )]

             ["resources/public/app/home/home.html" (render "resources/public/app/home/home.html"  )]
             ["resources/public/app/home/report.html" (render "resources/public/app/home/report.html"  )]
             ["resources/public/app/home/timeline.html" (render "resources/public/app/home/timeline.html"  )]
             ["resources/public/app/home/upload.html" (render "resources/public/app/home/upload.html"  )]
             ["resources/public/app/home/user.details.html" (render "resources/public/app/home/user.details.html"  )]
             ["resources/public/app/home/user.edit.html" (render "resources/public/app/home/user.edit.html"  )]
             ["resources/public/app/home/user.list.html" (render "resources/public/app/home/user.list.html"  )]

             ["resources/public/assets/css/app.css" (render "resources/public/assets/css/app.css"  )]
             ["resources/public/assets/css/page.css" (render "resources/public/assets/css/page.css"  )]
             ["resources/public/app/app.js" (render "resources/public/app/app.js"  )]

             ["resources/public/assets/lib/bootstrap/css/bootstrap-responsive.min.css" (render "resources/public/assets/lib/bootstrap/css/bootstrap-responsive.min.css"  )]
             ["resources/public/assets/lib/bootstrap/css/bootstrap.min.css" (render "resources/public/assets/lib/bootstrap/css/bootstrap.min.css"  )]
             ["resources/public/assets/lib/bootstrap/js/bootstrap.min.js" (render "resources/public/assets/lib/bootstrap/js/bootstrap.min.js"  )]

             ["resources/public/assets/lib/jquery-1.10.0.min.js" (render "resources/public/assets/lib/jquery-1.10.0.min.js")]
             ["resources/public/assets/lib/underscore-min.js" (render "resources/public/assets/lib/underscore-min.js")]

             ["resources/public/assets/lib/angular/angular.min.js" (render "resources/public/assets/lib/angular/angular.min.js")]
             ["resources/public/assets/lib/angular/angular-resource.min.js" (render "resources/public/assets/lib/angular/angular-resource.min.js")]
             ["resources/public/assets/lib/angular/angular-animate.min.js" (render "resources/public/assets/lib/angular/angular-animate.min.js")]
             ["resources/public/assets/lib/angular-ui-router.min.js" (render "resources/public/assets/lib/angular-ui-router.min.js"  )]
             ["resources/public/assets/lib/angular/bootstrap-gh-pages/ui-bootstrap-tpls-0.6.0.min.js" (render "resources/public/assets/lib/angular/bootstrap-gh-pages/ui-bootstrap-tpls-0.6.0.min.js"  )]

             ["cljs/project.clj" (render "cljs/project.clj" data )]
             ["cljs/src/{{name}}/user.cljs" (render "cljs/src/web_app/user.cljs" data )]
             ["cljs/src/{{name}}/api.cljs" (render "cljs/src/web_app/api.cljs" data )]
             ["cljs/src/{{name}}/macros.clj" (render "cljs/src/web_app/macros.clj" data )]
             "cljs/test/{{name}}"
             ["cljs/src-dev/repl.cljs" (render "cljs/src-dev/repl.cljs" data )]
             ["cljs/resources/public/cljs.html" (render "cljs/resources/public/cljs.html"  data)])))
