(ns {{name}}.core.db-util
  (:require
   [clojure.java.io :as io]))


(defn load-query [file-name]
  (let [sql-str (->
                 file-name
                 (io/resource)
                 (slurp)
                 (clojure.string/replace #"--|/\*|\*/|\n" ""))
        sql-str-list (str "(" sql-str ")")
        sql-list (read-string sql-str-list)]
    (reduce (fn [v c]
              (assoc v (keyword (:name c)) c))
            {} sql-list)))


(defn apply-params [m q]
  (if q
    (reduce
     (fn [acc [k v]] (clojure.string/replace acc (str k) (str v)))
     q m)))


(defn create-data-defination [v]
  (when-let [q (:sql (:create-dd v))]
    (clojure.string/split q #";")))



(defn drop-data-defination [v]
  (when-let [q (:sql (:drop-dd v))]
    (clojure.string/split q #";")))



(defn init-db [v]
  (when-let [q (:sql (:init-db v))]
    (clojure.string/split q #";")))



(defn get-query [v qname]
  (when-let [q (:sql (qname v))]
   (clojure.string/replace q #";" "")))
