(ns {{name}}.core.db-util
  (:require
   [clojure.java.io :as io]))


(defn load-query [file-name]
  (let [sql-str (->
                 file-name
                 (io/resource)
                 (slurp)
                 (clojure.string/replace #"--|/\*|\*/|\n" ""))
        sql-str-list (str "(" sql-str ")")
        sql-list (read-string sql-str-list)
        sql (reduce (fn [v c]
                      (assoc v (keyword (:name c)) c))
                    {} sql-list)]
    sql))


(defn create-data-defination [v]
  (-> v
      (:create-dd)
      (:sql)
      (clojure.string/split #";")))


(defn drop-data-defination [v]
  (-> v
      (:drop-dd)
      (:sql)
      (clojure.string/split #";")))


(defn init-db [v]
  (-> v
      (:init-db)
      (:sql)
      (clojure.string/split #";")))


(defn get-query [v qname]
  (-> v
      (qname)
      (:sql)
      (clojure.string/replace #";" "")))

