(ns user
  (:use
   [ring.server.standalone]
   [clojure.pprint :only [print-table]]
   [{{name}}.core.lifeCycle])
  (:require
   [clojure.java.io :as io]
   [clojure.string :as str]
   [clojure.pprint :refer (pprint)]
   [clojure.repl :refer :all]
   [clojure.test :as test]
   [clojure.tools.namespace.repl :refer (refresh refresh-all)]
   [dev :as dev]
   [{{name}}.system :as sys]))



(defonce the-system nil)

(defn- update-system [state & [c]]
  (condp = state
    :init
    (alter-var-root #'the-system (constantly c))
    :start
    (alter-var-root #'the-system (fn [s]
                                   (when s
                                     (if c
                                       (assoc s c (start (c s) s))
                                       (start s nil)))))
    :stop
    (alter-var-root #'the-system (fn [s]
                                   (when s
                                     (if c
                                       (assoc s c (stop (c s)))
                                       (stop s)))))))

(defn- find-by-comp [c s-c]
  (loop [m? false c c r []]
    (if (empty? c)
      r
      (let [m? (or (= s-c (first c)) m? )
            r (if m?
                (conj r (first c))
                r)]
        (recur m? (rest c) r)))))


(defn app [state & [comp]]
  (condp = state
    :init
    (let [server (dev/->Server 8083)
          cljs (dev/->Cljs 9000)
          s (-> (sys/system :dev)
                (assoc :cljs cljs)
                (assoc :server server)) ]
      (update-system :init s))

    :start
    (if comp
       (update-system :start comp)
       (do
         (update-system :start)
         (update-system :start :server)))

    :stop
    (if comp
        (update-system :stop comp)
        (do
          (update-system :stop)
          (update-system :stop :server)))

    :restart
    (let [r-c (find-by-comp sys/component-order comp)]
      (println (str "Restart component: " (pr-str r-c)))
      (doseq [c r-c] (update-system :stop c))
      (doseq [c r-c] (update-system :start c))
      (update-system :start :server))

    (println "Command not found"))
  state)


(defn command-handler [command]
  (println (str "Processing command"  command))
  (condp = command
    :F9
    (do
      (when (nil? the-system)
        (app :init))
      (if (nil? (get the-system :server))
        (app :start)
        (app :restart :web)))
    :C-F9 (app :stop)
    :C-F11 (app :start :cljs)
    :event  "dev"
    (println "command not found")))


