(ns dev
 (:use
  [ring.server.standalone]
  [ring.middleware file-info file]
  [{{name}}.core.lifeCycle])
 (:require
  [cemerick.piggieback :as p]
  [cljs.repl.browser]))


(defonce handler nil)


(defn default-handler []
  (-> (fn [r]
        {:status 200
         :headers {"Content-Type" "text/html"}
         :body (pr-str r)})
   (wrap-file "resources/public")
   (wrap-file-info)))


(defrecord Server [^Integer port]
  LifeCycle
  (start [this comp]
    (println (get-in comp [:web :handler]))
    (alter-var-root #'handler (constantly (or (get-in comp [:web :handler]) (default-handler))))
    (if-not (nil? (:server this))
      this
      (let [port (if port port 8080)
            server (serve (var handler)
                          {:port port
                           :auto-reload? true
                           :join true
                           :open-browser? false})]
        (println (str "You can view the site at http://localhost:" port))
        (assoc this :server server))))
  (stop [this]
    (if (nil? (:server this))
      this
      (do
        (.stop (:server this))
        (alter-var-root #'handler (constantly nil))
        (dissoc this :server)))))


(defrecord Cljs [^Integer port]
  LifeCycle
  (start [this comp]
    (println "Start cljs repl")
    (let [port (if port port 9000)
          r (p/cljs-repl
                :repl-env (doto
                            (cljs.repl.browser/repl-env :port port)
                            (cljs.repl/-setup)))]
      (assoc this :cljs r)))
  (stop [this]
    (println "Please type cljs/quit in repl")
    this))



;(in-ns 'dev)
