(ns {{name}}.system
  (:use [{{name}}.core])
  (:require [{{name}}.handler :as h]
            [{{name}}.db :as db]))


(defrecord Config []
  LifeCycle
  (start [this comp]
    (println "Reading config.............")
    (-> this
        (assoc :datomic-uri "datomic:mem://hello")
        (assoc :datomic-schema "hello/datomicSchema.edn")) )
  (stop [this] {}))


(defn start-web [comp]
  (start (h/->Web) comp))


(defonce component-order [:config :database :web])


(defrecord SystemRecord [config database web]
  LifeCycle
  (start [this comp]
    (println "System is starting..................")
    (reduce (fn [system key]
              (update-in system [key] start system))
            this
            component-order))
  (stop [this]
    (println "System is going to stop")
    (reduce (fn [system key]
              (update-in system [key] stop))
            this
            (reverse component-order))))


(defn system []
  "Returns a new instance of the whole application."
  (start (->SystemRecord
          (->Config)
          (db/->Database)
          (h/->Web)) nil))



(defonce handler nil)
(defonce the-system nil)



(defn init
  "Init application, set web handler"
  ([] (init (system)))
  ([s]
     (alter-var-root #'the-system (constantly s))
     (alter-var-root #'handler (constantly (:handler (:web the-system))))
     (println "App start successfully")))



(defn destroy
  "Clean application resource, release database connection"
  ([] (destroy true))
  ([destroy?]
     (println "System is going to down ")
     (if destroy?
       (do
         (println "Stoping service...")
         (stop the-system)
         (alter-var-root #'the-system (constantly nil))
         (alter-var-root #'handler (constantly nil))))))
