(ns {{name}}.db
  (:use
   [datomic.api :only [q db] :as d]
   [{{name}}.core])
  (:import com.mchange.v2.c3p0.ComboPooledDataSource)
  (:require  [clojure.java.jdbc :as sql]
             [clojure.java.io :as io]
             [{{name}}.modules.user :as u]
             [{{name}}.modules.user-util :as u-util]))


(def ^:dynamic db-config
  {:classname "org.postgresql.Driver"
   :subprotocol "postgresql"
   :subname "//localhost:5432/zme"
   :user "postgres"
   :password "postgres"})

(defn pool
  [config]
  (let [cpds (doto (ComboPooledDataSource.)
               (.setDriverClass (:classname config))
               (.setJdbcUrl (str "jdbc:" (:subprotocol config) ":" (:subname config)))
               (.setUser (:user config))
               (.setPassword (:password config))
               (.setMaxPoolSize 6)
               (.setMinPoolSize 1)
               (.setInitialPoolSize 1))]
    {:datasource cpds}))

(defonce pooled-db (delay (pool db-config)))

(defn db-connection [] @pooled-db)

(defn create-schema [db-connection]
  (sql/with-connection (db-connection)
    (sql/create-table :documents [:id "varchar(256)" "primary key"]
                      [:title "varchar(1024)"]
                      [:text :varchar])) )

(defn delete-schema [db-connection]
  (sql/with-connection (db-connection)
    (sql/drop-table :documents)))




(def ^:dynamic uri "datomic:mem://{{name}}")
(def ^:dynamic schema-tx (->
                          "{{name}}/datomicSchema.edn"
                          (io/resource )
                          (slurp )
                          (read-string )))

(defonce connection (delay (when (d/create-database uri)
                             @(d/transact (d/connect uri) schema-tx))
                           (d/connect uri)))


(defn delete-db []
  (d/delete-database uri))


(defrecord Database []
  LifeCycle
  (start [this comp]
    (println "Database is starting...........")
    (u/insert-all @connection (u-util/get-random-data 25 ))
    (println (str "Total data" (count (u/find-all @connection 1 15 ))))
    (-> this
        (assoc :datomic-conn @connection)))
  (stop [this]
    (println "Database is going to stop")
    (delete-db)
    (assoc this :datomic-conn nil)))


         ; (assoc :sqldb sqldb/db-connection)
