(ns dev
  (:use
   [ring.server.standalone]
   [clojure.pprint :only [print-table]]
   [{{name}}.core])
  (:require [{{name}}.system :as sys]
            [{{name}}.handler :as h]))



(defn server-start [ & [port] ]
  (let [port (if port (Integer/parseInt port) 8080)
        server (serve (var sys/handler)
                      {:port port
                       :auto-reload? true
                       :join true
                       :open-browser? false})]
    (println (str "You can view the site at http://localhost:" port))
    server ))


(defonce the-system nil)


(defn init-app []
  (when (nil? the-system)
    (println "init system")
    (alter-var-root #'the-system (constantly (sys/system)))))


(defn restart-app []
  (alter-var-root #'the-system
                  (fn [s]
                    (let [s (assoc s :web (start (h/->Web) s))]
                      (sys/init s)
                      s))))


(defn start-app []
  "used for starting the server in development mode from REPL"
  (init-app)
  (if (nil? (get the-system :server))
    (alter-var-root #'the-system
                    (fn [s]
                      (sys/init s)
                      (assoc s :server (server-start ))))
    (restart-app)))


(defn stop-app []
  (alter-var-root #'the-system
                  (fn [s] (when s
                           (.stop (:server s))
                           (sys/destroy false)
                           (dissoc s :server)))))


(defn command-execute [command]
  (println (str "Processing command"  command))
  (cond
   (= :start command) (start-app)
   (= :stop command) (stop-app)
   :else (println "command not found")) )
