(ns {{name}}.modules.user-handler
  (:use
   [noir.request]
   [compojure.core]
   [cljs.net.remote.service])
  (:require
   [clojure.tools.logging :as log]
   [ring.util.response :as resp]
  ; [ring.middleware.json :as json]
  ; [ring.util.response :as resp]
  ; [cemerick.friend :as friend]
   [{{name}}.modules.user :as u]))



(defn user-list! [context page]
  (log/info "Getting user list")
  (let [size 15
        page (Integer/parseInt (or page "1"))]
    (->
     (:datomic-conn context)
     (u/find-all page size))))


(defn user-details! [context name]
  (log/info "Getting user details")
  (try
    (->
     (:datomic-conn context)
     (u/find-by-name name))
    (catch Exception e
      {:error (.getMessage e)})) )


(defn user-save! [context params & [user]]
 (try
   (if (nil? user)
      (do
        (u/create (:datomic-conn context) params))
      (do
        (u/update (:datomic-conn context) user params)))
    {:success true}
    (catch Exception e
      (log/info (.getMessage e))
      {:error (.getMessage e)})))


(defn user-delete! [context user]
 (try
    (->
     (:datomic-conn context)
     (u/delete user))
    {:success true}
    (catch Exception e
      {:error (.getMessage e)})))


(defn handler [app-context]
  (let [r (routes
           (GET "/"  [page :as r]
                (resp/response (user-list! app-context page)))
           (POST "/" [:as {:keys [params]}]
                (resp/response (user-save! app-context params )))
           (context "/:id" [id]
                    (routes
                     (GET "/" []
                          (resp/response (user-details! app-context id) ) )
                     (DELETE "/" []
                          (resp/response (user-delete! app-context id)))
                     (PUT "/" [:as {:keys [params]}]
                          (resp/response (user-save! app-context params id))))))]
    [(context "/user" [] r)]))



(defremote user-defaults [[] & [opt]]
  {:sname "" :lname "" :id  "" })

(defremote user-delete [[user] & [{:keys [context request]}]]
  (user-delete! context user))

(defremote user-list [[page] & [{:keys [context request]}]]
  (user-list! context page))

(defremote user-details [[name] & [{:keys [context request]}]]
  (user-details! context name))

(defremote user-save [[user params] & [{:keys [context request]}]]
  (user-save! context user params) )
