(ns leiningen.new.web-app
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "web-app"))

(defn web-app
  "Generating clojure web app"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ["project.clj" (render "project.clj" data)]
             [".gitignore" (render "gitignore")]
             ["dev/user.clj" (render "dev/user.clj" data)]
             ["dev/dev.clj" (render "dev/dev.clj" data)]
             ["src/{{name}}/system.clj" (render "src/zme/system.clj" data)]

             ["src/{{name}}/handler.clj" (render "src/zme/handler.clj" data)]
             ["src/{{name}}/sqldb.clj" (render "src/zme/sqldb.clj" data)]

             ["src/{{name}}/datomic.clj" (render "src/zme/datomic.clj" data )]
             ["src/{{name}}/datomicSchema.edn" (render "src/zme/datomicSchema.edn" data )]

             ["src/{{name}}/modules/user_util.clj" (render "src/zme/modules/user_util.clj" data )]
             ["src/{{name}}/modules/user.clj" (render "src/zme/modules/user.clj" data )]
             ["src/{{name}}/modules/userdb.clj" (render "src/zme/modules/userdb.clj" data )]
             ["src/{{name}}/modules/user_handler.clj" (render "src/zme/modules/user_handler.clj" data )]

             ["src/{{name}}/modules/auth_handler.clj" (render "src/zme/modules/auth_handler.clj" data )]
             ["src/{{name}}/modules/home_handler.clj" (render "src/zme/modules/home_handler.clj" data )]
             ["src/{{name}}/modules/remote_handler.clj" (render "src/zme/modules/remote_handler.clj" data )]

             ["src/{{name}}/app_service/report.clj" (render "src/zme/app_service/report.clj" data )]
             ["src/{{name}}/app_service/upload_handler.clj" (render "src/zme/app_service/upload_handler.clj" data )]

             ["resources/log4j.properties" (render "resources/log4j.properties"  )]
             ["resources/public/index.html" (render "resources/public/index.html"  )]
             ["resources/public/inner.html" (render "resources/public/inner.html"  )]
             ["resources/public/login.html" (render "resources/public/login.html"  )]

             ["resources/public/app/home/home.html" (render "resources/public/app/home/home.html"  )]
             ["resources/public/app/home/report.html" (render "resources/public/app/home/report.html"  )]
             ["resources/public/app/home/timeline.html" (render "resources/public/app/home/timeline.html"  )]
             ["resources/public/app/home/upload.html" (render "resources/public/app/home/upload.html"  )]
             ["resources/public/app/home/user.details.html" (render "resources/public/app/home/user.details.html"  )]
             ["resources/public/app/home/user.edit.html" (render "resources/public/app/home/user.edit.html"  )]
             ["resources/public/app/home/user.list.html" (render "resources/public/app/home/user.list.html"  )]

             ["resources/public/assets/css/app.css" (render "resources/public/assets/css/app.css"  )]
             ["resources/public/assets/css/page.css" (render "resources/public/assets/css/page.css"  )]
             ["resources/public/app/app.js" (render "resources/public/app/app.js"  )]


             ["resources/public/assets/lib/bootstrap/css/bootstrap-responsive.min.css" (render "resources/public/assets/lib/bootstrap/css/bootstrap-responsive.min.css"  )]
             ["resources/public/assets/lib/bootstrap/css/bootstrap.min.css" (render "resources/public/assets/lib/bootstrap/css/bootstrap.min.css"  )]
             ["resources/public/assets/lib/bootstrap/js/bootstrap.min.js" (render "resources/public/assets/lib/bootstrap/js/bootstrap.min.js"  )]

             ["resources/public/assets/lib/jquery-1.10.0.min.js" (render "resources/public/assets/lib/jquery-1.10.0.min.js")]
             ["resources/public/assets/lib/underscore-min.js" (render "resources/public/assets/lib/underscore-min.js")]

             ["resources/public/assets/lib/angular/angular.min.js" (render "resources/public/assets/lib/angular/angular.min.js")]
             ["resources/public/assets/lib/angular/angular-resource.min.js" (render "resources/public/assets/lib/angular/angular-resource.min.js")]
             ["resources/public/assets/lib/angular/angular-animate.min.js" (render "resources/public/assets/lib/angular/angular-animate.min.js")]
             ["resources/public/assets/lib/angular-ui-router.min.js" (render "resources/public/assets/lib/angular-ui-router.min.js"  )]
             ["resources/public/assets/lib/angular/bootstrap-gh-pages/ui-bootstrap-tpls-0.6.0.min.js" (render "resources/public/assets/lib/angular/bootstrap-gh-pages/ui-bootstrap-tpls-0.6.0.min.js"  )]



             ["cljs/src/{{name}}/user.cljs" (render "cljs/src/zme/user.cljs" )]
             "cljs/test/{{name}}"
             ["cljs/src-dev/repl.cljs" (render "cljs/src-dev/repl.cljs" )]

             )))
