(ns {{name}}.userdb
  (:import com.mchange.v2.c3p0.ComboPooledDataSource)
  (:require  [clojure.java.jdbc :as sql]))

                                        ;sudo su - postgres
                                        ;psql zme
                                        ;stop logout

(defn uuid [] (str (java.util.UUID/randomUUID)))


(defn get-all-documents [db-connection]
  (sql/with-connection (db-connection)
    (sql/with-query-results results
      ["select * from documents"]
      (into [] results))))


(defn get-document [db-connection id]
  (sql/with-connection (db-connection)
    (sql/with-query-results results
      ["select * from documents where id = ?" id]
      (cond
       (empty? results) {:status 404}
       :else  (first results)))))


(defn create-new-document [db-connection doc]
  (let [id (uuid)]
    (sql/with-connection (db-connection)
      (let [document (assoc doc "id" id)]
        (sql/insert-record :documents document)))
    (get-document db-connection id)))


(defn update-document [db-connection id doc]
  (sql/with-connection (db-connection)
    (let [document (assoc doc "id" id)]
      (sql/update-values :documents ["id=?" id] document)))
  (get-document id))


(defn delete-document [db-connection id]
  (sql/with-connection (db-connection)
    (sql/delete-rows :documents ["id=?" id]))
  {:status 204})



(comment
  (use 'dev)

  (println (create-new-document (:sqldb the-system) {:title "Mamun" :text "Hello test "}))
  (println (get-all-documents (:sqldb the-system)))
  (println (get-document (:sqldb the-system) "a39d6f68-0f58-41c5-8dcf-c8d051007474" ))
  (println "Hello test "))
