(ns marram.core
  (:require ["max-api" :as max-api]
            [cljs.core.async :as core.async]))

(defn post
  [level & args]
  (apply (.-post max-api) (conj args level)))

(defn debug
  [& args]
  (apply post "DEBUG" args))

(defn info
  [& args]
  (apply post "INFO" args))

(defn warn
  [& args]
  (apply post "WARN" args))

(defn error
  [& args]
  (apply post "ERROR" args))

(defn get-dict
  [id]
  (.getDict max-api id))

(defn set-dict
  [id content]
  (.setDict max-api id content))

(defn update-dict
  [id content value]
  (.updateDict max-api id content value))

(defn outlet-bang
  []
  (.outletBang max-api))

(defn outlet
  [& args]
  (apply (.-outlet max-api) args))

(defn handle-message
  [ch handled? msg-type & args]
  (let [event {:handled? handled?
               :type     msg-type
               :args     args}]
    (core.async/put! ch event)))

(defn init! [ch]
  (.addHandler max-api "all" (partial handle-message ch))
  (info "♫♪♬... marram.core initialized"))