(defproject wavejumper/jax "1.0.0-alpha3"
  :description "An interactive programming environment for Max"
  :url "https://github.com/wavejumper/jax"

  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/core.async "1.2.603"]
                 [org.clojure/tools.deps.alpha "0.9.763"
                  :exclusions [org.eclipse.jetty/jetty-client
                               org.eclipse.jetty/jetty-util]]
                 [org.eclipse.jetty/jetty-client "9.4.30.v20200611"]
                 [org.tcrawley/dynapath "1.1.0"]
                 [wavejumper/tonal "3.6.5-3"]
                 [wavejumper/jax-patcher "2.0.0-alpha23"]
                 [potemkin "0.4.5"]
                 [expound "0.8.5"]
                 [org.jetbrains.pty4j/pty4j "0.9.8" :scope "provided"]
                 [info.sunng/ring-jetty9-adapter "0.14.0"
                  :exclusions [org.eclipse.jetty/jetty-alpn-conscrypt-server
                               org.conscrypt/conscrypt-openjdk-uber]]
                 [ring/ring-core "1.8.1"]
                 [net.cgrand/parsley "0.9.3" :exclusions [org.clojure/clojure]]
                 [reply "0.4.4"]
                 [wavejumper/sente "1.15.1"]
                 [org.clojure/tools.logging "1.1.0"]
                 [ring/ring-defaults "0.3.2"]
                 [org.clojure/test.check "1.1.0"]
                 ;[org.eclipse.elk/org.eclipse.elk.graph.json "0.7.0"]
                 ]

  :repositories [["bintray-jetbrains-pty4j" {:id  "bintray"
                                             :url "https://jetbrains.bintray.com/pty4j"}]]

  ;; see README.md for instructions on how to resolve this dep
  :profiles {:dev     {:dependencies   [[com.cycling74/max "0.1"]]
                       :resource-paths ["dev-resources"]}

             :clojars {:dependencies [[com.cycling74/max "0.1" :scope "provided"]]}

             :kaocha  {:dependencies [[lambdaisland/kaocha "1.0.632"]]}

             :kondo   {:dependencies [[clj-kondo "2020.06.12"]]}

             :uberjar {:prep-tasks   ["clean" "javac" "compile"]
                       :dependencies [[com.cycling74/max "0.1"]
                                      [nrepl "0.4.0"]]}

             :cljfmt  {:plugins [[lein-cljfmt "0.6.7"]]
                       :cljfmt  {:indents {patch        [[:block 1]]
                                           char-handler [[:block 1]]}}}}

  :aliases {"docs"     ["with-profile" "+doc" "codox"]
            "kaocha"   ["with-profile" "+kaocha" "run" "-m" "kaocha.runner"]
            "kondo"    ["with-profile" "+kondo" "run" "-m" "clj-kondo.main" "--lint" "src"]
            "fmtfix"   ["with-profile" "+cljfmt" "cljfmt" "fix"]
            "fmtcheck" ["with-profile" "+cljfmt" "cljfmt" "check"]}

  :compile-path "target"

  :test-paths ["test"]

  :resource-paths ["resources"]

  :source-paths ["src/clojure"]

  :java-source-paths ["src/java"]

  :jvm-opts ["-XX:+UnlockExperimentalVMOptions"
             "-XX:+EnableJVMCI"])